/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.amf;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.codec.binary.Hex;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.io.amf.AMF;
import org.red5.io.amf3.ByteArray;
import org.red5.io.object.BaseInput;
import org.red5.io.object.Deserializer;
import org.red5.io.object.RecordSet;
import org.red5.io.object.RecordSetPage;
import org.red5.io.utils.ArrayUtils;
import org.red5.io.utils.ConversionUtils;
import org.red5.io.utils.ObjectMap;
import org.red5.io.utils.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class Input
extends BaseInput
implements org.red5.io.object.Input {
    protected static Logger log = LoggerFactory.getLogger(Input.class);
    protected static Map<String, String> classAliases = new HashMap<String, String>(3){
        {
            this.put("DSA", "org.red5.compatibility.flex.messaging.messages.AsyncMessageExt");
            this.put("DSC", "org.red5.compatibility.flex.messaging.messages.CommandMessageExt");
            this.put("DSK", "org.red5.compatibility.flex.messaging.messages.AcknowledgeMessageExt");
        }
    };
    protected IoBuffer buf;
    protected byte currentDataType;

    public Input(IoBuffer buf) {
        this.buf = buf;
        if (log.isTraceEnabled()) {
            log.trace("Input: {}", (Object)Hex.encodeHexString((byte[])Arrays.copyOfRange(buf.array(), buf.position(), buf.limit())));
        }
    }

    @Override
    public byte readDataType() {
        do {
            this.currentDataType = this.buf.get();
            log.trace("Data type: {}", (Object)this.currentDataType);
            switch (this.currentDataType) {
                case 5: 
                case 6: {
                    return 1;
                }
                case 0: {
                    return 3;
                }
                case 1: {
                    return 2;
                }
                case 2: 
                case 12: {
                    return 4;
                }
                case 3: 
                case 16: {
                    return 9;
                }
                case 8: {
                    return 7;
                }
                case 10: {
                    return 6;
                }
                case 11: {
                    return 5;
                }
                case 15: {
                    return 8;
                }
                case 7: {
                    return 17;
                }
                case 4: 
                case 13: 
                case 14: {
                    return (byte)(this.currentDataType + 48);
                }
                case 17: {
                    log.debug("Switch to AMF3");
                }
            }
        } while (this.hasMoreProperties());
        log.trace("No more data types available");
        return -1;
    }

    @Override
    public Object readNull() {
        return null;
    }

    @Override
    public Boolean readBoolean() {
        return this.buf.get() == 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Number readNumber() {
        int remaining = this.buf.remaining();
        log.debug("readNumber from {} bytes", (Object)remaining);
        if (remaining >= 8) {
            double d = this.buf.getDouble();
            log.debug("Number: {}", (Object)d);
            return d;
        }
        if (log.isDebugEnabled()) {
            log.debug("Remaining not big enough for number - offset: {} limit: {} {}", new Object[]{this.buf.position(), this.buf.limit(), Hex.encodeHexString((byte[])this.buf.array())});
        }
        return 0;
    }

    @Override
    public String getString() {
        log.trace("getString - currentDataType: {}", (Object)this.currentDataType);
        byte lastDataType = this.currentDataType;
        if (this.currentDataType != 2) {
            this.currentDataType = (byte)2;
        }
        String result = this.readString();
        this.currentDataType = lastDataType;
        return result;
    }

    @Override
    public String readString() {
        int limit = this.buf.limit();
        int len = 0;
        switch (this.currentDataType) {
            case 12: {
                log.trace("Long string type");
                len = this.buf.getInt();
                if (len <= limit) break;
                len = limit;
                break;
            }
            case 2: {
                log.trace("Std string type");
                len = this.buf.getUnsignedShort();
                break;
            }
            default: {
                log.debug("Unknown AMF type: {}", (Object)this.currentDataType);
            }
        }
        log.debug("Length: {} limit: {}", (Object)len, (Object)limit);
        byte[] str = new byte[len];
        this.buf.get(str);
        String string = Input.bufferToString(str);
        return string;
    }

    private static final String bufferToString(byte[] str) {
        String string = null;
        if (str != null) {
            string = AMF.CHARSET.decode(ByteBuffer.wrap(str)).toString();
            log.debug("String: {}", (Object)string);
        } else {
            log.warn("ByteBuffer was null attempting to read String");
        }
        return string;
    }

    @Override
    public Date readDate() {
        long ms = (long)this.buf.getDouble();
        short timeZoneMins = this.buf.getShort();
        Date date = new Date(ms);
        this.storeReference(date);
        return date;
    }

    @Override
    public Object readArray(Type target) {
        log.debug("readArray - target: {}", (Object)target);
        Object result = null;
        int count = this.buf.getInt();
        log.debug("Count: {}", (Object)count);
        Class collection = Collection.class;
        if (target instanceof Class) {
            collection = (Class)target;
        }
        ArrayList resultCollection = new ArrayList(count);
        result = collection.isArray() ? ArrayUtils.getArray(collection.getComponentType(), count) : resultCollection;
        this.storeReference(result);
        for (int i = 0; i < count; ++i) {
            resultCollection.add(Deserializer.deserialize(this, Object.class));
        }
        if (collection.isArray()) {
            ArrayUtils.fillArray(collection.getComponentType(), result, resultCollection);
        }
        return result;
    }

    @Override
    public Map<String, Object> readKeyValues() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.readKeyValues(result);
        return result;
    }

    protected void readKeyValues(Map<String, Object> result) {
        do {
            String name = this.readPropertyName();
            log.debug("property: {}", (Object)name);
            Object property = Deserializer.deserialize(this, Object.class);
            log.debug("val: {}", property);
            result.put(name, property);
            if (!this.hasMoreProperties()) break;
            this.skipPropertySeparator();
        } while (this.hasMoreProperties());
    }

    @Override
    public Object readMap() {
        Cloneable result;
        int maxNumber = this.buf.getInt();
        log.debug("Read start mixed array: {}", (Object)maxNumber);
        LinkedHashMap<Object, Object> mixedResult = new LinkedHashMap<Object, Object>(maxNumber);
        int reference = this.storeReference(mixedResult);
        Boolean normalArray = true;
        while (this.hasMoreProperties()) {
            String key = this.getString();
            log.debug("key: {}", (Object)key);
            try {
                Integer.parseInt(key);
            }
            catch (NumberFormatException e) {
                log.debug("key {} is causing non normal array", (Object)key);
                normalArray = false;
            }
            Object item = Deserializer.deserialize(this, Object.class);
            log.debug("item: {}", item);
            mixedResult.put(key, item);
        }
        if (mixedResult.size() <= maxNumber + 1 && normalArray.booleanValue()) {
            log.debug("mixed array is a regular array");
            ArrayList listResult = new ArrayList(maxNumber);
            for (int i = 0; i < maxNumber; ++i) {
                listResult.add(i, mixedResult.get(String.valueOf(i)));
            }
            result = listResult;
        } else {
            mixedResult.remove("length");
            for (int i = 0; i < maxNumber; ++i) {
                Object value = mixedResult.remove(String.valueOf(i));
                mixedResult.put(i, value);
            }
            result = mixedResult;
        }
        this.storeReference(reference, result);
        return result;
    }

    protected Object newInstance(String className) {
        log.debug("Loading class: {}", (Object)className);
        Object instance = null;
        Class<?> clazz = null;
        if ("".equals(className) || className == null) {
            return instance;
        }
        try {
            if (className.length() == 3) {
                className = classAliases.get(className);
            }
            if (className.startsWith("flex.")) {
                className = "org.red5.compatibility." + className;
                log.debug("Modified classname: {}", (Object)className);
            }
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            instance = clazz.newInstance();
        }
        catch (InstantiationException iex) {
            try {
                clazz.getConstructor(null);
                log.error("Error loading class: {}", (Object)className);
            }
            catch (NoSuchMethodException nse) {
                log.error("Error loading class: {}; this can be resolved by adding a default constructor to your class", (Object)className);
            }
            log.debug("Exception was: {}", (Throwable)iex);
        }
        catch (Exception ex) {
            log.error("Error loading class: {}", (Object)className);
            log.debug("Exception was: {}", (Throwable)ex);
        }
        return instance;
    }

    protected Object readBean(Object bean) {
        log.debug("readBean: {}", bean);
        this.storeReference(bean);
        Class<?> theClass = bean.getClass();
        while (this.hasMoreProperties()) {
            String name = this.readPropertyName();
            Type type = this.getPropertyType(bean, name);
            log.debug("property: {} type: {}", (Object)name, (Object)type);
            Object property = Deserializer.deserialize(this, type);
            log.debug("val: {}", property);
            if (property != null) {
                try {
                    Class t;
                    if (type instanceof Class && !(t = (Class)type).isAssignableFrom(property.getClass())) {
                        property = ConversionUtils.convert(property, t);
                    }
                    Field field = theClass.getField(name);
                    field.set(bean, property);
                }
                catch (Exception ex2) {
                    try {
                        BeanUtils.setProperty((Object)bean, (String)name, property);
                    }
                    catch (Exception ex) {
                        log.error("Error mapping property: {} ({})", (Object)name, property);
                    }
                }
            } else {
                log.debug("Skipping null property: {}", (Object)name);
            }
            if (!this.hasMoreProperties()) break;
            this.skipPropertySeparator();
        }
        return bean;
    }

    protected Map<String, Object> readSimpleObject() {
        log.debug("readSimpleObject");
        ObjectMap<String, Object> result = new ObjectMap<String, Object>();
        this.readKeyValues(result);
        this.storeReference(result);
        return result;
    }

    @Override
    public Object readObject() {
        if (this.currentDataType == 16) {
            String className = this.getString();
            log.debug("readObject: {}", (Object)className);
            if (className != null) {
                log.debug("read class object");
                Map<String, Object> result = null;
                if (className.equals("RecordSet")) {
                    result = new RecordSet(this);
                    this.storeReference(result);
                } else if (className.equals("RecordSetPage")) {
                    result = new RecordSetPage(this);
                    this.storeReference(result);
                } else {
                    Object instance = this.newInstance(className);
                    if (instance != null) {
                        result = this.readBean(instance);
                    } else {
                        log.debug("Forced to use simple object for class {}", (Object)className);
                        result = this.readSimpleObject();
                    }
                }
                return result;
            }
        }
        return this.readSimpleObject();
    }

    public boolean hasMoreProperties() {
        if (this.buf.remaining() >= 3) {
            byte[] threeBytes = new byte[3];
            int pos = this.buf.position();
            this.buf.get(threeBytes);
            if (Arrays.equals(AMF.END_OF_OBJECT_SEQUENCE, threeBytes)) {
                log.trace("End of object");
                return false;
            }
            this.buf.position(pos);
            return true;
        }
        return true;
    }

    public String readPropertyName() {
        return this.getString();
    }

    public void skipPropertySeparator() {
    }

    @Override
    public Document readXML() {
        String xmlString = this.readString();
        Document doc = null;
        try {
            doc = XMLUtils.stringToDoc(xmlString);
        }
        catch (IOException ioex) {
            log.error("IOException converting xml to dom", (Throwable)ioex);
        }
        this.storeReference(doc);
        return doc;
    }

    @Override
    public Object readCustom() {
        return null;
    }

    @Override
    public ByteArray readByteArray() {
        throw new RuntimeException("ByteArray objects not supported with AMF0");
    }

    @Override
    public Vector<Integer> readVectorInt() {
        throw new RuntimeException("Vector objects not supported with AMF0");
    }

    @Override
    public Vector<Long> readVectorUInt() {
        throw new RuntimeException("Vector objects not supported with AMF0");
    }

    @Override
    public Vector<Double> readVectorNumber() {
        throw new RuntimeException("Vector objects not supported with AMF0");
    }

    @Override
    public Vector<Object> readVectorObject() {
        throw new RuntimeException("Vector objects not supported with AMF0");
    }

    @Override
    public Object readReference() {
        return this.getReference(this.buf.getUnsignedShort());
    }

    public void reset() {
        this.clearReferences();
    }

    protected Type getPropertyType(Object instance, String propertyName) {
        try {
            if (instance != null) {
                Field field = instance.getClass().getField(propertyName);
                return field.getGenericType();
            }
        }
        catch (NoSuchFieldException e1) {
            try {
                BeanUtilsBean beanUtilsBean = BeanUtilsBean.getInstance();
                PropertyUtilsBean propertyUtils = beanUtilsBean.getPropertyUtils();
                PropertyDescriptor propertyDescriptor = propertyUtils.getPropertyDescriptor(instance, propertyName);
                return propertyDescriptor.getReadMethod().getGenericReturnType();
            }
            catch (Exception exception) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Object.class;
    }
}

