/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.object;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Random;
import org.red5.io.object.UnsignedNumber;

public final class UnsignedLong
extends UnsignedNumber {
    private static final long serialVersionUID = 1L;
    private byte[] value = new byte[8];

    public UnsignedLong(byte c) {
        Arrays.fill(this.value, (byte)0);
        this.value[7] = c;
    }

    public UnsignedLong(short c) {
        Arrays.fill(this.value, (byte)0);
        this.value[6] = (byte)(c >> 8 & 0xFF);
        this.value[7] = (byte)(c & 0xFF);
    }

    public UnsignedLong(int c) {
        Arrays.fill(this.value, (byte)0);
        this.value[4] = (byte)(c >> 24 & 0xFF);
        this.value[5] = (byte)(c >> 16 & 0xFF);
        this.value[6] = (byte)(c >> 8 & 0xFF);
        this.value[7] = (byte)(c & 0xFF);
    }

    public UnsignedLong(long c) {
        this.value[0] = (byte)(c >> 56 & 0xFFL);
        this.value[1] = (byte)(c >> 48 & 0xFFL);
        this.value[2] = (byte)(c >> 40 & 0xFFL);
        this.value[3] = (byte)(c >> 32 & 0xFFL);
        this.value[4] = (byte)(c >> 24 & 0xFFL);
        this.value[5] = (byte)(c >> 16 & 0xFFL);
        this.value[6] = (byte)(c >> 8 & 0xFFL);
        this.value[7] = (byte)(c & 0xFFL);
    }

    public UnsignedLong(Random random) {
        random.nextBytes(this.value);
    }

    private UnsignedLong() {
        Arrays.fill(this.value, (byte)0);
    }

    public static UnsignedLong fromBytes(byte[] c) {
        return UnsignedLong.fromBytes(c, 0);
    }

    public static UnsignedLong fromBytes(byte[] c, int offset) {
        UnsignedLong number = new UnsignedLong();
        if (c.length - offset < 8) {
            throw new IllegalArgumentException("An UnsignedLong number is composed of 8 bytes.");
        }
        for (int i = 7; i >= 0; --i) {
            number.value[i] = c[offset + i];
        }
        return number;
    }

    public static UnsignedLong fromString(String c) {
        return UnsignedLong.fromString(c, 10);
    }

    public static UnsignedLong fromString(String c, int radix) {
        UnsignedLong number = new UnsignedLong();
        BigInteger n = new BigInteger(c, radix);
        byte[] bytes = n.toByteArray();
        int len = Math.min(8, bytes.length);
        for (int i = 0; i < len; ++i) {
            number.value[7 - i] = bytes[bytes.length - 1 - i];
        }
        return number;
    }

    @Override
    public byte[] getBytes() {
        return this.value;
    }

    @Override
    public String toString() {
        if ((byte)(this.value[0] >> 7 & 1) == 1) {
            this.value[0] = (byte)(this.value[0] & 0x7F);
            BigInteger n = new BigInteger(this.value);
            n = n.setBit(63);
            this.value[0] = (byte)(this.value[0] | 0x80);
            return n.toString();
        }
        BigInteger n = new BigInteger(this.value);
        return n.toString();
    }

    @Override
    public int intValue() {
        return this.value[4] << 24 & 0xFF000000 | this.value[5] << 16 & 0xFF0000 | this.value[6] << 8 & 0xFF00 | this.value[7] & 0xFF;
    }

    @Override
    public long longValue() {
        return (long)this.value[0] << 56 & 0xFF00000000000000L | (long)this.value[1] << 48 & 0xFF000000000000L | (long)this.value[2] << 40 & 0xFF0000000000L | (long)this.value[3] << 32 & 0xFF00000000L | (long)this.value[4] << 24 & 0xFF000000L | (long)this.value[5] << 16 & 0xFF0000L | (long)this.value[6] << 8 & 0xFF00L | (long)this.value[7] & 0xFFL;
    }

    @Override
    public float floatValue() {
        return this.longValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    @Override
    public int compareTo(UnsignedNumber other) {
        int i;
        byte[] otherValue = other.getBytes();
        if (otherValue.length > 8) {
            throw new IllegalArgumentException("The number is more than 8 bytes.");
        }
        byte[] normalValue = new byte[8];
        Arrays.fill(normalValue, (byte)0);
        for (i = 1; i <= otherValue.length; ++i) {
            normalValue[8 - i] = otherValue[otherValue.length - i];
        }
        for (i = 0; i < 8; ++i) {
            if ((char)this.value[i] > (char)normalValue[i]) {
                return 1;
            }
            if ((char)this.value[i] >= (char)normalValue[i]) continue;
            return -1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof UnsignedLong) {
            byte[] bytes = ((UnsignedLong)other).getBytes();
            for (int i = 7; i >= 0; --i) {
                if (this.value[i] == bytes[i]) continue;
                return false;
            }
            return true;
        }
        if (other instanceof Number) {
            return this.longValue() == ((Number)other).longValue();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.value.length; ++i) {
            hashCode = (int)((long)(31 * hashCode) + ((long)this.value[i] & 0xFFFFFFFFL));
        }
        return hashCode;
    }

    @Override
    public void shiftRight(int nBits) {
        int i;
        if (nBits > 64 || nBits < 0) {
            throw new IllegalArgumentException("Cannot right shift " + nBits + " an UnsignedLong.");
        }
        if (nBits % 8 != 0) {
            throw new IllegalArgumentException("nBits must be a multiple of 8.");
        }
        int nBytes = nBits / 8;
        for (i = 7; i >= nBytes; --i) {
            this.value[i] = this.value[i - nBytes];
        }
        for (i = nBytes - 1; i >= 0; --i) {
            this.value[i] = 0;
        }
    }

    @Override
    public void shiftLeft(int nBits) {
        int i;
        if (nBits > 64 || nBits < 0) {
            throw new IllegalArgumentException("Cannot left shift " + nBits + " an UnsignedLong.");
        }
        if (nBits % 8 != 0) {
            throw new IllegalArgumentException("nBits must be a multiple of 8.");
        }
        int nBytes = nBits / 8;
        for (i = 0; i <= 7 - nBytes; ++i) {
            this.value[i] = this.value[i + nBytes];
        }
        for (i = 8 - nBytes; i < 8; ++i) {
            this.value[i] = 0;
        }
    }
}

