/*
 * Decompiled with CFR 0.152.
 */
package org.red5.cache.impl;

import org.apache.mina.core.buffer.IoBuffer;
import org.red5.cache.ICacheable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class CacheableImpl
implements ICacheable {
    protected static Logger log = LoggerFactory.getLogger(CacheableImpl.class);
    protected ApplicationContext applicationContext;
    private byte[] bytes;
    private String name;
    private boolean cached;

    public CacheableImpl(Object obj) {
        IoBuffer tmp = IoBuffer.allocate((int)1024, (boolean)true);
        tmp.setAutoExpand(true);
        tmp.putObject(obj);
        this.bytes = new byte[tmp.capacity()];
        tmp.get(this.bytes);
        this.cached = true;
        tmp.free();
        tmp = null;
    }

    public CacheableImpl(IoBuffer buffer) {
        if (log.isDebugEnabled()) {
            log.debug("Buffer is direct: {} capacity: {}", (Object)buffer.isDirect(), (Object)buffer.capacity());
            log.debug("Buffer limit: {} remaining: {} position: {}", new Object[]{buffer.limit(), buffer.remaining(), buffer.position()});
        }
        this.bytes = new byte[buffer.capacity()];
        buffer.rewind();
        int i = 0;
        while (i < buffer.limit()) {
            buffer.position(i);
            while (buffer.remaining() > 0) {
                this.bytes[i++] = buffer.get();
            }
        }
        this.cached = true;
        if (log.isDebugEnabled()) {
            log.debug("Buffer size: " + buffer.capacity());
        }
        buffer = null;
    }

    public void addRequest() {
        log.info("Adding request for: " + this.name);
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public IoBuffer getByteBuffer() {
        return IoBuffer.wrap((byte[])this.bytes).asReadOnlyBuffer();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isCached() {
        return this.cached;
    }

    @Override
    public void setCached(boolean cached) {
        this.cached = cached;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

