/*
 * Decompiled with CFR 0.152.
 */
package org.red5.codec;

import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.AbstractVideo;
import org.red5.codec.VideoCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenVideo
extends AbstractVideo {
    private Logger log = LoggerFactory.getLogger(ScreenVideo.class);
    static final String CODEC_NAME = "ScreenVideo";
    private byte[] blockData;
    private int[] blockSize;
    private int width;
    private int height;
    private int widthInfo;
    private int heightInfo;
    private int blockWidth;
    private int blockHeight;
    private int blockCount;
    private int blockDataSize;
    private int totalBlockDataSize;

    public ScreenVideo() {
        this.reset();
    }

    @Override
    public String getName() {
        return CODEC_NAME;
    }

    @Override
    public void reset() {
        this.blockData = null;
        this.blockSize = null;
        this.width = 0;
        this.height = 0;
        this.widthInfo = 0;
        this.heightInfo = 0;
        this.blockWidth = 0;
        this.blockHeight = 0;
        this.blockCount = 0;
        this.blockDataSize = 0;
        this.totalBlockDataSize = 0;
    }

    @Override
    public boolean canHandleData(IoBuffer data) {
        byte first = data.get();
        boolean result = (first & 0xF) == VideoCodec.SCREEN_VIDEO.getId();
        data.rewind();
        return result;
    }

    private static int maxCompressedSize(int size) {
        return size + (size >> 12) + (size >> 14) + 11;
    }

    private void updateSize(IoBuffer data) {
        this.widthInfo = data.getShort();
        this.heightInfo = data.getShort();
        this.width = this.widthInfo & 0xFFF;
        this.height = this.heightInfo & 0xFFF;
        this.blockWidth = this.widthInfo & 0xF000;
        this.blockWidth = (this.blockWidth >> 12) + 1;
        this.blockWidth <<= 4;
        this.blockHeight = this.heightInfo & 0xF000;
        this.blockHeight = (this.blockHeight >> 12) + 1;
        this.blockHeight <<= 4;
        int xblocks = this.width / this.blockWidth;
        if (this.width % this.blockWidth != 0) {
            ++xblocks;
        }
        int yblocks = this.height / this.blockHeight;
        if (this.height % this.blockHeight != 0) {
            ++yblocks;
        }
        this.blockCount = xblocks * yblocks;
        int blockSize = ScreenVideo.maxCompressedSize(this.blockWidth * this.blockHeight * 3);
        int totalBlockSize = blockSize * this.blockCount;
        if (this.totalBlockDataSize != totalBlockSize) {
            this.log.info("Allocating memory for {} compressed blocks.", (Object)this.blockCount);
            this.blockDataSize = blockSize;
            this.totalBlockDataSize = totalBlockSize;
            this.blockData = new byte[blockSize * this.blockCount];
            this.blockSize = new int[blockSize * this.blockCount];
            for (int idx = 0; idx < this.blockCount; ++idx) {
                this.blockSize[idx] = 0;
            }
        }
    }

    @Override
    public boolean addData(IoBuffer data) {
        if (!this.canHandleData(data)) {
            return false;
        }
        data.get();
        this.updateSize(data);
        int idx = 0;
        int pos = 0;
        byte[] tmpData = new byte[this.blockDataSize];
        for (int countBlocks = this.blockCount; data.remaining() > 0 && countBlocks > 0; --countBlocks) {
            short size = data.getShort();
            if (size == 0) {
                ++idx;
                pos += this.blockDataSize;
                continue;
            }
            this.blockSize[idx] = size;
            data.get(tmpData, 0, (int)size);
            System.arraycopy(tmpData, 0, this.blockData, pos, size);
            ++idx;
            pos += this.blockDataSize;
        }
        data.rewind();
        return true;
    }

    @Override
    public IoBuffer getKeyframe() {
        IoBuffer result = IoBuffer.allocate((int)1024);
        result.setAutoExpand(true);
        result.put((byte)(0x10 | VideoCodec.SCREEN_VIDEO.getId()));
        result.putShort((short)this.widthInfo);
        result.putShort((short)this.heightInfo);
        byte[] tmpData = new byte[this.blockDataSize];
        int pos = 0;
        for (int idx = 0; idx < this.blockCount; ++idx) {
            int size = this.blockSize[idx];
            if (size == 0) {
                return null;
            }
            result.putShort((short)size);
            System.arraycopy(this.blockData, pos, tmpData, 0, size);
            result.put(tmpData, 0, size);
            pos += this.blockDataSize;
        }
        result.rewind();
        return result;
    }
}

