/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.types.state;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.reaktor.internal.types.ArrayFW;
import org.reaktivity.reaktor.internal.types.Flyweight;
import org.reaktivity.reaktor.internal.types.OctetsFW;

public final class RouteEntryFW
extends Flyweight {
    public static final int FIELD_OFFSET_LENGTH = 0;
    private static final int FIELD_SIZE_LENGTH = 4;
    public static final int FIELD_OFFSET_ROUTE = 4;
    private final OctetsFW routeRO = new OctetsFW();

    public long length() {
        return (long)this.buffer().getInt(this.offset() + 0) & 0xFFFFFFFFL;
    }

    public OctetsFW route() {
        return this.routeRO;
    }

    @Override
    public RouteEntryFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.routeRO.wrap(buffer, offset + 4, offset + 4 + (int)this.length());
        RouteEntryFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public RouteEntryFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        int limit = offset + 4 + (int)this.length();
        if (limit > maxLimit || null == this.routeRO.tryWrap(buffer, offset + 4, limit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.routeRO.limit();
    }

    public String toString() {
        return String.format("ROUTE_ENTRY [length=%d, route=%s]", this.length(), this.route());
    }

    public static final class Builder
    extends Flyweight.Builder<RouteEntryFW> {
        public static final long DEFAULT_LENGTH = 0L;
        private static final int INDEX_ROUTE = 0;
        private static final int FIELD_COUNT = 1;
        private int dynamicOffsetLength;
        private final OctetsFW.Builder routeRW = new OctetsFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new RouteEntryFW());
        }

        private Builder length(long value) {
            if (value < 0L) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"length\"", value));
            }
            if (value > 0xFFFFFFFFL) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"length\"", value));
            }
            int newLimit = this.limit() + 4;
            RouteEntryFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), (int)(value & 0xFFFFFFFFL));
            this.dynamicOffsetLength = this.limit();
            this.limit(newLimit);
            return this;
        }

        private OctetsFW.Builder route() {
            this.length(0L);
            assert (this.lastFieldSet == -1);
            return this.routeRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder route(OctetsFW value) {
            OctetsFW.Builder routeRW = this.route();
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null for field \"route\" that does not default to null");
            }
            routeRW.set(value);
            int newLimit = ((OctetsFW)routeRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder route(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder routeRW = this.route();
            mutator.accept(routeRW);
            int newLimit = ((OctetsFW)routeRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder route(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder routeRW = this.route();
            routeRW.set(buffer, offset, length);
            int newLimit = ((OctetsFW)routeRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.dynamicOffsetLength = -1;
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<RouteEntryFW>, ? extends Flyweight.Builder<RouteEntryFW>, RouteEntryFW> array) {
            super.wrap(array);
            this.dynamicOffsetLength = -1;
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public RouteEntryFW build() {
            assert (this.lastFieldSet == 0);
            this.lastFieldSet = -1;
            return (RouteEntryFW)super.build();
        }
    }
}

