/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.budget;

import java.util.function.LongSupplier;
import org.agrona.collections.Hashing;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.concurrent.AtomicBuffer;
import org.reaktivity.nukleus.budget.BudgetCreditor;
import org.reaktivity.reaktor.ReaktorConfiguration;
import org.reaktivity.reaktor.internal.layouts.BudgetsLayout;
import org.reaktivity.reaktor.internal.router.BudgetId;
import org.reaktivity.reaktor.internal.util.function.LongObjectBiConsumer;

public class DefaultBudgetCreditor
implements BudgetCreditor,
AutoCloseable {
    private final long budgetMask;
    private final BudgetsLayout layout;
    private final AtomicBuffer storage;
    private final int entries;
    private final BudgetFlusher flusher;
    private final LongSupplier supplyBudgetId;
    private final LongObjectBiConsumer<Runnable> executor;
    private final long childCleanupLinger;
    private final Long2LongHashMap budgetIndexById;
    private final Long2LongHashMap parentBudgetIds;

    public DefaultBudgetCreditor(int ownerIndex, BudgetsLayout layout, BudgetFlusher flusher) {
        this(ownerIndex, layout, flusher, null, null, 0L);
    }

    public DefaultBudgetCreditor(int ownerIndex, BudgetsLayout layout, BudgetFlusher flusher, LongSupplier supplyBudgetId, LongObjectBiConsumer<Runnable> executor, long childCleanupLinger) {
        this.budgetMask = BudgetId.budgetMask(ownerIndex);
        this.layout = layout;
        this.storage = layout.buffer();
        this.entries = layout.entries();
        this.flusher = flusher;
        this.supplyBudgetId = supplyBudgetId;
        this.executor = executor;
        this.childCleanupLinger = childCleanupLinger;
        this.budgetIndexById = new Long2LongHashMap(-1L);
        this.parentBudgetIds = new Long2LongHashMap(0L);
    }

    @Override
    public void close() throws Exception {
        this.layout.close();
    }

    public long acquire(long budgetId) {
        assert ((budgetId & this.budgetMask) == this.budgetMask);
        long budgetIndex = -1L;
        int entriesMask = this.entries - 1;
        int index = Hashing.hash((long)budgetId, (int)entriesMask);
        for (int i = 0; i < this.entries; ++i) {
            int budgetIdOffset = BudgetsLayout.budgetIdOffset(index);
            if (this.storage.compareAndSetLong(budgetIdOffset, 0L, budgetId)) {
                this.storage.putLong(BudgetsLayout.budgetRemainingOffset(index), 0L);
                this.storage.putLong(BudgetsLayout.budgetWatchersOffset(index), 0L);
                budgetIndex = this.budgetMask | (long)index;
                break;
            }
            assert (this.storage.getLongVolatile(budgetIdOffset) != budgetId);
            ++index;
            index &= entriesMask;
        }
        if (budgetIndex != -1L) {
            this.budgetIndexById.put(budgetId, budgetIndex);
        }
        return budgetIndex;
    }

    public long credit(long traceId, long budgetIndex, long credit) {
        long watchers;
        assert ((budgetIndex & this.budgetMask) == this.budgetMask);
        int index = (int)(budgetIndex & (this.budgetMask ^ 0xFFFFFFFFFFFFFFFFL));
        long previous = this.storage.getAndAddLong(BudgetsLayout.budgetRemainingOffset(index), credit);
        if (ReaktorConfiguration.DEBUG_BUDGETS && credit != 0L) {
            long budgetId = this.storage.getLongVolatile(BudgetsLayout.budgetIdOffset(index));
            System.out.format("[%d] [0x%016x] [0x%016x] credit %d @ %d => %d\n", System.nanoTime(), traceId, budgetId, credit, previous, previous + credit);
        }
        if ((watchers = this.storage.getLongVolatile(BudgetsLayout.budgetWatchersOffset(index))) != 0L) {
            long budgetId = this.storage.getLong(BudgetsLayout.budgetIdOffset(index));
            this.flusher.flush(traceId, budgetId, watchers);
        }
        return previous;
    }

    public void release(long budgetIndex) {
        if (ReaktorConfiguration.DEBUG_BUDGETS) {
            System.out.format("[%d] release creditor  budgetIndex=%d \n", System.nanoTime(), budgetIndex);
        }
        assert ((budgetIndex & this.budgetMask) == this.budgetMask);
        int index = (int)(budgetIndex & (this.budgetMask ^ 0xFFFFFFFFFFFFFFFFL));
        long budgetId = this.storage.getAndSetLong(BudgetsLayout.budgetIdOffset(index), 0L);
        this.storage.putLong(BudgetsLayout.budgetRemainingOffset(index), 0L);
        this.storage.putLongOrdered(BudgetsLayout.budgetWatchersOffset(index), 0L);
        assert (budgetId != 0L);
        this.budgetIndexById.remove((Object)budgetId, (Object)budgetIndex);
    }

    public void creditById(long traceId, long budgetId, long credit) {
        long budgetIndex = this.budgetIndexById.get(budgetId);
        if (ReaktorConfiguration.DEBUG_BUDGETS) {
            System.out.format("[%d] creditById credit=%d budgetId=%d budgetIndex=%d %s \n", System.nanoTime(), credit, budgetId, budgetIndex, this.budgetIndexById.toString());
        }
        if (budgetIndex != -1L) {
            this.credit(traceId, budgetIndex, credit);
        }
    }

    public long supplyChild(long budgetId) {
        long childBudgetId = this.supplyBudgetId.getAsLong();
        this.parentBudgetIds.put(childBudgetId, budgetId);
        return childBudgetId;
    }

    public int acquired() {
        return this.budgetIndexById.size();
    }

    public long parentBudgetId(long budgetId) {
        return this.parentBudgetIds.get(budgetId);
    }

    public void cleanupChild(long budgetId) {
        if (ReaktorConfiguration.DEBUG_BUDGETS) {
            System.out.format("[%d] cleanupChild childBudgetId=%d budgetParentChildRelation=%s \n", System.nanoTime(), budgetId, this.parentBudgetIds.toString());
        }
        this.executor.apply(System.currentTimeMillis() + this.childCleanupLinger, () -> this.parentBudgetIds.remove(budgetId));
    }

    long available(long budgetIndex) {
        assert ((budgetIndex & this.budgetMask) == this.budgetMask);
        int index = (int)(budgetIndex & (this.budgetMask ^ 0xFFFFFFFFFFFFFFFFL));
        return this.storage.getLongVolatile(BudgetsLayout.budgetRemainingOffset(index));
    }

    long budgetId(long budgetIndex) {
        assert ((budgetIndex & this.budgetMask) == this.budgetMask);
        int index = (int)(budgetIndex & (this.budgetMask ^ 0xFFFFFFFFFFFFFFFFL));
        return this.storage.getLongVolatile(BudgetsLayout.budgetIdOffset(index));
    }

    void watchers(long budgetIndex, long watchers) {
        assert ((budgetIndex & this.budgetMask) == this.budgetMask);
        int index = (int)(budgetIndex & (this.budgetMask ^ 0xFFFFFFFFFFFFFFFFL));
        this.storage.putLongVolatile(BudgetsLayout.budgetWatchersOffset(index), watchers);
    }

    public static interface BudgetFlusher {
        public void flush(long var1, long var3, long var5);
    }
}

