/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.test.internal.k3po.ext.types;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.reaktor.test.internal.k3po.ext.types.Flyweight;

public final class OctetsFW
extends Flyweight {
    private final DirectBuffer valueRO = new UnsafeBuffer(0L, 0);

    public <T> T get(Flyweight.Visitor<T> visitor) {
        DirectBuffer buffer = this.buffer();
        int offset = this.offset();
        int limit = this.limit();
        return visitor.visit(buffer, offset, limit);
    }

    public DirectBuffer value() {
        return this.valueRO;
    }

    @Override
    public int limit() {
        return this.maxLimit();
    }

    @Override
    public OctetsFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        int sizeof = this.sizeof();
        this.valueRO.wrap(buffer, sizeof != 0 ? offset : 0, sizeof);
        return this;
    }

    @Override
    public OctetsFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        int sizeof = this.sizeof();
        this.valueRO.wrap(buffer, sizeof != 0 ? offset : 0, sizeof);
        return this;
    }

    public String toString() {
        return String.format("octets[%d]", this.sizeof());
    }

    public static final class Builder
    extends Flyweight.Builder<OctetsFW> {
        public Builder() {
            super(new OctetsFW());
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            return this;
        }

        @Deprecated
        public Builder reset() {
            this.limit(this.offset());
            return this;
        }

        public Builder set(OctetsFW value) {
            int newLimit = this.offset() + value.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.offset(), value.buffer(), value.offset(), value.sizeof());
            this.limit(newLimit);
            return this;
        }

        public Builder set(DirectBuffer value, int offset, int length) {
            int newLimit = this.offset() + length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.offset(), value, offset, length);
            this.limit(newLimit);
            return this;
        }

        public Builder set(byte[] value) {
            int newLimit = this.offset() + value.length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.offset(), value);
            this.limit(newLimit);
            return this;
        }

        public Builder set(Flyweight.Builder.Visitor visitor) {
            int length = visitor.visit(this.buffer(), this.offset(), this.maxLimit());
            Flyweight.checkLimit(this.offset() + length, this.maxLimit());
            this.limit(this.offset() + length);
            return this;
        }

        public Builder put(OctetsFW value) {
            int newLimit = this.limit() + value.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), value.buffer(), value.offset(), value.sizeof());
            this.limit(newLimit);
            return this;
        }

        public Builder put(DirectBuffer value, int offset, int length) {
            int newLimit = this.limit() + length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), value, offset, length);
            this.limit(newLimit);
            return this;
        }

        public Builder put(byte[] value) {
            int newLimit = this.limit() + value.length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), value);
            this.limit(newLimit);
            return this;
        }

        public Builder put(Flyweight.Builder.Visitor visitor) {
            int length = visitor.visit(this.buffer(), this.limit(), this.maxLimit());
            Flyweight.checkLimit(this.limit() + length, this.maxLimit());
            this.limit(this.limit() + length);
            return this;
        }
    }
}

