/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.test.internal.k3po.ext.el;

import java.nio.file.Path;
import java.util.concurrent.ThreadLocalRandom;
import org.kaazing.k3po.lang.el.Function;
import org.kaazing.k3po.lang.el.spi.FunctionMapperSpi;
import org.reaktivity.reaktor.test.internal.k3po.ext.NukleusExtConfiguration;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.LabelManager;
import org.reaktivity.reaktor.test.internal.k3po.ext.types.control.Role;

public final class Functions {
    private static final ThreadLocal<LabelManager> LABELS = ThreadLocal.withInitial(Functions::newLabelManager);

    @Function
    public static int id(String nukleus) {
        LabelManager labels = LABELS.get();
        return labels.supplyLabelId(nukleus);
    }

    @Function
    public static long newRouteRef() {
        return Functions.nextLongNonZero();
    }

    @Function
    public static long newCorrelationId() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        return random.nextLong();
    }

    @Function
    public static Long newClientRouteId(String senderAddress, String receiverAddress) {
        return Functions.newRouteId(Role.CLIENT, receiverAddress, senderAddress);
    }

    @Function
    public static Long newServerRouteId(String senderAddress, String receiverAddress) {
        return Functions.newRouteId(Role.SERVER, receiverAddress, senderAddress);
    }

    @Function
    public static Long newProxyRouteId(String senderAddress, String receiverAddress) {
        return Functions.newRouteId(Role.PROXY, receiverAddress, senderAddress);
    }

    @Function
    public static Long newClientReverseRouteId(String senderAddress, String receiverAddress) {
        return Functions.newRouteId(Role.CLIENT_REVERSE, receiverAddress, senderAddress);
    }

    @Function
    public static Long newServerReverseRouteId(String senderAddress, String receiverAddress) {
        return Functions.newRouteId(Role.SERVER_REVERSE, receiverAddress, senderAddress);
    }

    @Function
    public static Long newCacheServerRouteId(String senderAddress, String receiverAddress) {
        return Functions.newRouteId(Role.CACHE_SERVER, receiverAddress, senderAddress);
    }

    @Function
    public static Long newCacheClientRouteId(String senderAddress, String receiverAddress) {
        return Functions.newRouteId(Role.CACHE_CLIENT, receiverAddress, senderAddress);
    }

    private static long nextLongNonZero() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        return random.nextLong(Long.MIN_VALUE, 0L) | random.nextLong(Long.MAX_VALUE);
    }

    private static Long newRouteId(Role role, String localAddress, String remoteAddress) {
        LabelManager labels = LABELS.get();
        long localId = labels.supplyLabelId(localAddress);
        long remoteId = labels.supplyLabelId(remoteAddress);
        long condition = ThreadLocalRandom.current().nextInt(0x10000000);
        return localId << 48 | remoteId << 32 | (long)(role.ordinal() << 28) | condition;
    }

    private Functions() {
    }

    private static LabelManager newLabelManager() {
        NukleusExtConfiguration config = new NukleusExtConfiguration();
        Path directory = config.directory();
        return new LabelManager(directory);
    }

    public static final class Mapper
    extends FunctionMapperSpi.Reflective {
        public Mapper() {
            super(Functions.class);
        }

        public String getPrefixName() {
            return "nukleus";
        }
    }
}

