/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.test.internal.k3po.ext.behavior.handler;

import java.util.EnumSet;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.kaazing.k3po.driver.internal.behavior.ScriptProgressException;
import org.kaazing.k3po.driver.internal.behavior.handler.event.AbstractEventHandler;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusChannel;

public class ReadFlagsOptionHandler
extends AbstractEventHandler {
    private int flags;

    public ReadFlagsOptionHandler(int flags) {
        super(EnumSet.of(AbstractEventHandler.ChannelEventKind.MESSAGE));
        this.flags = flags;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelFuture handlerFuture = this.getHandlerFuture();
        NukleusChannel channel = (NukleusChannel)ctx.getChannel();
        try {
            if (!handlerFuture.isDone()) {
                int readFlags = channel.readFlags();
                if (this.flags == readFlags || this.flags == -1 && readFlags == 3) {
                    handlerFuture.setSuccess();
                } else {
                    String message = String.format("Expected flags: %d, but was: %d", this.flags, readFlags);
                    handlerFuture.setFailure((Throwable)new ScriptProgressException(this.getRegionInfo(), message));
                }
            }
        }
        catch (Exception ex) {
            handlerFuture.setFailure((Throwable)ex);
        }
        super.messageReceived(ctx, e);
    }
}

