/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.test.internal.k3po.ext.behavior;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jboss.netty.channel.ChannelException;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddressFactorySpi;
import org.kaazing.k3po.lang.types.TypeInfo;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusChannelAddress;
import org.reaktivity.reaktor.test.internal.k3po.ext.types.NukleusTypeSystem;

public class NukleusChannelAddressFactory
extends ChannelAddressFactorySpi {
    public String getSchemeName() {
        return "nukleus";
    }

    protected ChannelAddress newChannelAddress0(URI location, ChannelAddress transport, Map<String, Object> options) {
        String authority = location.getAuthority();
        String path = location.getPath();
        if (!"streams".equals(authority)) {
            throw new ChannelException(String.format("%s host is not \"streams\"", this.getSchemeName()));
        }
        if (path == null || path.isEmpty()) {
            throw new ChannelException(String.format("%s path missing", this.getSchemeName()));
        }
        List<TypeInfo> requiredTypes = Arrays.asList(NukleusTypeSystem.OPTION_WINDOW);
        for (TypeInfo typeInfo : requiredTypes) {
            if (options != null && options.containsKey(typeInfo.getName())) continue;
            throw new ChannelException(String.format("%s %s option missing", this.getSchemeName(), typeInfo.getName()));
        }
        List<TypeInfo> allOptionTypes = Arrays.asList(NukleusTypeSystem.OPTION_REPLY_TO, NukleusTypeSystem.OPTION_WINDOW, NukleusTypeSystem.OPTION_BUDGET_ID, NukleusTypeSystem.OPTION_PADDING, NukleusTypeSystem.OPTION_UPDATE, NukleusTypeSystem.OPTION_AUTHORIZATION, NukleusTypeSystem.OPTION_THROTTLE, NukleusTypeSystem.OPTION_TRANSMISSION, NukleusTypeSystem.OPTION_BYTE_ORDER);
        for (TypeInfo optionType : allOptionTypes) {
            if (options == null || !options.containsKey(optionType.getName())) continue;
            Object value = options.get(optionType.getName());
            if (optionType.getType().isInstance(value)) continue;
            throw new ChannelException(String.format("%s %s option incorrect type", this.getSchemeName(), optionType.getName()));
        }
        long l = (Long)options.getOrDefault(NukleusTypeSystem.OPTION_AUTHORIZATION.getName(), 0L);
        String replyTo = (String)options.getOrDefault(NukleusTypeSystem.OPTION_REPLY_TO.getName(), "k3po#0");
        return new NukleusChannelAddress(location, l, replyTo);
    }
}

