/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.test.internal.k3po.ext.behavior;

import java.net.URI;
import java.util.Objects;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;

public final class NukleusChannelAddress
extends ChannelAddress {
    private static final long serialVersionUID = 1L;
    private final long authorization;
    private final String senderAddress;
    private final String receiverAddress;

    public NukleusChannelAddress(URI location, long authorization, String senderAddress) {
        this(location, authorization, senderAddress, NukleusChannelAddress.receiverAddress(location));
    }

    private NukleusChannelAddress(URI location, long authorization, String senderAddress, String receiverAddress) {
        super(location);
        this.authorization = authorization;
        this.senderAddress = Objects.requireNonNull(senderAddress);
        this.receiverAddress = Objects.requireNonNull(receiverAddress);
    }

    private NukleusChannelAddress(URI location, ChannelAddress transport, boolean ephemeral, long authorization, String senderAddress, String receiverAddress) {
        super(location, transport, ephemeral);
        this.authorization = authorization;
        this.senderAddress = Objects.requireNonNull(senderAddress);
        this.receiverAddress = Objects.requireNonNull(receiverAddress);
    }

    public long getAuthorization() {
        return this.authorization;
    }

    public String getSenderAddress() {
        return this.senderAddress;
    }

    public String getReceiverAddress() {
        return this.receiverAddress;
    }

    public NukleusChannelAddress newEphemeralAddress() {
        return (NukleusChannelAddress)super.createEphemeralAddress(this::newEphemeralAddress);
    }

    public NukleusChannelAddress newReplyToAddress(String replyAddress) {
        URI location = this.getLocation();
        return new NukleusChannelAddress(location, this.authorization, this.receiverAddress, replyAddress);
    }

    private NukleusChannelAddress newEphemeralAddress(URI location, ChannelAddress transport) {
        return new NukleusChannelAddress(location, transport, true, this.authorization, this.senderAddress, this.receiverAddress);
    }

    private static String receiverAddress(URI location) {
        String fragment = location.getFragment();
        String path = location.getPath().substring(1);
        return fragment != null ? String.format("%s#%s", path, fragment) : path;
    }
}

