/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.test.internal.k3po.ext.behavior;

import java.util.Objects;
import org.kaazing.k3po.driver.internal.netty.bootstrap.channel.DefaultServerChannelConfig;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusByteOrder;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusChannel;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusServerChannelConfig;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusThrottleMode;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusTransmission;
import org.reaktivity.reaktor.test.internal.k3po.ext.behavior.NukleusUpdateMode;
import org.reaktivity.reaktor.test.internal.k3po.ext.types.NukleusTypeSystem;
import org.reaktivity.reaktor.test.internal.k3po.ext.util.Conversions;

public class DefaultNukleusServerChannelConfig
extends DefaultServerChannelConfig
implements NukleusServerChannelConfig {
    private NukleusTransmission transmission = NukleusTransmission.SIMPLEX;
    private int window;
    private int sharedWindow;
    private long budgetId;
    private int padding;
    private NukleusThrottleMode throttle = NukleusThrottleMode.STREAM;
    private NukleusUpdateMode update = NukleusUpdateMode.STREAM;
    private long affinity;
    private byte capabilities;

    public DefaultNukleusServerChannelConfig() {
        this.setBufferFactory(NukleusChannel.NATIVE_BUFFER_FACTORY);
    }

    @Override
    public void setTransmission(NukleusTransmission transmission) {
        this.transmission = transmission;
    }

    @Override
    public NukleusTransmission getTransmission() {
        return this.transmission;
    }

    @Override
    public void setWindow(int window) {
        this.window = window;
    }

    @Override
    public int getWindow() {
        return this.window;
    }

    @Override
    public void setSharedWindow(int sharedWindow) {
        this.sharedWindow = sharedWindow;
    }

    @Override
    public int getSharedWindow() {
        return this.sharedWindow;
    }

    @Override
    public void setBudgetId(long budgetId) {
        this.budgetId = budgetId;
    }

    @Override
    public long getBudgetId() {
        return this.budgetId;
    }

    @Override
    public void setPadding(int padding) {
        this.padding = padding;
    }

    @Override
    public int getPadding() {
        return this.padding;
    }

    @Override
    public void setUpdate(NukleusUpdateMode update) {
        this.update = update;
    }

    @Override
    public NukleusUpdateMode getUpdate() {
        return this.update;
    }

    @Override
    public void setThrottle(NukleusThrottleMode throttle) {
        this.throttle = throttle;
    }

    @Override
    public boolean hasThrottle() {
        return this.throttle != NukleusThrottleMode.NONE;
    }

    @Override
    public NukleusThrottleMode getThrottle() {
        return this.throttle;
    }

    @Override
    public void setAffinity(long affinity) {
        this.affinity = affinity;
    }

    @Override
    public long getAffinity() {
        return this.affinity;
    }

    @Override
    public void setCapabilities(byte capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public byte getCapabilities() {
        return this.capabilities;
    }

    protected boolean setOption0(String key, Object value) {
        if (super.setOption0(key, value)) {
            return true;
        }
        if (NukleusTypeSystem.OPTION_TRANSMISSION.getName().equals(key)) {
            this.setTransmission(NukleusTransmission.decode(Objects.toString(value, "simplex")));
        } else if (NukleusTypeSystem.OPTION_WINDOW.getName().equals(key)) {
            this.setWindow(Conversions.convertToInt(value));
        } else if (NukleusTypeSystem.OPTION_SHARED_WINDOW.getName().equals(key)) {
            this.setSharedWindow(Conversions.convertToInt(value));
        } else if (NukleusTypeSystem.OPTION_BUDGET_ID.getName().equals(key)) {
            this.setBudgetId(Conversions.convertToLong(value));
        } else if (NukleusTypeSystem.OPTION_PADDING.getName().equals(key)) {
            this.setPadding(Conversions.convertToInt(value));
        } else if (NukleusTypeSystem.OPTION_UPDATE.getName().equals(key)) {
            this.setUpdate(NukleusUpdateMode.decode(Objects.toString(value, null)));
        } else if (NukleusTypeSystem.OPTION_THROTTLE.getName().equals(key)) {
            this.setThrottle(NukleusThrottleMode.decode(Objects.toString(value, "stream")));
        } else if (NukleusTypeSystem.OPTION_BYTE_ORDER.getName().equals(key)) {
            this.setBufferFactory(NukleusByteOrder.decode(Objects.toString(value, "native")).toBufferFactory());
        } else if (NukleusTypeSystem.OPTION_CAPABILITIES.getName().equals(key)) {
            this.setCapabilities(Conversions.convertToByte(value));
        } else {
            return false;
        }
        return true;
    }
}

