/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public final class CopyOnWriteHashMap<K, V>
implements Map<K, V> {
    private final UnaryOperator<Map<K, V>> copier;
    private volatile Map<K, V> snapshot;

    public CopyOnWriteHashMap() {
        this(HashMap::new, HashMap::new);
    }

    private CopyOnWriteHashMap(Supplier<Map<K, V>> initializer, UnaryOperator<Map<K, V>> copier) {
        this.copier = copier;
        this.snapshot = initializer.get();
    }

    @Override
    public int size() {
        return this.snapshot.size();
    }

    @Override
    public boolean isEmpty() {
        return this.snapshot.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.snapshot.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.snapshot.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.snapshot.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        CopyOnWriteHashMap copyOnWriteHashMap = this;
        synchronized (copyOnWriteHashMap) {
            Map newSnapshot = (Map)this.copier.apply(this.snapshot);
            V oldValue = newSnapshot.put(key, value);
            this.snapshot = newSnapshot;
            return oldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        CopyOnWriteHashMap copyOnWriteHashMap = this;
        synchronized (copyOnWriteHashMap) {
            Map newSnapshot = (Map)this.copier.apply(this.snapshot);
            Object oldValue = newSnapshot.remove(key);
            this.snapshot = newSnapshot;
            return oldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        CopyOnWriteHashMap copyOnWriteHashMap = this;
        synchronized (copyOnWriteHashMap) {
            Map newSnapshot = (Map)this.copier.apply(this.snapshot);
            newSnapshot.putAll(m);
            this.snapshot = newSnapshot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        CopyOnWriteHashMap copyOnWriteHashMap = this;
        synchronized (copyOnWriteHashMap) {
            Map newSnapshot = (Map)this.copier.apply(this.snapshot);
            newSnapshot.clear();
            this.snapshot = newSnapshot;
        }
    }

    @Override
    public Set<K> keySet() {
        return this.snapshot.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.snapshot.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.snapshot.entrySet();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.snapshot.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.snapshot.forEach(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        CopyOnWriteHashMap copyOnWriteHashMap = this;
        synchronized (copyOnWriteHashMap) {
            Map newSnapshot = (Map)this.copier.apply(this.snapshot);
            newSnapshot.replaceAll(function);
            this.snapshot = newSnapshot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        CopyOnWriteHashMap copyOnWriteHashMap = this;
        synchronized (copyOnWriteHashMap) {
            Map newSnapshot = (Map)this.copier.apply(this.snapshot);
            V oldValue = newSnapshot.putIfAbsent(key, value);
            this.snapshot = newSnapshot;
            return oldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        CopyOnWriteHashMap copyOnWriteHashMap = this;
        synchronized (copyOnWriteHashMap) {
            Map newSnapshot = (Map)this.copier.apply(this.snapshot);
            boolean removed = newSnapshot.remove(key, value);
            this.snapshot = newSnapshot;
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        CopyOnWriteHashMap copyOnWriteHashMap = this;
        synchronized (copyOnWriteHashMap) {
            Map newSnapshot = (Map)this.copier.apply(this.snapshot);
            boolean replaced = newSnapshot.replace(key, oldValue, newValue);
            this.snapshot = newSnapshot;
            return replaced;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        CopyOnWriteHashMap copyOnWriteHashMap = this;
        synchronized (copyOnWriteHashMap) {
            Map newSnapshot = (Map)this.copier.apply(this.snapshot);
            V oldValue = newSnapshot.replace(key, value);
            this.snapshot = newSnapshot;
            return oldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        CopyOnWriteHashMap copyOnWriteHashMap = this;
        synchronized (copyOnWriteHashMap) {
            Map newSnapshot = (Map)this.copier.apply(this.snapshot);
            V oldValue = newSnapshot.computeIfAbsent(key, mappingFunction);
            this.snapshot = newSnapshot;
            return oldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        CopyOnWriteHashMap copyOnWriteHashMap = this;
        synchronized (copyOnWriteHashMap) {
            Map newSnapshot = (Map)this.copier.apply(this.snapshot);
            V oldValue = newSnapshot.computeIfPresent(key, remappingFunction);
            this.snapshot = newSnapshot;
            return oldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        CopyOnWriteHashMap copyOnWriteHashMap = this;
        synchronized (copyOnWriteHashMap) {
            Map newSnapshot = (Map)this.copier.apply(this.snapshot);
            V oldValue = newSnapshot.compute(key, remappingFunction);
            this.snapshot = newSnapshot;
            return oldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        CopyOnWriteHashMap copyOnWriteHashMap = this;
        synchronized (copyOnWriteHashMap) {
            Map newSnapshot = (Map)this.copier.apply(this.snapshot);
            V oldValue = newSnapshot.merge(key, value, remappingFunction);
            this.snapshot = newSnapshot;
            return oldValue;
        }
    }

    @Override
    public int hashCode() {
        return this.snapshot.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.snapshot.equals(obj);
    }

    public String toString() {
        return this.snapshot.toString();
    }
}

