/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.tcp.internal.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CIDR {
    private static final long LARGEST_IPV4 = 0xFFFFFFFFL;
    private static final String IP_ADDRESS = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
    private static final String SLASH_FORMAT = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})";
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
    private static final Pattern CIDR_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})");
    private final long low;
    private final long high;

    public CIDR(String cidrNotation) {
        Matcher matcher = CIDR_PATTERN.matcher(cidrNotation);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Could not parse [" + cidrNotation + "]");
        }
        long address = this.matchAddress(matcher);
        int cidrPart = Integer.parseInt(matcher.group(5));
        int netmask = cidrPart == 0 ? 0 : -1 << 32 - cidrPart;
        long network = address & (long)netmask;
        long broadcast = network | (long)(~netmask);
        this.low = network;
        this.high = broadcast == -1L ? 0xFFFFFFFFL : broadcast;
    }

    public boolean isInRange(String address) {
        long addr = this.toLong(address);
        return this.high >= addr && addr >= this.low;
    }

    private long toLong(String address) {
        Matcher matcher = ADDRESS_PATTERN.matcher(address);
        if (matcher.matches()) {
            return this.matchAddress(matcher);
        }
        throw new IllegalArgumentException("Could not parse [" + address + "]");
    }

    private long matchAddress(Matcher matcher) {
        long addr = 0L;
        for (int i = 1; i <= 4; ++i) {
            int n = Integer.parseInt(matcher.group(i));
            addr <<= 8;
            addr |= (long)(n & 0xFF);
        }
        return addr;
    }
}

