/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.tcp.internal.types;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.tcp.internal.types.Flyweight;
import org.reaktivity.nukleus.tcp.internal.types.OctetsFW;
import org.reaktivity.nukleus.tcp.internal.types.String8FW;
import org.reaktivity.nukleus.tcp.internal.types.StringFW;

public final class TcpAddressFW
extends Flyweight {
    private static final int FIELD_SIZE_KIND = 1;
    private static final int FIELD_OFFSET_KIND = 0;
    public static final int KIND_IPV4_ADDRESS = 1;
    public static final int FIELD_OFFSET_IPV4_ADDRESS = 1;
    private static final int FIELD_SIZE_IPV4_ADDRESS = 4;
    public static final int KIND_IPV6_ADDRESS = 2;
    public static final int FIELD_OFFSET_IPV6_ADDRESS = 1;
    private static final int FIELD_SIZE_IPV6_ADDRESS = 16;
    public static final int KIND_HOST = 3;
    public static final int FIELD_OFFSET_HOST = 1;
    private final OctetsFW ipv4AddressRO = new OctetsFW();
    private final OctetsFW ipv6AddressRO = new OctetsFW();
    private final String8FW hostRO = new String8FW();

    public int kind() {
        return this.buffer().getByte(this.offset() + 0) & 0xFF;
    }

    public OctetsFW ipv4Address() {
        return this.ipv4AddressRO;
    }

    public OctetsFW ipv6Address() {
        return this.ipv6AddressRO;
    }

    public String8FW host() {
        return this.hostRO;
    }

    @Override
    public TcpAddressFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        switch (this.kind()) {
            case 1: {
                if (this.ipv4AddressRO.tryWrap(buffer, offset + 1, offset + 1 + 4) != null) break;
                return null;
            }
            case 2: {
                if (this.ipv6AddressRO.tryWrap(buffer, offset + 1, offset + 1 + 16) != null) break;
                return null;
            }
            case 3: {
                if (this.hostRO.tryWrap(buffer, offset + 1, maxLimit) != null) break;
                return null;
            }
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public TcpAddressFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        switch (this.kind()) {
            case 1: {
                this.ipv4AddressRO.wrap(buffer, offset + 1, offset + 1 + 4);
                break;
            }
            case 2: {
                this.ipv6AddressRO.wrap(buffer, offset + 1, offset + 1 + 16);
                break;
            }
            case 3: {
                this.hostRO.wrap(buffer, offset + 1, maxLimit);
                break;
            }
        }
        TcpAddressFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        switch (this.kind()) {
            case 1: {
                return this.ipv4Address().limit();
            }
            case 2: {
                return this.ipv6Address().limit();
            }
            case 3: {
                return this.host().limit();
            }
        }
        return this.offset();
    }

    public String toString() {
        switch (this.kind()) {
            case 1: {
                return String.format("TCP_ADDRESS [ipv4Address=%s]", this.ipv4Address());
            }
            case 2: {
                return String.format("TCP_ADDRESS [ipv6Address=%s]", this.ipv6Address());
            }
            case 3: {
                return String.format("TCP_ADDRESS [host=%s]", this.host());
            }
        }
        return String.format("TCP_ADDRESS [unknown]", new Object[0]);
    }

    public static final class Builder
    extends Flyweight.Builder<TcpAddressFW> {
        private final OctetsFW.Builder ipv4AddressRW = new OctetsFW.Builder();
        private final OctetsFW.Builder ipv6AddressRW = new OctetsFW.Builder();
        private final String8FW.Builder hostRW = new String8FW.Builder();

        public Builder() {
            super(new TcpAddressFW());
        }

        public Builder kind(int value) {
            this.buffer().putByte(this.offset() + 0, (byte)(value & 0xFF));
            return this;
        }

        private OctetsFW.Builder ipv4Address() {
            int newLimit = this.offset() + 1 + 4;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            return this.ipv4AddressRW.wrap(this.buffer(), this.offset() + 1, newLimit);
        }

        public Builder ipv4Address(Consumer<OctetsFW.Builder> mutator) {
            this.kind(1);
            OctetsFW.Builder ipv4Address = this.ipv4Address();
            mutator.accept(ipv4Address);
            this.limit(((OctetsFW)ipv4Address.build()).limit());
            return this;
        }

        private OctetsFW.Builder ipv6Address() {
            int newLimit = this.offset() + 1 + 16;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            return this.ipv6AddressRW.wrap(this.buffer(), this.offset() + 1, newLimit);
        }

        public Builder ipv6Address(Consumer<OctetsFW.Builder> mutator) {
            this.kind(2);
            OctetsFW.Builder ipv6Address = this.ipv6Address();
            mutator.accept(ipv6Address);
            this.limit(((OctetsFW)ipv6Address.build()).limit());
            return this;
        }

        private String8FW.Builder host() {
            int newLimit = this.maxLimit();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            return this.hostRW.wrap(this.buffer(), this.offset() + 1, newLimit);
        }

        public Builder host(String value) {
            if (value == null) {
                this.limit(this.offset() + 1);
            } else {
                this.kind(3);
                String8FW.Builder host = this.host();
                host.set(value, StandardCharsets.UTF_8);
                this.limit(host.build().limit());
            }
            return this;
        }

        public Builder host(StringFW value) {
            if (value == null) {
                this.limit(this.offset() + 1);
            } else {
                this.kind(3);
                String8FW.Builder host = this.host();
                host.set(value);
                this.limit(host.build().limit());
            }
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            return this;
        }
    }
}

