/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.tcp.internal.types;

import java.nio.ByteOrder;
import java.util.function.Consumer;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.nukleus.tcp.internal.types.Flyweight;
import org.reaktivity.nukleus.tcp.internal.types.MapFW;

public final class Map16FW<K extends Flyweight, V extends Flyweight>
extends MapFW<K, V> {
    private static final int LENGTH_SIZE = 2;
    private static final int FIELD_COUNT_SIZE = 2;
    private static final int LENGTH_OFFSET = 0;
    private static final int FIELD_COUNT_OFFSET = 2;
    private static final int FIELDS_OFFSET = 4;
    private static final int LENGTH_MAX_VALUE = 65535;
    private final ByteOrder byteOrder;
    private final K keyRO;
    private final V valueRO;
    private final DirectBuffer entriesRO = new UnsafeBuffer(0L, 0);

    public Map16FW(K keyRO, V valueRO) {
        this.keyRO = keyRO;
        this.valueRO = valueRO;
        this.byteOrder = ByteOrder.nativeOrder();
    }

    public Map16FW(K keyRO, V valueRO, ByteOrder byteOrder) {
        this.keyRO = keyRO;
        this.valueRO = valueRO;
        this.byteOrder = byteOrder;
    }

    @Override
    public int length() {
        return this.buffer().getShort(this.offset() + 0, this.byteOrder);
    }

    @Override
    public int fieldCount() {
        return this.buffer().getShort(this.offset() + 2, this.byteOrder);
    }

    @Override
    public DirectBuffer entries() {
        return this.entriesRO;
    }

    @Override
    public void forEach(Function<K, Consumer<V>> consumer) {
        int offset = this.offset() + 4;
        int fieldCount = this.fieldCount();
        for (int i = 0; i < fieldCount; i += 2) {
            ((Flyweight)this.keyRO).wrap(this.buffer(), offset, this.limit());
            ((Flyweight)this.valueRO).wrap(this.buffer(), ((Flyweight)this.keyRO).limit(), this.limit());
            offset = ((Flyweight)this.valueRO).limit();
            consumer.apply(this.keyRO).accept(this.valueRO);
        }
    }

    @Override
    public Map16FW<K, V> tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        int itemsSize = this.length() - 2;
        this.entriesRO.wrap(buffer, offset + 4, itemsSize);
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public Map16FW<K, V> wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        int itemsSize = this.length() - 2;
        this.entriesRO.wrap(buffer, offset + 4, itemsSize);
        Map16FW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 2 + this.length();
    }

    public String toString() {
        return String.format("map16<%d, %d>", this.length(), this.fieldCount());
    }

    public static final class Builder<K extends Flyweight, V extends Flyweight, KB extends Flyweight.Builder<K>, VB extends Flyweight.Builder<V>>
    extends MapFW.Builder<Map16FW, K, V, KB, VB> {
        private final ByteOrder byteOrder;
        private final KB keyRW;
        private final VB valueRW;
        private int fieldCount;

        public Builder(K keyRO, V valueRO, KB keyRW, VB valueRW) {
            super(new Map16FW<K, V>(keyRO, valueRO));
            this.keyRW = keyRW;
            this.valueRW = valueRW;
            this.byteOrder = ByteOrder.nativeOrder();
        }

        public Builder(K keyRO, V valueRO, KB keyRW, VB valueRW, ByteOrder byteOrder) {
            super(new Map16FW<K, V>(keyRO, valueRO));
            this.keyRW = keyRW;
            this.valueRW = valueRW;
            this.byteOrder = byteOrder;
        }

        public Builder<K, V, KB, VB> wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            int newLimit = offset + 4;
            Flyweight.checkLimit(newLimit, maxLimit);
            this.limit(newLimit);
            return this;
        }

        public Builder<K, V, KB, VB> entry(Consumer<KB> key, Consumer<VB> value) {
            ((Flyweight.Builder)this.keyRW).wrap(this.buffer(), this.limit(), this.maxLimit());
            key.accept(this.keyRW);
            Flyweight.checkLimit(((Flyweight.Builder)this.keyRW).limit(), this.maxLimit());
            this.limit(((Flyweight.Builder)this.keyRW).limit());
            ++this.fieldCount;
            ((Flyweight.Builder)this.valueRW).wrap(this.buffer(), this.limit(), this.maxLimit());
            value.accept(this.valueRW);
            Flyweight.checkLimit(((Flyweight.Builder)this.valueRW).limit(), this.maxLimit());
            this.limit(((Flyweight.Builder)this.valueRW).limit());
            ++this.fieldCount;
            return this;
        }

        public Builder<K, V, KB, VB> entries(DirectBuffer buffer, int srcOffset, int length, int fieldCount) {
            this.buffer().putBytes(this.offset() + 4, buffer, srcOffset, length);
            int newLimit = this.offset() + 4 + length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.limit(newLimit);
            this.fieldCount = fieldCount;
            return this;
        }

        @Override
        public Map16FW build() {
            int length = this.limit() - this.offset() - 2;
            assert (length <= 65535) : "Length is too large";
            assert (this.fieldCount <= 65535) : "Field count is too large";
            this.buffer().putShort(this.offset() + 0, (short)length, this.byteOrder);
            this.buffer().putShort(this.offset() + 2, (short)this.fieldCount, this.byteOrder);
            return (Map16FW)super.build();
        }
    }
}

