/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.tcp.internal.stream;

final class TcpState {
    private static final int INITIAL_OPENING = 16;
    private static final int INITIAL_OPENED = 32;
    private static final int INITIAL_CLOSING = 64;
    private static final int INITIAL_CLOSED = 128;
    private static final int REPLY_OPENING = 1;
    private static final int REPLY_OPENED = 2;
    private static final int REPLY_CLOSING = 4;
    private static final int REPLY_CLOSED = 8;

    static int openingInitial(int state) {
        return state | 0x10;
    }

    static int openInitial(int state) {
        return TcpState.openingInitial(state) | 0x20;
    }

    static int closingInitial(int state) {
        return state | 0x40;
    }

    static int closeInitial(int state) {
        return TcpState.closingInitial(state) | 0x80;
    }

    static boolean initialOpening(int state) {
        return (state & 0x10) != 0;
    }

    static boolean initialOpened(int state) {
        return (state & 0x20) != 0;
    }

    static boolean initialClosing(int state) {
        return (state & 0x40) != 0;
    }

    static boolean initialClosed(int state) {
        return (state & 0x80) != 0;
    }

    static int openingReply(int state) {
        return state | 1;
    }

    static int openReply(int state) {
        return TcpState.openingReply(state) | 2;
    }

    static int closingReply(int state) {
        return state | 4;
    }

    static int closeReply(int state) {
        return TcpState.closingReply(state) | 8;
    }

    static boolean replyOpening(int state) {
        return (state & 1) != 0;
    }

    static boolean replyOpened(int state) {
        return (state & 2) != 0;
    }

    static boolean replyClosing(int state) {
        return (state & 4) != 0;
    }

    static boolean replyClosed(int state) {
        return (state & 8) != 0;
    }

    private TcpState() {
    }
}

