/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.tcp.internal.stream;

import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Long2ObjectHashMap;
import org.reaktivity.nukleus.buffer.BufferPool;
import org.reaktivity.nukleus.route.RouteManager;
import org.reaktivity.nukleus.stream.StreamFactory;
import org.reaktivity.nukleus.stream.StreamFactoryBuilder;
import org.reaktivity.nukleus.tcp.internal.TcpConfiguration;
import org.reaktivity.nukleus.tcp.internal.TcpCounters;
import org.reaktivity.nukleus.tcp.internal.TcpRouteCounters;
import org.reaktivity.nukleus.tcp.internal.poller.Poller;
import org.reaktivity.nukleus.tcp.internal.stream.Acceptor;
import org.reaktivity.nukleus.tcp.internal.stream.TcpServerFactory;

public class TcpServerFactoryBuilder
implements StreamFactoryBuilder {
    private final Acceptor acceptor;
    private final TcpConfiguration config;
    private final Poller poller;
    private final Long2ObjectHashMap<TcpRouteCounters> countersByRouteId;
    private RouteManager router;
    private LongUnaryOperator supplyInitialId;
    private LongUnaryOperator supplyReplyId;
    private LongSupplier supplyTraceId;
    private ToIntFunction<String> supplyTypeId;
    private Supplier<BufferPool> supplyBufferPool;
    private MutableDirectBuffer writeBuffer;
    private Function<String, LongSupplier> supplyCounter;
    private Function<String, LongConsumer> supplyAccumulator;

    public TcpServerFactoryBuilder(TcpConfiguration config, Long2ObjectHashMap<TcpRouteCounters> countersByRouteId, Acceptor acceptor, Poller poller) {
        this.config = config;
        this.countersByRouteId = countersByRouteId;
        this.acceptor = acceptor;
        this.poller = poller;
    }

    public StreamFactoryBuilder setBufferPoolSupplier(Supplier<BufferPool> supplyBufferPool) {
        this.supplyBufferPool = supplyBufferPool;
        return this;
    }

    public TcpServerFactoryBuilder setRouteManager(RouteManager router) {
        this.router = router;
        return this;
    }

    public TcpServerFactoryBuilder setInitialIdSupplier(LongUnaryOperator supplyInitialId) {
        this.supplyInitialId = supplyInitialId;
        return this;
    }

    public StreamFactoryBuilder setReplyIdSupplier(LongUnaryOperator supplyReplyId) {
        this.supplyReplyId = supplyReplyId;
        return this;
    }

    public TcpServerFactoryBuilder setTraceIdSupplier(LongSupplier supplyTraceId) {
        this.supplyTraceId = supplyTraceId;
        return this;
    }

    public StreamFactoryBuilder setTypeIdSupplier(ToIntFunction<String> supplyTypeId) {
        this.supplyTypeId = supplyTypeId;
        return this;
    }

    public TcpServerFactoryBuilder setWriteBuffer(MutableDirectBuffer writeBuffer) {
        this.writeBuffer = writeBuffer;
        return this;
    }

    public StreamFactoryBuilder setCounterSupplier(Function<String, LongSupplier> supplyCounter) {
        this.supplyCounter = supplyCounter;
        return this;
    }

    public StreamFactoryBuilder setAccumulatorSupplier(Function<String, LongConsumer> supplyAccumulator) {
        this.supplyAccumulator = supplyAccumulator;
        return this;
    }

    public StreamFactory build() {
        BufferPool bufferPool = this.supplyBufferPool.get();
        TcpCounters counters = new TcpCounters(this.supplyCounter, this.supplyAccumulator, this.countersByRouteId);
        TcpServerFactory factory = new TcpServerFactory(this.config, this.router, this.writeBuffer, bufferPool, this.supplyInitialId, this.supplyTraceId, this.supplyTypeId, this.supplyReplyId, this.poller, counters, this.acceptor::onChannelClosed);
        this.acceptor.setServerFactory(factory);
        this.acceptor.setRouter(this.router);
        return factory;
    }
}

