/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.tcp.internal.stream;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.collections.MutableInteger;
import org.reaktivity.nukleus.route.RouteManager;
import org.reaktivity.nukleus.tcp.internal.TcpConfiguration;
import org.reaktivity.nukleus.tcp.internal.poller.Poller;
import org.reaktivity.nukleus.tcp.internal.poller.PollerKey;
import org.reaktivity.nukleus.tcp.internal.stream.TcpServerFactory;
import org.reaktivity.nukleus.tcp.internal.types.control.Role;
import org.reaktivity.nukleus.tcp.internal.types.control.RouteFW;
import org.reaktivity.nukleus.tcp.internal.types.control.UnrouteFW;
import org.reaktivity.nukleus.tcp.internal.util.IpUtil;

public final class Acceptor {
    private final RouteFW routeRO = new RouteFW();
    private final UnrouteFW unrouteRO = new UnrouteFW();
    private final int backlog;
    private final boolean keepalive;
    private final boolean nodelay;
    private final Long2ObjectHashMap<InetSocketAddress> localAddressByRouteId;
    private final Function<SocketAddress, PollerKey> registerHandler;
    private final ToIntFunction<PollerKey> acceptHandler;
    private final MutableInteger remainingConnections;
    private Poller poller;
    private TcpServerFactory serverFactory;
    private RouteManager router;
    private boolean unbound;

    public Acceptor(TcpConfiguration config) {
        this.backlog = config.maximumBacklog();
        this.keepalive = config.keepalive();
        this.nodelay = config.nodelay();
        this.remainingConnections = new MutableInteger(config.maxConnections());
        this.localAddressByRouteId = new Long2ObjectHashMap();
        this.registerHandler = this::handleRegister;
        this.acceptHandler = this::handleAccept;
    }

    public void setPoller(Poller poller) {
        this.poller = poller;
    }

    public void handleRouted(int msgTypeId, DirectBuffer buffer, int index, int length) {
        switch (msgTypeId) {
            case 1: {
                RouteFW route = this.routeRO.wrap(buffer, index, index + length);
                assert (route.role().get() == Role.SERVER);
                long routeId = route.correlationId();
                String localAddress = route.localAddress().asString();
                this.doRegister(routeId, localAddress);
                break;
            }
            case 2: {
                UnrouteFW unroute = this.unrouteRO.wrap(buffer, index, index + length);
                long unrouteId = unroute.routeId();
                this.doUnregister(unrouteId);
            }
        }
    }

    void setServerFactory(TcpServerFactory serverFactory) {
        this.serverFactory = serverFactory;
    }

    void setRouter(RouteManager router) {
        this.router = router;
    }

    private boolean doRegister(long routeId, String localAddressAndPort) {
        try {
            Matcher matcher = IpUtil.ACCEPT_HOST_AND_PORT_PATTERN.matcher(localAddressAndPort);
            if (!matcher.matches()) {
                return false;
            }
            String hostname = matcher.group(1);
            int port = Integer.parseInt(matcher.group(2));
            InetAddress address = InetAddress.getByName(hostname);
            InetSocketAddress localAddress = new InetSocketAddress(address, port);
            this.findOrRegisterKey(localAddress);
            this.localAddressByRouteId.putIfAbsent((Object)routeId, (Object)localAddress);
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return true;
    }

    private boolean doUnregister(long routeId) {
        boolean result = false;
        try {
            InetSocketAddress localAddress = (InetSocketAddress)this.localAddressByRouteId.remove(routeId);
            if (localAddress != null) {
                PollerKey key = this.findRegisteredKey(localAddress);
                CloseHelper.quietClose((AutoCloseable)key.channel());
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private int handleAccept(PollerKey key) {
        try {
            ServerSocketChannel serverChannel = Acceptor.channel(key);
            SocketChannel channel = this.accept(serverChannel);
            while (channel != null) {
                channel.configureBlocking(false);
                channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)this.nodelay);
                channel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)this.keepalive);
                InetSocketAddress address = Acceptor.localAddress(channel);
                this.serverFactory.onAccepted(channel, address, arg_0 -> this.localAddressByRouteId.get(arg_0));
                channel = this.accept(serverChannel);
            }
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return 1;
    }

    private SocketChannel accept(ServerSocketChannel serverChannel) throws Exception {
        SocketChannel channel = null;
        if (!this.unbound && this.remainingConnections.value <= 0) {
            this.router.forEach((id, buffer, index, length) -> {
                RouteFW route = this.routeRO.wrap(buffer, index, index + length);
                if (route.role().get() == Role.SERVER) {
                    this.doUnregister(route.correlationId());
                }
            });
            this.unbound = true;
        } else {
            if (this.remainingConnections.value > 0) {
                channel = serverChannel.accept();
            }
            if (channel != null) {
                --this.remainingConnections.value;
                this.serverFactory.counters.connections.accept(1L);
            }
        }
        return channel;
    }

    void onChannelClosed() {
        ++this.remainingConnections.value;
        this.serverFactory.counters.connections.accept(-1L);
        if (this.unbound && this.remainingConnections.value > 0) {
            this.router.forEach((id, buffer, index, length) -> {
                RouteFW route = this.routeRO.wrap(buffer, index, index + length);
                if (route.role().get() == Role.SERVER) {
                    this.doRegister(route.correlationId(), route.localAddress().asString());
                }
            });
            this.unbound = false;
        }
    }

    private PollerKey findRegisteredKey(SocketAddress localAddress) {
        return this.findPollerKey(localAddress, a -> null);
    }

    private PollerKey findOrRegisterKey(SocketAddress address) {
        return this.findPollerKey(address, this.registerHandler);
    }

    private PollerKey findPollerKey(SocketAddress localAddress, Function<SocketAddress, PollerKey> mappingFunction) {
        Optional<PollerKey> optional = this.poller.keys().filter(PollerKey::isValid).filter(k -> ServerSocketChannel.class.isInstance(k.channel())).filter(k -> this.hasLocalAddress(Acceptor.channel(k), localAddress)).findFirst();
        return optional.orElse(mappingFunction.apply(localAddress));
    }

    private PollerKey handleRegister(SocketAddress localAddress) {
        try {
            ServerSocketChannel serverChannel = ServerSocketChannel.open();
            serverChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            serverChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEPORT, (Object)true);
            serverChannel.bind(localAddress, this.backlog);
            serverChannel.configureBlocking(false);
            return this.poller.doRegister(serverChannel, 16, this.acceptHandler);
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
            return null;
        }
    }

    private boolean hasLocalAddress(NetworkChannel channel, SocketAddress address) {
        try {
            return IpUtil.compareAddresses(channel.getLocalAddress(), address) == 0;
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
            return false;
        }
    }

    private static ServerSocketChannel channel(PollerKey key) {
        return (ServerSocketChannel)key.channel();
    }

    private static InetSocketAddress localAddress(SocketChannel channel) throws IOException {
        return (InetSocketAddress)channel.getLocalAddress();
    }
}

