/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.tcp.internal.poller;

import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.agrona.CloseHelper;
import org.agrona.LangUtil;
import org.agrona.concurrent.Agent;
import org.agrona.nio.TransportPoller;
import org.reaktivity.nukleus.tcp.internal.poller.PollerKey;

public final class Poller
extends TransportPoller
implements Agent {
    private final ToIntFunction<SelectionKey> selectHandler = this::handleSelect;

    public int doWork() {
        int workDone = 0;
        try {
            if (this.selector.selectNow() != 0) {
                workDone = this.selectedKeySet.forEach(this.selectHandler);
            }
        }
        catch (Throwable ex) {
            this.selectedKeySet.reset();
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return workDone;
    }

    public String roleName() {
        return "poller";
    }

    public void onClose() {
        for (SelectionKey key : this.selector.keys()) {
            CloseHelper.quietClose((AutoCloseable)key.channel());
        }
        this.selectNowWithoutProcessing();
        super.close();
    }

    public PollerKey doRegister(SelectableChannel channel, int interestOps, ToIntFunction<PollerKey> handler) {
        PollerKey pollerKey = null;
        try {
            SelectionKey key = channel.keyFor(this.selector);
            if (key == null) {
                key = channel.register(this.selector, interestOps, null);
                key.attach(new PollerKey(key));
            }
            pollerKey = Poller.attachment(key);
            if (handler != null) {
                pollerKey.handler(interestOps, handler);
            }
        }
        catch (ClosedChannelException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return pollerKey;
    }

    public Stream<PollerKey> keys() {
        return this.selector.keys().stream().map(k -> Poller.attachment(k));
    }

    private int handleSelect(SelectionKey key) {
        PollerKey attachment = Poller.attachment(key);
        return attachment.handleSelect(key);
    }

    private static PollerKey attachment(SelectionKey key) {
        return (PollerKey)key.attachment();
    }
}

