/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.tcp.internal;

import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import org.agrona.collections.Long2ObjectHashMap;
import org.reaktivity.nukleus.tcp.internal.TcpRouteCounters;

public final class TcpCounters {
    private final Function<String, LongSupplier> supplyCounter;
    private final Function<String, LongConsumer> supplyAccumulator;
    private final Long2ObjectHashMap<TcpRouteCounters> countersByRouteId;
    public final LongConsumer connections;

    public TcpCounters(Function<String, LongSupplier> supplyCounter, Function<String, LongConsumer> supplyAccumulator, Long2ObjectHashMap<TcpRouteCounters> countersByRouteId) {
        this.supplyCounter = supplyCounter;
        this.supplyAccumulator = supplyAccumulator;
        this.countersByRouteId = countersByRouteId;
        this.connections = supplyAccumulator.apply("tcp.connections");
    }

    public TcpRouteCounters supplyRoute(long routeId) {
        return (TcpRouteCounters)this.countersByRouteId.computeIfAbsent(routeId, this::newRouteCounters);
    }

    public TcpRouteCounters removeRoute(long routeId) {
        return (TcpRouteCounters)this.countersByRouteId.remove(routeId);
    }

    private TcpRouteCounters newRouteCounters(long routeId) {
        return new TcpRouteCounters(routeId, this.supplyCounter, this.supplyAccumulator);
    }
}

