/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.tcp.internal;

import org.reaktivity.nukleus.Configuration;

public class TcpConfiguration
extends Configuration {
    public static final Configuration.IntPropertyDef TCP_MAXIMUM_BACKLOG;
    public static final Configuration.IntPropertyDef TCP_WINDOW_THRESHOLD;
    public static final Configuration.IntPropertyDef TCP_MAX_CONNECTIONS;
    public static final Configuration.BooleanPropertyDef TCP_KEEPALIVE;
    public static final Configuration.BooleanPropertyDef TCP_NODELAY;
    private static final Configuration.ConfigurationDef TCP_CONFIG;

    public TcpConfiguration(Configuration config) {
        super(TCP_CONFIG, config);
    }

    public int maximumBacklog() {
        return TCP_MAXIMUM_BACKLOG.getAsInt((Configuration)this);
    }

    public int windowThreshold() {
        int threshold = TCP_WINDOW_THRESHOLD.getAsInt((Configuration)this);
        if (threshold < 0 || threshold > 100) {
            String message = String.format("TCP write window threshold is %d (should be between 0 and 100 inclusive)", threshold);
            throw new IllegalArgumentException(message);
        }
        return threshold;
    }

    public int maxConnections() {
        return TCP_MAX_CONNECTIONS.getAsInt((Configuration)this);
    }

    public boolean keepalive() {
        return TCP_KEEPALIVE.getAsBoolean((Configuration)this);
    }

    public boolean nodelay() {
        return TCP_NODELAY.getAsBoolean((Configuration)this);
    }

    static {
        Configuration.ConfigurationDef config = new Configuration.ConfigurationDef("nukleus.tcp");
        TCP_MAXIMUM_BACKLOG = config.property("maximum.backlog", 0);
        TCP_WINDOW_THRESHOLD = config.property("window.threshold", 0);
        TCP_MAX_CONNECTIONS = config.property("max.connections", Integer.MAX_VALUE);
        TCP_KEEPALIVE = config.property("keepalive", false);
        TCP_NODELAY = config.property("nodelay", true);
        TCP_CONFIG = config;
    }
}

