/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.maven.plugins.nukleus.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.lang.model.element.Modifier;
import org.reaktivity.maven.plugins.nukleus.internal.generate.ClassSpecGenerator;
import org.reaktivity.maven.plugins.nukleus.internal.generate.TypeNames;

public final class VarStringFlyweightGenerator
extends ClassSpecGenerator {
    private final ClassName varintType;
    private final TypeSpec.Builder classBuilder;
    private final BuilderClassBuilder builderClassBuilder;

    public VarStringFlyweightGenerator(ClassName stringType) {
        super(stringType.peerClass("VarStringFW"));
        this.varintType = stringType.peerClass("Varint32FW");
        this.classBuilder = TypeSpec.classBuilder((ClassName)((ClassName)this.thisName)).superclass((TypeName)stringType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        this.builderClassBuilder = new BuilderClassBuilder(stringType, (ClassName)this.thisName, stringType.nestedClass("Builder"), this.varintType, this.varintType.nestedClass("Builder"));
    }

    @Override
    public TypeSpec generate() {
        return this.classBuilder.addField(this.fieldMaxSizeLengthConstant()).addField(this.lengthField()).addField(this.valueField()).addMethod(this.constructor()).addMethod(this.constructorString()).addMethod(this.constructorStringAndCharset()).addMethod(this.fieldSizeLengthMethod()).addMethod(this.limitMethod()).addMethod(this.valueMethod()).addMethod(this.asStringMethod()).addMethod(this.tryWrapMethod()).addMethod(this.wrapMethod()).addMethod(this.toStringMethod()).addMethod(this.lengthMethod()).addType(this.builderClassBuilder.build()).build();
    }

    private FieldSpec fieldMaxSizeLengthConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"FIELD_MAX_SIZE_LENGTH", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.SIZE_OF_INT + 1", new Object[]{TypeNames.BIT_UTIL_TYPE}).build();
    }

    private FieldSpec lengthField() {
        return FieldSpec.builder((TypeName)this.varintType, (String)"lengthRO", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{this.varintType}).build();
    }

    private FieldSpec valueField() {
        return FieldSpec.builder((TypeName)TypeNames.DIRECT_BUFFER_TYPE, (String)"valueRO", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T(0L, 0)", new Object[]{TypeNames.UNSAFE_BUFFER_TYPE}).build();
    }

    private MethodSpec constructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
    }

    private MethodSpec constructorString() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, "value", new Modifier[0]).addStatement("this(value, $T.UTF_8)", new Object[]{StandardCharsets.class}).build();
    }

    private MethodSpec constructorStringAndCharset() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, "value", new Modifier[0]).addParameter(Charset.class, "charset", new Modifier[0]).addStatement("final byte[] encoded = value != null ? value.getBytes(charset) : null", new Object[0]).addStatement("final int encodedSize = encoded != null ? encoded.length : 1", new Object[0]).addStatement("final $T buffer = new $T(new byte[FIELD_MAX_SIZE_LENGTH + encodedSize])", new Object[]{TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, TypeNames.UNSAFE_BUFFER_TYPE}).addStatement("new Builder().wrap(buffer, 0, buffer.capacity()).set(value, charset).build();", new Object[0]).build();
    }

    private MethodSpec fieldSizeLengthMethod() {
        return MethodSpec.methodBuilder((String)"fieldSizeLength").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return lengthRO.sizeof()", new Object[0]).build();
    }

    private MethodSpec limitMethod() {
        return MethodSpec.methodBuilder((String)"limit").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return lengthRO.limit() + Math.max(length(), 0)", new Object[0]).build();
    }

    private MethodSpec asStringMethod() {
        return MethodSpec.methodBuilder((String)"asString").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).beginControlFlow("if (maxLimit() == offset() || length() == -1)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("return buffer().getStringWithoutLengthUtf8(lengthRO.limit(), length())", new Object[0]).build();
    }

    private MethodSpec tryWrapMethod() {
        return MethodSpec.methodBuilder((String)"tryWrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName).beginControlFlow("if (null == super.tryWrap(buffer, offset, maxLimit) || null == lengthRO.tryWrap(buffer, offset, maxLimit) || limit() > maxLimit)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("int length = length()", new Object[0]).beginControlFlow("if (length != -1)", new Object[0]).addStatement("valueRO.wrap(buffer, lengthRO.limit(), length)", new Object[0]).endControlFlow().addStatement("return this", new Object[0]).build();
    }

    private MethodSpec wrapMethod() {
        return MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("lengthRO.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("checkLimit(limit(), maxLimit)", new Object[0]).addStatement("int length = length()", new Object[0]).beginControlFlow("if (length != -1)", new Object[0]).addStatement("valueRO.wrap(buffer, lengthRO.limit(), length)", new Object[0]).endControlFlow().addStatement("return this", new Object[0]).build();
    }

    private MethodSpec valueMethod() {
        return MethodSpec.methodBuilder((String)"value").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeNames.DIRECT_BUFFER_TYPE).addStatement("return length() == -1 ? null : valueRO", new Object[0]).build();
    }

    private MethodSpec toStringMethod() {
        return MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return maxLimit() == offset() ? \"null\" : String.format(\"\\\"%s\\\"\", asString())", new Object[0]).build();
    }

    private MethodSpec lengthMethod() {
        return MethodSpec.methodBuilder((String)"length").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("int length = lengthRO.value()", new Object[0]).addStatement("return length < 0 ? -1 : length", new Object[0]).build();
    }

    private static final class BuilderClassBuilder {
        private final TypeSpec.Builder classBuilder;
        private final ClassName classType;
        private final ClassName stringType;
        private final ClassName varStringType;
        private final ClassName varintType;
        private final ClassName varintBuilderType;

        private BuilderClassBuilder(ClassName stringType, ClassName varStringType, ClassName builderRawType, ClassName varintType, ClassName varintBuilderType) {
            ParameterizedTypeName builderType = ParameterizedTypeName.get((ClassName)builderRawType, (TypeName[])new TypeName[]{varStringType});
            this.stringType = stringType;
            this.varStringType = varStringType;
            this.classType = varStringType.nestedClass("Builder");
            this.classBuilder = TypeSpec.classBuilder((String)this.classType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)builderType);
            this.varintType = varintType;
            this.varintBuilderType = varintBuilderType;
        }

        public TypeSpec build() {
            return this.classBuilder.addField(this.lengthField()).addField(this.valueSetField()).addMethod(this.constructor()).addMethod(this.wrapMethod()).addMethod(this.setMethod()).addMethod(this.setDirectBufferMethod()).addMethod(this.setStringMethod()).addMethod(this.checkLengthMethod()).addMethod(this.buildMethod()).build();
        }

        private FieldSpec lengthField() {
            return FieldSpec.builder((TypeName)this.varintBuilderType, (String)"lengthRW", (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer("new $T()", new Object[]{this.varintBuilderType}).build();
        }

        private FieldSpec valueSetField() {
            return FieldSpec.builder(Boolean.TYPE, (String)"valueSet", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        }

        private MethodSpec constructor() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super(new $T())", new Object[]{this.varStringType}).build();
        }

        private MethodSpec wrapMethod() {
            return MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.classType).addParameter((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).addStatement("checkLimit(offset + 1, maxLimit)", new Object[0]).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("lengthRW.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("this.valueSet = false", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec setMethod() {
            return MethodSpec.methodBuilder((String)"set").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.classType).addParameter((TypeName)this.stringType, "value", new Modifier[0]).addStatement("int len = value.length()", new Object[0]).beginControlFlow("if (len == -1)", new Object[0]).addStatement("limit(lengthRW.set(-1).build().limit())", new Object[0]).nextControlFlow("else", new Object[0]).addStatement("$T length = lengthRW.set(len).build()", new Object[]{this.varintType}).addStatement("int newLimit = length.limit() + length.value()", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putBytes(length.limit(), value.buffer(), value.offset() + value.fieldSizeLength(), len)", new Object[0]).addStatement("limit(newLimit)", new Object[0]).endControlFlow().addStatement("valueSet = true", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec setDirectBufferMethod() {
            return MethodSpec.methodBuilder((String)"set").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.classType).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "srcBuffer", new Modifier[0]).addParameter(Integer.TYPE, "srcOffset", new Modifier[0]).addParameter(Integer.TYPE, "srcLength", new Modifier[0]).addStatement("checkLength(srcLength)", new Object[0]).addStatement("$T length = lengthRW.set(srcLength).build()", new Object[]{this.varintType}).addStatement("int newLimit = length.limit() + length.value()", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putBytes(length.limit(), srcBuffer, srcOffset, srcLength)", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("valueSet = true", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec setStringMethod() {
            return MethodSpec.methodBuilder((String)"set").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.classType).addParameter(String.class, "value", new Modifier[0]).addParameter(Charset.class, "charset", new Modifier[0]).beginControlFlow("if (value == null)", new Object[0]).addStatement("limit(lengthRW.set(-1).build().limit())", new Object[0]).nextControlFlow("else", new Object[0]).addStatement("byte[] charBytes = value.getBytes(charset)", new Object[0]).addStatement("checkLength(charBytes.length)", new Object[0]).addStatement("$T length = lengthRW.set(charBytes.length).build()", new Object[]{this.varintType}).addStatement("int newLimit = length.limit() + length.value()", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putBytes(length.limit(), charBytes)", new Object[0]).addStatement("limit(newLimit)", new Object[0]).endControlFlow().addStatement("valueSet = true", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec checkLengthMethod() {
            return MethodSpec.methodBuilder((String)"checkLength").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter(Integer.TYPE, "length", new Modifier[0]).addStatement("final int maxLength = $T.MAX_VALUE - 1", new Object[]{Integer.class}).beginControlFlow("if (length > maxLength)", new Object[0]).addStatement("final String msg = String.format(\"length=%d is beyond maximum length=%d\", length, maxLength)", new Object[0]).addStatement("throw new IllegalArgumentException(msg)", new Object[0]).endControlFlow().build();
        }

        private MethodSpec buildMethod() {
            return MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.varStringType).beginControlFlow("if (!valueSet)", new Object[0]).addStatement("set(null, $T.UTF_8)", new Object[]{StandardCharsets.class}).endControlFlow().addStatement("return super.build()", new Object[0]).build();
        }
    }
}

