/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.maven.plugins.nukleus.internal.ast;

import java.util.Objects;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstStructMemberNode;

public final class AstUnionCaseNode
extends AstNode {
    private final Object value;
    private final AstStructMemberNode member;

    @Override
    public <R> R accept(AstNode.Visitor<R> visitor) {
        return visitor.visitCase(this);
    }

    public Object value() {
        return this.value;
    }

    public AstStructMemberNode member() {
        return this.member;
    }

    @Override
    public int hashCode() {
        return this.member.hashCode() << 11 ^ this.value.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AstUnionCaseNode)) {
            return false;
        }
        AstUnionCaseNode that = (AstUnionCaseNode)o;
        return this.value == that.value && Objects.equals(this.member, that.member);
    }

    private AstUnionCaseNode(Object value, AstStructMemberNode member) {
        this.value = value;
        this.member = member;
    }

    public String toString() {
        return String.format("CASE [value=%d, member=%s]", this.value, this.member);
    }

    public static final class Builder
    extends AstNode.Builder<AstUnionCaseNode> {
        private Object value;
        private AstStructMemberNode member;

        public Builder value(Object value) {
            this.value = value;
            return this;
        }

        public Builder member(AstStructMemberNode member) {
            this.member = member;
            return this;
        }

        @Override
        public AstUnionCaseNode build() {
            return new AstUnionCaseNode(this.value, this.member);
        }
    }
}

