/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.maven.plugins.nukleus.internal.ast;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstAbstractMemberNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstEnumNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstListNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstMapNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstScopeNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstSpecificationNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstStructNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstTypedefNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstUnionCaseNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstUnionNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstValueNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstVariantCaseNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstVariantNode;

public abstract class AstNode {
    public abstract <R> R accept(Visitor<R> var1);

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public static abstract class Builder<T extends AstNode> {
        public abstract T build();
    }

    public static abstract class Visitor<R> {
        public R visitSpecification(AstSpecificationNode specificationNode) {
            return this.visitScope(specificationNode.scope());
        }

        public R visitScope(AstScopeNode scopeNode) {
            return Stream.concat(Stream.concat(Stream.concat(Stream.concat(Stream.concat(Stream.concat(Stream.concat(scopeNode.scopes().stream().map(this::visitNestedScope), scopeNode.structs().stream().map(this::visitStruct)), scopeNode.enums().stream().map(this::visitEnum)), scopeNode.unions().stream().map(this::visitUnion)), scopeNode.variants().stream().map(this::visitVariant)), scopeNode.lists().stream().map(this::visitList)), scopeNode.typedefs().stream().map(this::visitTypedef)), scopeNode.maps().stream().map(this::visitMap)).collect(Collectors.reducing(this.defaultResult(), this::aggregateResult));
        }

        public R visitNestedScope(AstScopeNode scopeNode) {
            return this.visitScope(scopeNode);
        }

        public R visitEnum(AstEnumNode enumNode) {
            return enumNode.values().stream().map(this::visitValue).collect(Collectors.reducing(this.defaultResult(), this::aggregateResult));
        }

        public R visitValue(AstValueNode valueNode) {
            return this.defaultResult();
        }

        public R visitStruct(AstStructNode structNode) {
            return structNode.members().stream().map(this::visitMember).collect(Collectors.reducing(this.defaultResult(), this::aggregateResult));
        }

        public R visitList(AstListNode listNode) {
            return listNode.members().stream().map(this::visitMember).collect(Collectors.reducing(this.defaultResult(), this::aggregateResult));
        }

        public R visitTypedef(AstTypedefNode typedefNode) {
            return this.defaultResult();
        }

        public R visitMember(AstAbstractMemberNode memberNode) {
            return this.defaultResult();
        }

        public R visitUnion(AstUnionNode unionNode) {
            return unionNode.cases().stream().map(this::visitCase).collect(Collectors.reducing(this.defaultResult(), this::aggregateResult));
        }

        public R visitMap(AstMapNode mapNode) {
            return this.defaultResult();
        }

        public R visitVariant(AstVariantNode variantNode) {
            return variantNode.cases().stream().map(this::visitVariantCase).collect(Collectors.reducing(this.defaultResult(), this::aggregateResult));
        }

        public R visitVariantCase(AstVariantCaseNode variantCaseNode) {
            return this.defaultResult();
        }

        public R visitCase(AstUnionCaseNode caseNode) {
            return this.defaultResult();
        }

        protected R defaultResult() {
            return null;
        }

        protected R aggregateResult(R aggregate, R nextResult) {
            return nextResult;
        }
    }
}

