/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.maven.plugins.nukleus.internal.ast;

import java.util.Objects;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstNamedNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstType;

public final class AstMapNode
extends AstNamedNode {
    private final AstType templateMapType;
    private final AstType keyType;
    private final AstType valueType;

    @Override
    public <R> R accept(AstNode.Visitor<R> visitor) {
        return visitor.visitMap(this);
    }

    @Override
    public AstNamedNode withName(String name) {
        return new AstMapNode(name, this.templateMapType, this.keyType, this.valueType);
    }

    @Override
    public AstNamedNode.Kind getKind() {
        return AstNamedNode.Kind.MAP;
    }

    public AstType templateMapType() {
        return this.templateMapType;
    }

    public AstType keyType() {
        return this.keyType;
    }

    public AstType valueType() {
        return this.valueType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.templateMapType, this.keyType, this.valueType);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AstMapNode)) {
            return false;
        }
        AstMapNode that = (AstMapNode)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.templateMapType, that.templateMapType) && Objects.equals(this.keyType, that.keyType) && Objects.equals(this.valueType, that.valueType);
    }

    private AstMapNode(String name, AstType templateMapType, AstType keyType, AstType valueType) {
        super(name);
        this.templateMapType = templateMapType;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public static final class Builder
    extends AstNamedNode.Builder<AstMapNode> {
        private AstType templateMapType;
        private AstType keyType;
        private AstType valueType;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder templateMapType(AstType templateMapType) {
            this.templateMapType = templateMapType;
            return this;
        }

        public Builder keyType(AstType keyType) {
            this.keyType = keyType;
            return this;
        }

        public Builder valueType(AstType valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public AstMapNode build() {
            return new AstMapNode(this.name, this.templateMapType, this.keyType, this.valueType);
        }
    }
}

