/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.maven.plugins.nukleus.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstSpecificationNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstStructNode;
import org.reaktivity.maven.plugins.nukleus.internal.ast.AstType;
import org.reaktivity.maven.plugins.nukleus.internal.ast.parse.AstParser;
import org.reaktivity.maven.plugins.nukleus.internal.parser.NukleusLexer;
import org.reaktivity.maven.plugins.nukleus.internal.parser.NukleusParser;

class Parser {
    private static final Consumer<String> NO_OP = s -> {};
    private Consumer<String> error = System.err::println;
    private Consumer<String> warn = NO_OP;
    private Consumer<String> debug = NO_OP;

    Parser() {
    }

    Parser debug(Consumer<String> debug) {
        this.debug = debug;
        return this;
    }

    Parser error(Consumer<String> error) {
        this.error = error;
        return this;
    }

    Parser warn(Consumer<String> warn) {
        this.warn = warn;
        return this;
    }

    final List<AstSpecificationNode> parseAST(List<String> targetScopes, ClassLoader loader) throws IOException {
        LinkedList<AstSpecificationNode> specifications = new LinkedList<AstSpecificationNode>();
        TreeSet<String> parsedResourceNames = new TreeSet<String>();
        LinkedHashSet<String> remainingScopes = new LinkedHashSet<String>(targetScopes);
        while (!remainingScopes.isEmpty()) {
            String remainingScope = (String)remainingScopes.iterator().next();
            remainingScopes.remove(remainingScope);
            String resourceName = remainingScope.replaceAll("([^:]+).*", "$1.idl");
            if (!parsedResourceNames.add(resourceName)) continue;
            this.debug.accept("loading: " + resourceName);
            URL resource = loader.getResource(resourceName);
            if (resource == null) {
                this.warn.accept(String.format("Resource %s not found", resourceName));
                continue;
            }
            AstSpecificationNode specification = this.parseSpecification(resourceName, resource);
            specifications.add(specification);
            Set<String> referencedTypes = specification.accept(new ReferencedTypeResolver());
            this.debug.accept("referenced types: " + referencedTypes);
            String regex = "((:?[^:]+(?:\\:\\:[^:]+)*)?)\\:\\:[^:]+";
            Set referencedScopes = referencedTypes.stream().map(t -> t.replaceAll(regex, "$1")).collect(Collectors.toSet());
            this.debug.accept("referenced scopes: " + referencedScopes);
            remainingScopes.addAll(referencedScopes);
        }
        return specifications;
    }

    private AstSpecificationNode parseSpecification(String resourceName, URL resource) throws IOException {
        AstSpecificationNode astSpecificationNode;
        block9: {
            InputStream input = resource.openStream();
            try {
                CharStream chars = CharStreams.fromStream((InputStream)input);
                NukleusLexer lexer = new NukleusLexer(chars);
                CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
                NukleusParser parser = new NukleusParser((TokenStream)tokens);
                parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
                NukleusParser.SpecificationContext ctx = parser.specification();
                astSpecificationNode = new AstParser().visitSpecification(ctx);
                if (input == null) break block9;
            }
            catch (Throwable chars) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable lexer) {
                            chars.addSuppressed(lexer);
                        }
                    }
                    throw chars;
                }
                catch (ParseCancellationException ex) {
                    RecognitionException re;
                    Token token;
                    Throwable cause = ex.getCause();
                    if (cause instanceof RecognitionException && (token = (re = (RecognitionException)cause).getOffendingToken()) != null) {
                        String message = String.format("Parse failed in %s at %d:%d on \"%s\"", resourceName, token.getLine(), token.getCharPositionInLine(), token.getText());
                        this.error.accept(message);
                    }
                    throw ex;
                }
            }
            input.close();
        }
        return astSpecificationNode;
    }

    private static final class ReferencedTypeResolver
    extends AstNode.Visitor<Set<String>> {
        private final Set<String> qualifiedNames = new HashSet<String>();

        private ReferencedTypeResolver() {
        }

        @Override
        public Set<String> visitStruct(AstStructNode structNode) {
            AstType supertype = structNode.supertype();
            if (supertype != null) {
                this.qualifiedNames.add(supertype.name());
            }
            return (Set)super.visitStruct(structNode);
        }

        @Override
        protected Set<String> defaultResult() {
            return this.qualifiedNames;
        }
    }
}

