/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstType;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ClassSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeNames;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeResolver;

public final class MapFlyweightGenerator
extends ClassSpecGenerator {
    private final TypeSpec.Builder builder;
    private final TypeName keyTypeName;
    private final TypeName valueTypeName;
    private final ClassName templateMapTypeName;
    private final TypeName parameterizedMapName;
    private final BuilderClassBuilder builderClassBuilder;

    public MapFlyweightGenerator(ClassName mapName, ClassName flyweightName, ClassName templateMapTypeName, AstType mapKeyType, ClassName mapKeyTypeName, AstType mapValueType, ClassName mapValueTypeName, TypeResolver resolver) {
        super(mapName);
        this.keyTypeName = (TypeName)Objects.requireNonNullElse(mapKeyTypeName, TypeVariableName.get((String)mapKeyType.name(), (TypeName[])new TypeName[]{flyweightName}));
        this.valueTypeName = (TypeName)Objects.requireNonNullElse(mapValueTypeName, TypeVariableName.get((String)mapValueType.name(), (TypeName[])new TypeName[]{flyweightName}));
        this.templateMapTypeName = templateMapTypeName;
        ClassName mapFWType = resolver.resolveClass(AstType.MAP);
        this.parameterizedMapName = mapKeyTypeName == null && mapValueTypeName == null ? ParameterizedTypeName.get((ClassName)mapName, (TypeName[])new TypeName[]{TypeVariableName.get((String)mapKeyType.name()), TypeVariableName.get((String)mapValueType.name())}) : (mapKeyTypeName == null ? ParameterizedTypeName.get((ClassName)mapName, (TypeName[])new TypeName[]{TypeVariableName.get((String)mapKeyType.name())}) : (mapValueTypeName == null ? ParameterizedTypeName.get((ClassName)mapName, (TypeName[])new TypeName[]{TypeVariableName.get((String)mapValueType.name())}) : mapName));
        this.builder = this.builder(mapName, mapFWType, flyweightName, mapKeyType, mapKeyTypeName, mapValueType, mapValueTypeName);
        this.builderClassBuilder = new BuilderClassBuilder(mapName, this.parameterizedMapName, mapFWType, flyweightName, templateMapTypeName, mapKeyType, mapKeyTypeName, this.keyTypeName, mapValueType, mapValueTypeName, this.valueTypeName);
    }

    private TypeSpec.Builder builder(ClassName mapName, ClassName mapFWType, ClassName flyweightName, AstType mapKeyType, ClassName mapKeyTypeName, AstType mapValueType, ClassName mapValueTypeName) {
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)mapName);
        if (mapKeyTypeName == null) {
            classBuilder.addTypeVariable(TypeVariableName.get((String)mapKeyType.name(), (TypeName[])new TypeName[]{flyweightName}));
        }
        if (mapValueTypeName == null) {
            classBuilder.addTypeVariable(TypeVariableName.get((String)mapValueType.name(), (TypeName[])new TypeName[]{flyweightName}));
        }
        ParameterizedTypeName superClassType = ParameterizedTypeName.get((ClassName)mapFWType, (TypeName[])new TypeName[]{this.keyTypeName, this.valueTypeName});
        return classBuilder.superclass((TypeName)superClassType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
    }

    @Override
    public TypeSpec generate() {
        return this.builder.addField(this.mapField()).addMethod(this.constructor()).addMethod(this.lengthMethod()).addMethod(this.fieldCountMethod()).addMethod(this.entriesMethod()).addMethod(this.forEachMethod()).addMethod(this.tryWrapMethod()).addMethod(this.wrapMethod()).addMethod(this.limitMethod()).addMethod(this.toStringMethod()).addType(this.builderClassBuilder.build()).build();
    }

    private FieldSpec mapField() {
        ParameterizedTypeName parameterizedMapTypeName = ParameterizedTypeName.get((ClassName)this.templateMapTypeName, (TypeName[])new TypeName[]{this.keyTypeName, this.valueTypeName});
        String fieldName = String.format("%sRO", MapFlyweightGenerator.fieldName((TypeName)this.templateMapTypeName));
        return FieldSpec.builder((TypeName)parameterizedMapTypeName, (String)fieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private MethodSpec constructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.keyTypeName, "keyRO", new Modifier[0]).addParameter(this.valueTypeName, "valueRO", new Modifier[0]).addStatement("$LRO = new $T<>(keyRO, valueRO)", new Object[]{MapFlyweightGenerator.fieldName((TypeName)this.templateMapTypeName), this.templateMapTypeName}).build();
    }

    private MethodSpec lengthMethod() {
        return MethodSpec.methodBuilder((String)"length").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return $LRO.get().length()", new Object[]{MapFlyweightGenerator.fieldName((TypeName)this.templateMapTypeName)}).build();
    }

    private MethodSpec fieldCountMethod() {
        return MethodSpec.methodBuilder((String)"fieldCount").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return $LRO.get().fieldCount()", new Object[]{MapFlyweightGenerator.fieldName((TypeName)this.templateMapTypeName)}).build();
    }

    private MethodSpec entriesMethod() {
        return MethodSpec.methodBuilder((String)"entries").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeNames.DIRECT_BUFFER_TYPE).addStatement("return $LRO.get().entries()", new Object[]{MapFlyweightGenerator.fieldName((TypeName)this.templateMapTypeName)}).build();
    }

    private MethodSpec forEachMethod() {
        ParameterizedTypeName parameterizedBiConsumerType = ParameterizedTypeName.get((ClassName)ClassName.get(BiConsumer.class), (TypeName[])new TypeName[]{this.keyTypeName, this.valueTypeName});
        return MethodSpec.methodBuilder((String)"forEach").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)parameterizedBiConsumerType, "consumer", new Modifier[0]).addStatement("$LRO.get().forEach(consumer)", new Object[]{MapFlyweightGenerator.fieldName((TypeName)this.templateMapTypeName)}).build();
    }

    private MethodSpec tryWrapMethod() {
        return MethodSpec.methodBuilder((String)"tryWrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.parameterizedMapName).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).beginControlFlow("if (super.tryWrap(buffer, offset, maxLimit) == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().beginControlFlow("if ($LRO.tryWrap(buffer, offset, maxLimit) == null)", new Object[]{MapFlyweightGenerator.fieldName((TypeName)this.templateMapTypeName)}).addStatement("return null", new Object[0]).endControlFlow().beginControlFlow("if (limit() > maxLimit)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("return this", new Object[0]).build();
    }

    private MethodSpec wrapMethod() {
        return MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.parameterizedMapName).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("$LRO.wrap(buffer, offset, maxLimit)", new Object[]{MapFlyweightGenerator.fieldName((TypeName)this.templateMapTypeName)}).addStatement("checkLimit(limit(), maxLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec limitMethod() {
        return MethodSpec.methodBuilder((String)"limit").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return $LRO.limit()", new Object[]{MapFlyweightGenerator.fieldName((TypeName)this.templateMapTypeName)}).build();
    }

    private MethodSpec toStringMethod() {
        return MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return String.format(\"$L[%d, %d]\", $LRO.get().length(), $LRO.get().fieldCount())", new Object[]{((ClassName)this.thisName).simpleName(), MapFlyweightGenerator.fieldName((TypeName)this.templateMapTypeName), MapFlyweightGenerator.fieldName((TypeName)this.templateMapTypeName)}).build();
    }

    private static String fieldName(TypeName type) {
        String fieldName = ((ClassName)type).simpleName();
        return String.format("%s%s", Character.valueOf(Character.toLowerCase(fieldName.charAt(0))), fieldName.substring(1, fieldName.length() - 2));
    }

    private static final class BuilderClassBuilder {
        private final TypeSpec.Builder classBuilder;
        private final ClassName mapName;
        private final TypeName parameterizedMapName;
        private final ClassName templateMapTypeName;
        private final TypeName keyTypeName;
        private final TypeName valueTypeName;
        private final TypeName keyBuilderTypeName;
        private final TypeName valueBuilderTypeName;
        private final TypeName parameterizedMapBuilderName;

        private BuilderClassBuilder(ClassName mapName, TypeName parameterizedMapName, ClassName mapFWName, ClassName flyweightType, ClassName templateMapTypeName, AstType mapKeyType, ClassName mapKeyTypeName, TypeName keyTypeName, AstType mapValueType, ClassName mapValueTypeName, TypeName valueTypeName) {
            this.mapName = mapName;
            this.parameterizedMapName = parameterizedMapName;
            this.templateMapTypeName = templateMapTypeName;
            this.keyTypeName = keyTypeName;
            this.valueTypeName = valueTypeName;
            ClassName mapBuilderName = mapName.nestedClass("Builder");
            ClassName mapFWBuilderName = mapFWName.nestedClass("Builder");
            ClassName flyweightBuilderType = flyweightType.nestedClass("Builder");
            this.keyBuilderTypeName = mapKeyTypeName != null ? mapKeyTypeName.nestedClass("Builder") : TypeVariableName.get((String)String.format("%s%s", mapKeyType.name(), "B"));
            this.valueBuilderTypeName = mapValueTypeName != null ? mapValueTypeName.nestedClass("Builder") : TypeVariableName.get((String)String.format("%s%s", mapValueType.name(), "B"));
            ParameterizedTypeName parameterizedMapFWBuilder = ParameterizedTypeName.get((ClassName)mapFWBuilderName, (TypeName[])new TypeName[]{parameterizedMapName, keyTypeName, valueTypeName, this.keyBuilderTypeName, this.valueBuilderTypeName});
            this.classBuilder = TypeSpec.classBuilder((String)mapBuilderName.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)parameterizedMapFWBuilder);
            if (mapKeyTypeName == null) {
                TypeVariableName typeVarK = TypeVariableName.get((String)mapKeyType.name(), (TypeName[])new TypeName[]{flyweightType});
                this.classBuilder.addTypeVariable(typeVarK).addTypeVariable(TypeVariableName.get((String)String.format("%s%s", mapKeyType.name(), "B"), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)flyweightBuilderType, (TypeName[])new TypeName[]{typeVarK})}));
            }
            if (mapValueTypeName == null) {
                TypeVariableName typeVarV = TypeVariableName.get((String)mapValueType.name(), (TypeName[])new TypeName[]{flyweightType});
                this.classBuilder.addTypeVariable(typeVarV).addTypeVariable(TypeVariableName.get((String)String.format("%s%s", mapValueType.name(), "B"), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)flyweightBuilderType, (TypeName[])new TypeName[]{typeVarV})}));
            }
            this.parameterizedMapBuilderName = mapKeyTypeName == null && mapValueTypeName == null ? ParameterizedTypeName.get((ClassName)mapBuilderName, (TypeName[])new TypeName[]{keyTypeName, valueTypeName, this.keyBuilderTypeName, this.valueBuilderTypeName}) : (mapKeyTypeName == null ? ParameterizedTypeName.get((ClassName)mapBuilderName, (TypeName[])new TypeName[]{keyTypeName, this.keyBuilderTypeName}) : (mapValueTypeName == null ? ParameterizedTypeName.get((ClassName)mapBuilderName, (TypeName[])new TypeName[]{valueTypeName, this.valueBuilderTypeName}) : mapBuilderName));
        }

        public TypeSpec build() {
            return this.classBuilder.addField(this.mapBuilderField()).addMethod(this.constructor()).addMethod(this.wrapMethod()).addMethod(this.entryMethod()).addMethod(this.entriesMethod()).addMethod(this.buildMethod()).build();
        }

        private FieldSpec mapBuilderField() {
            ParameterizedTypeName parameterizedMapTypeName = ParameterizedTypeName.get((ClassName)this.templateMapTypeName.nestedClass("Builder"), (TypeName[])new TypeName[]{this.keyTypeName, this.valueTypeName, this.keyBuilderTypeName, this.valueBuilderTypeName});
            String fieldName = String.format("%sRW", MapFlyweightGenerator.fieldName((TypeName)this.templateMapTypeName));
            return FieldSpec.builder((TypeName)parameterizedMapTypeName, (String)fieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        }

        private MethodSpec constructor() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.keyTypeName, "keyRO", new Modifier[0]).addParameter(this.valueTypeName, "valueRO", new Modifier[0]).addParameter(this.keyBuilderTypeName, "keyRW", new Modifier[0]).addParameter(this.valueBuilderTypeName, "valueRW", new Modifier[0]).addStatement("super(new $T<>(keyRO, valueRO))", new Object[]{this.mapName}).addStatement("$LRW = new $T.Builder<>(keyRO, valueRO, keyRW, valueRW)", new Object[]{MapFlyweightGenerator.fieldName((TypeName)this.templateMapTypeName), this.templateMapTypeName}).build();
        }

        private MethodSpec wrapMethod() {
            return MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.parameterizedMapBuilderName).addParameter((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("$LRW.wrap(buffer, offset, maxLimit)", new Object[]{MapFlyweightGenerator.fieldName((TypeName)this.templateMapTypeName)}).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec entryMethod() {
            ClassName consumerType = ClassName.get(Consumer.class);
            ParameterizedTypeName parameterizedConsumerTypeWithKey = ParameterizedTypeName.get((ClassName)consumerType, (TypeName[])new TypeName[]{this.keyBuilderTypeName});
            ParameterizedTypeName parameterizedConsumerTypeWithValue = ParameterizedTypeName.get((ClassName)consumerType, (TypeName[])new TypeName[]{this.valueBuilderTypeName});
            return MethodSpec.methodBuilder((String)"entry").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.parameterizedMapBuilderName).addParameter((TypeName)parameterizedConsumerTypeWithKey, "key", new Modifier[0]).addParameter((TypeName)parameterizedConsumerTypeWithValue, "value", new Modifier[0]).addStatement("$LRW.entry(key, value)", new Object[]{MapFlyweightGenerator.fieldName((TypeName)this.templateMapTypeName)}).addStatement("limit($LRW.limit())", new Object[]{MapFlyweightGenerator.fieldName((TypeName)this.templateMapTypeName)}).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec entriesMethod() {
            return MethodSpec.methodBuilder((String)"entries").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.parameterizedMapBuilderName).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "index", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).addParameter(Integer.TYPE, "fieldCount", new Modifier[0]).addStatement("$LRW.entries(buffer, index, length, fieldCount)", new Object[]{MapFlyweightGenerator.fieldName((TypeName)this.templateMapTypeName)}).addStatement("limit($LRW.limit())", new Object[]{MapFlyweightGenerator.fieldName((TypeName)this.templateMapTypeName)}).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec buildMethod() {
            return MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.parameterizedMapName).addStatement("limit($LRW.build().limit())", new Object[]{MapFlyweightGenerator.fieldName((TypeName)this.templateMapTypeName)}).addStatement("return super.build()", new Object[0]).build();
        }
    }
}

