/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.element.Modifier;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ClassSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ClassSpecMixinGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.MethodSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeNames;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeSpecGenerator;

public final class EnumTypeGenerator
extends ClassSpecGenerator {
    private final TypeSpec.Builder builder;
    private final NameConstantGenerator nameConstant;
    private final ValueOfMethodGenerator valueOfMethod;
    private final TypeName valueTypeName;
    private final TypeName unsignedValueTypeName;
    private ValueMethodGenerator valueMethod;
    private ConstructorGenerator constructor;
    private LongHashMapGenerator longHashMap;

    public EnumTypeGenerator(ClassName enumTypeName, TypeName valueTypeName, TypeName unsignedValueTypeName) {
        super(enumTypeName);
        this.builder = TypeSpec.enumBuilder((ClassName)enumTypeName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.nameConstant = new NameConstantGenerator(enumTypeName, valueTypeName, unsignedValueTypeName, this.builder);
        this.valueOfMethod = new ValueOfMethodGenerator(enumTypeName);
        this.valueTypeName = valueTypeName;
        this.unsignedValueTypeName = unsignedValueTypeName;
        if (this.isParameterizedType()) {
            this.valueMethod = new ValueMethodGenerator();
            this.constructor = new ConstructorGenerator();
        }
        if (this.isValueTypeLong()) {
            this.longHashMap = new LongHashMapGenerator(enumTypeName, this.builder);
        }
    }

    public TypeSpecGenerator<ClassName> addValue(String name, Object value) {
        this.nameConstant.addValue(name, value);
        this.valueOfMethod.addValue(name, value);
        if (this.isValueTypeLong()) {
            this.longHashMap.addValue(name, value);
        }
        return this;
    }

    @Override
    public TypeSpec generate() {
        this.nameConstant.build();
        if (this.isParameterizedType()) {
            if (this.isValueTypeLong()) {
                this.longHashMap.generate();
            }
            if (this.valueTypeName.isPrimitive()) {
                this.builder.addField(this.isTypeUnsignedInt() ? this.unsignedValueTypeName : this.valueTypeName, "value", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            } else {
                this.builder.addField(String.class, "value", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            }
            this.builder.addMethod(this.constructor.generate()).addMethod(this.valueMethod.generate());
        }
        return this.builder.addMethod(this.valueOfMethod.generate()).build();
    }

    private boolean isParameterizedType() {
        return this.valueTypeName != null;
    }

    private boolean isTypeUnsignedInt() {
        return this.valueTypeName != null && this.unsignedValueTypeName != null;
    }

    private boolean isValueTypeLong() {
        if (this.valueTypeName == null) {
            return false;
        }
        return Objects.requireNonNullElse(this.unsignedValueTypeName, this.valueTypeName).equals((Object)TypeName.LONG);
    }

    private boolean isValueTypeString() {
        return this.valueTypeName != null && !this.valueTypeName.isPrimitive();
    }

    private final class ValueOfMethodGenerator
    extends MethodSpecGenerator {
        private final List<String> constantNames;
        private final Map<String, Object> valueByConstantName;

        private ValueOfMethodGenerator(ClassName enumName) {
            super(MethodSpec.methodBuilder((String)"valueOf").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)enumName));
            this.constantNames = new LinkedList<String>();
            this.valueByConstantName = new HashMap<String, Object>();
        }

        public ValueOfMethodGenerator addValue(String name, Object value) {
            this.constantNames.add(name);
            if (value != null) {
                this.valueByConstantName.put(name, value);
            }
            return this;
        }

        @Override
        public MethodSpec generate() {
            String discriminant;
            String string = discriminant = EnumTypeGenerator.this.isParameterizedType() ? "value" : "ordinal";
            this.builder.addParameter(EnumTypeGenerator.this.isParameterizedType() ? (EnumTypeGenerator.this.isTypeUnsignedInt() ? EnumTypeGenerator.this.unsignedValueTypeName : EnumTypeGenerator.this.valueTypeName) : TypeName.INT, discriminant, new Modifier[0]);
            if (EnumTypeGenerator.this.isValueTypeLong()) {
                this.builder.addStatement("return VALUE_BY_LONG.get(value)", new Object[0]);
            } else {
                if (EnumTypeGenerator.this.isValueTypeString()) {
                    this.builder.addStatement("String kind = $L.asString()", new Object[]{discriminant});
                }
                this.builder.beginControlFlow("switch ($L)", new Object[]{EnumTypeGenerator.this.isValueTypeString() ? "kind" : discriminant});
                for (int index = 0; index < this.constantNames.size(); ++index) {
                    String enumConstant = this.constantNames.get(index);
                    Integer kind = this.valueByConstantName.get(enumConstant) == null ? Integer.valueOf(index) : this.valueByConstantName.get(enumConstant);
                    this.builder.beginControlFlow("case $L:", new Object[]{kind}).addStatement("return $N", new Object[]{enumConstant}).endControlFlow();
                }
                this.builder.endControlFlow().addStatement("return null", new Object[0]);
            }
            return this.builder.build();
        }
    }

    private final class ValueMethodGenerator
    extends MethodSpecGenerator {
        private ValueMethodGenerator() {
            super(MethodSpec.methodBuilder((String)"value").addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return $L", new Object[]{"value"}));
        }

        @Override
        public MethodSpec generate() {
            if (EnumTypeGenerator.this.valueTypeName.isPrimitive()) {
                this.builder.returns(EnumTypeGenerator.this.isTypeUnsignedInt() ? EnumTypeGenerator.this.unsignedValueTypeName : EnumTypeGenerator.this.valueTypeName);
            } else {
                this.builder.returns(String.class);
            }
            return this.builder.build();
        }
    }

    private final class ConstructorGenerator
    extends MethodSpecGenerator {
        private ConstructorGenerator() {
            super(MethodSpec.constructorBuilder().addStatement("this.$L = $L", new Object[]{"value", "value"}));
        }

        @Override
        public MethodSpec generate() {
            if (EnumTypeGenerator.this.valueTypeName.isPrimitive()) {
                this.builder.addParameter(EnumTypeGenerator.this.isTypeUnsignedInt() ? EnumTypeGenerator.this.unsignedValueTypeName : EnumTypeGenerator.this.valueTypeName, "value", new Modifier[0]);
            } else {
                this.builder.addParameter(String.class, "value", new Modifier[0]);
            }
            return this.builder.build();
        }
    }

    private static final class LongHashMapGenerator
    extends ClassSpecMixinGenerator {
        private final CodeBlock.Builder putStatementsBuilder;
        private int count;

        private LongHashMapGenerator(ClassName thisType, TypeSpec.Builder builder) {
            super(thisType, builder);
            builder.addField((TypeName)ParameterizedTypeName.get((ClassName)TypeNames.LONG_2_OBJECT_HASH_MAP_TYPE, (TypeName[])new TypeName[]{thisType}), "VALUE_BY_LONG", new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL});
            this.putStatementsBuilder = CodeBlock.builder();
        }

        public LongHashMapGenerator addValue(String name, Object value) {
            String putStatement = value instanceof String ? "valueByLong.put($L, $L)" : "valueByLong.put($LL, $L)";
            this.putStatementsBuilder.addStatement(putStatement, new Object[]{value, name});
            ++this.count;
            return this;
        }

        public TypeSpec generate() {
            return this.builder.addStaticBlock(CodeBlock.builder().addStatement("$T<$T> valueByLong = new $T<>($L, 0.9f)", new Object[]{TypeNames.LONG_2_OBJECT_HASH_MAP_TYPE, this.thisType, TypeNames.LONG_2_OBJECT_HASH_MAP_TYPE, this.count}).add(this.putStatementsBuilder.build()).addStatement("VALUE_BY_LONG = valueByLong", new Object[0]).build()).build();
        }
    }

    private static final class NameConstantGenerator
    extends ClassSpecMixinGenerator {
        private final TypeName valueTypeName;
        private final TypeName unsignedValueTypeName;

        private NameConstantGenerator(ClassName thisType, TypeName valueTypeName, TypeName unsignedValueTypeName, TypeSpec.Builder builder) {
            super(thisType, builder);
            this.valueTypeName = valueTypeName;
            this.unsignedValueTypeName = unsignedValueTypeName;
        }

        public NameConstantGenerator addValue(String name, Object value) {
            if (value == null) {
                this.builder.addEnumConstant(name);
            } else {
                TypeName valueType;
                TypeName typeName = valueType = this.unsignedValueTypeName == null ? this.valueTypeName : this.unsignedValueTypeName;
                if (valueType.equals((Object)TypeName.BYTE) || valueType.equals((Object)TypeName.SHORT)) {
                    this.builder.addEnumConstant(name, TypeSpec.anonymousClassBuilder((String)"($L) $L", (Object[])new Object[]{valueType, value}).build());
                } else if (valueType.equals((Object)TypeName.LONG)) {
                    String longValue = value instanceof String ? "$L" : "$LL";
                    this.builder.addEnumConstant(name, TypeSpec.anonymousClassBuilder((String)longValue, (Object[])new Object[]{value}).build());
                } else {
                    this.builder.addEnumConstant(name, TypeSpec.anonymousClassBuilder((String)"$L", (Object[])new Object[]{value}).build());
                }
            }
            return this;
        }
    }
}

