/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.reaktivity.nukleus.maven.plugin.internal.Parser;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstSpecificationNode;

public abstract class AbstractMojo
extends org.apache.maven.plugin.AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="src/main/reaktivity")
    protected File inputDirectory;
    @Parameter(defaultValue="src/main/resources/META-INF/reaktivity")
    protected File metaDirectory;
    @Parameter(required=true)
    protected String scopeNames;
    private Parser parser = new Parser().debug(arg_0 -> ((Log)this.getLog()).debug(arg_0)).error(arg_0 -> ((Log)this.getLog()).error(arg_0)).warn(arg_0 -> ((Log)this.getLog()).warn(arg_0));

    protected abstract void executeImpl() throws IOException;

    protected final List<AstSpecificationNode> parseAST(List<String> targetScopes) throws IOException {
        return this.parser.parseAST(targetScopes, this.createLoader());
    }

    ClassLoader createLoader() throws IOException {
        LinkedList<URL> resourcePath = new LinkedList<URL>();
        resourcePath.add(this.inputDirectory.getAbsoluteFile().toURI().toURL());
        resourcePath.add(this.metaDirectory.getAbsoluteFile().toURI().toURL());
        try {
            for (Object resourcePathEntry : this.project.getTestClasspathElements()) {
                File resourcePathFile = new File(resourcePathEntry.toString());
                URI resourcePathURI = resourcePathFile.getAbsoluteFile().toURI();
                resourcePath.add(URI.create(String.format("jar:%s!/META-INF/reaktivity/", resourcePathURI)).toURL());
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IOException(e);
        }
        this.getLog().debug((CharSequence)("resource path: " + resourcePath));
        ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
        return new URLClassLoader(resourcePath.toArray(new URL[resourcePath.size()]), parent);
    }
}

