/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.generate;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ParameterizedTypeSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeNames;

public final class Map8FWGenerator
extends ParameterizedTypeSpecGenerator {
    private final TypeSpec.Builder classBuilder;
    private final TypeVariableName typeVarK;
    private final TypeVariableName typeVarV;
    private final BuilderClassBuilder builderClassBuilder;

    public Map8FWGenerator(ClassName flyweightType, ParameterizedTypeName mapType) {
        super(ParameterizedTypeName.get((ClassName)flyweightType.peerClass("Map8FW"), (TypeName[])new TypeName[]{TypeVariableName.get((String)"K", (TypeName[])new TypeName[]{flyweightType}), TypeVariableName.get((String)"V", (TypeName[])new TypeName[]{flyweightType})}));
        this.typeVarK = (TypeVariableName)((ParameterizedTypeName)this.thisName).typeArguments.get(0);
        this.typeVarV = (TypeVariableName)((ParameterizedTypeName)this.thisName).typeArguments.get(1);
        this.classBuilder = TypeSpec.classBuilder((ClassName)this.thisRawName).superclass((TypeName)mapType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addTypeVariable(this.typeVarK).addTypeVariable(this.typeVarV);
        this.builderClassBuilder = new BuilderClassBuilder((ParameterizedTypeName)this.thisName, mapType, flyweightType);
    }

    @Override
    public TypeSpec generate() {
        return this.classBuilder.addField(this.lengthSizeConstant()).addField(this.fieldCountSizeConstant()).addField(this.lengthOffsetConstant()).addField(this.fieldCountOffsetConstant()).addField(this.fieldsOffsetConstant()).addField(this.lengthMaxValueConstant()).addField(this.keyField()).addField(this.valueField()).addField(this.entriesField()).addMethod(this.constructor()).addMethod(this.lengthMethod()).addMethod(this.fieldCountMethod()).addMethod(this.entriesMethod()).addMethod(this.forEachMethod()).addMethod(this.tryWrapMethod()).addMethod(this.wrapMethod()).addMethod(this.limitMethod()).addMethod(this.toStringMethod()).addType(this.builderClassBuilder.build()).build();
    }

    private FieldSpec lengthSizeConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"LENGTH_SIZE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.SIZE_OF_BYTE", new Object[]{TypeNames.BIT_UTIL_TYPE}).build();
    }

    private FieldSpec fieldCountSizeConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"FIELD_COUNT_SIZE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.SIZE_OF_BYTE", new Object[]{TypeNames.BIT_UTIL_TYPE}).build();
    }

    private FieldSpec lengthOffsetConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"LENGTH_OFFSET", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("0", new Object[0]).build();
    }

    private FieldSpec fieldCountOffsetConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"FIELD_COUNT_OFFSET", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("LENGTH_OFFSET + LENGTH_SIZE", new Object[0]).build();
    }

    private FieldSpec fieldsOffsetConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"FIELDS_OFFSET", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("FIELD_COUNT_OFFSET + FIELD_COUNT_SIZE", new Object[0]).build();
    }

    private FieldSpec lengthMaxValueConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"LENGTH_MAX_VALUE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("0xFF", new Object[0]).build();
    }

    private FieldSpec keyField() {
        return FieldSpec.builder((TypeName)this.typeVarK, (String)"keyRO", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private FieldSpec valueField() {
        return FieldSpec.builder((TypeName)this.typeVarV, (String)"valueRO", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private FieldSpec entriesField() {
        return FieldSpec.builder((TypeName)TypeNames.DIRECT_BUFFER_TYPE, (String)"entriesRO", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T(0L, 0)", new Object[]{TypeNames.UNSAFE_BUFFER_TYPE}).build();
    }

    private MethodSpec constructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.typeVarK, "keyRO", new Modifier[0]).addParameter((TypeName)this.typeVarV, "valueRO", new Modifier[0]).addStatement("this.keyRO = keyRO", new Object[0]).addStatement("this.valueRO = valueRO", new Object[0]).build();
    }

    private MethodSpec lengthMethod() {
        return MethodSpec.methodBuilder((String)"length").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return buffer().getByte(offset() + LENGTH_OFFSET)", new Object[0]).build();
    }

    private MethodSpec fieldCountMethod() {
        return MethodSpec.methodBuilder((String)"fieldCount").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return buffer().getByte(offset() + FIELD_COUNT_OFFSET)", new Object[0]).build();
    }

    private MethodSpec entriesMethod() {
        return MethodSpec.methodBuilder((String)"entries").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeNames.DIRECT_BUFFER_TYPE).addStatement("return entriesRO", new Object[0]).build();
    }

    private MethodSpec forEachMethod() {
        ParameterizedTypeName parameterizedBiConsumerType = ParameterizedTypeName.get((ClassName)ClassName.get(BiConsumer.class), (TypeName[])new TypeName[]{this.typeVarK, this.typeVarV});
        return MethodSpec.methodBuilder((String)"forEach").addAnnotation(Override.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "\"unchecked\"", new Object[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)parameterizedBiConsumerType, "consumer", new Modifier[0]).addStatement("int offset = offset() + FIELDS_OFFSET", new Object[0]).addStatement("int fieldCount = fieldCount()", new Object[0]).beginControlFlow("for (int i = 0; i < fieldCount; i += 2)", new Object[0]).addStatement("K key = (K) keyRO.wrap(buffer(), offset, limit())", new Object[0]).addStatement("V value = (V) valueRO.wrap(buffer(), key.limit(), limit())", new Object[0]).addStatement("consumer.accept(key, value)", new Object[0]).addStatement("offset = value.limit()", new Object[0]).endControlFlow().build();
    }

    private MethodSpec tryWrapMethod() {
        return MethodSpec.methodBuilder((String)"tryWrap").addAnnotation(Override.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "\"unchecked\"", new Object[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName).beginControlFlow("if (super.tryWrap(buffer, offset, maxLimit) == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("int entryOffset = offset + FIELDS_OFFSET", new Object[0]).addStatement("int fieldCount = fieldCount()", new Object[0]).beginControlFlow("for (int i = 0; i < fieldCount; i += 2)", new Object[0]).addStatement("K key = (K) keyRO.tryWrap(buffer, entryOffset, maxLimit)", new Object[0]).beginControlFlow("if (key == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("V value = (V) valueRO.tryWrap(buffer, key.limit(), maxLimit)", new Object[0]).beginControlFlow("if (value == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("entryOffset = value.limit()", new Object[0]).endControlFlow().addStatement("final int itemsSize = length() - FIELD_COUNT_SIZE", new Object[0]).addStatement("entriesRO.wrap(buffer, offset + FIELDS_OFFSET, itemsSize)", new Object[0]).beginControlFlow("if (limit() > maxLimit)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("return this", new Object[0]).build();
    }

    private MethodSpec wrapMethod() {
        return MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "\"unchecked\"", new Object[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("int entryOffset = offset + FIELDS_OFFSET", new Object[0]).addStatement("int fieldCount = fieldCount()", new Object[0]).beginControlFlow("for (int i = 0; i < fieldCount; i += 2)", new Object[0]).addStatement("K key = (K) keyRO.wrap(buffer, entryOffset, maxLimit)", new Object[0]).addStatement("V value = (V) valueRO.wrap(buffer, key.limit(), maxLimit)", new Object[0]).addStatement("entryOffset = value.limit()", new Object[0]).endControlFlow().addStatement("final int itemsSize = length() - FIELD_COUNT_SIZE", new Object[0]).addStatement("entriesRO.wrap(buffer, offset + FIELDS_OFFSET, itemsSize)", new Object[0]).addStatement("checkLimit(limit(), maxLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec limitMethod() {
        return MethodSpec.methodBuilder((String)"limit").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return offset() + LENGTH_SIZE + length()", new Object[0]).build();
    }

    private MethodSpec toStringMethod() {
        return MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return String.format(\"map8<%d, %d>\", length(), fieldCount())", new Object[0]).build();
    }

    private static final class BuilderClassBuilder {
        private final ParameterizedTypeName map8Type;
        private final TypeSpec.Builder classBuilder;
        private final TypeVariableName typeVarKB;
        private final TypeVariableName typeVarK;
        private final TypeVariableName typeVarVB;
        private final TypeVariableName typeVarV;
        private final TypeName parameterizedBuilderType;

        private BuilderClassBuilder(ParameterizedTypeName map8Type, ParameterizedTypeName mapType, ClassName flyweightType) {
            ClassName map8BuilderType = map8Type.rawType.nestedClass("Builder");
            ClassName mapBuilderType = mapType.rawType.nestedClass("Builder");
            ClassName flyweightBuilderType = flyweightType.nestedClass("Builder");
            this.map8Type = map8Type;
            this.typeVarK = TypeVariableName.get((String)"K", (TypeName[])new TypeName[]{flyweightType});
            this.typeVarKB = TypeVariableName.get((String)"KB", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)flyweightBuilderType, (TypeName[])new TypeName[]{this.typeVarK})});
            this.typeVarV = TypeVariableName.get((String)"V", (TypeName[])new TypeName[]{flyweightType});
            this.typeVarVB = TypeVariableName.get((String)"VB", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)flyweightBuilderType, (TypeName[])new TypeName[]{this.typeVarV})});
            ParameterizedTypeName parameterizedMapBuilderType = ParameterizedTypeName.get((ClassName)mapBuilderType, (TypeName[])new TypeName[]{map8Type, this.typeVarK, this.typeVarV, this.typeVarKB, this.typeVarVB});
            this.parameterizedBuilderType = ParameterizedTypeName.get((ClassName)map8BuilderType, (TypeName[])new TypeName[]{this.typeVarK, this.typeVarV, this.typeVarKB, this.typeVarVB});
            this.classBuilder = TypeSpec.classBuilder((String)map8BuilderType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)parameterizedMapBuilderType).addTypeVariable(this.typeVarK).addTypeVariable(this.typeVarV).addTypeVariable(this.typeVarKB).addTypeVariable(this.typeVarVB);
        }

        public TypeSpec build() {
            return this.classBuilder.addField(this.fieldCountField()).addField(this.keyRWField()).addField(this.valueRWField()).addMethod(this.constructor()).addMethod(this.wrapMethod()).addMethod(this.entryMethod()).addMethod(this.entriesMethod()).addMethod(this.buildMethod()).build();
        }

        private FieldSpec fieldCountField() {
            return FieldSpec.builder(Integer.TYPE, (String)"fieldCount", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        }

        private FieldSpec keyRWField() {
            return FieldSpec.builder((TypeName)this.typeVarKB, (String)"keyRW", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        }

        private FieldSpec valueRWField() {
            return FieldSpec.builder((TypeName)this.typeVarVB, (String)"valueRW", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        }

        private MethodSpec constructor() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.typeVarK, "keyRO", new Modifier[0]).addParameter((TypeName)this.typeVarV, "valueRO", new Modifier[0]).addParameter((TypeName)this.typeVarKB, "keyRW", new Modifier[0]).addParameter((TypeName)this.typeVarVB, "valueRW", new Modifier[0]).addStatement("super(new Map8FW<>(keyRO, valueRO))", new Object[0]).addStatement("this.keyRW = keyRW", new Object[0]).addStatement("this.valueRW = valueRW", new Object[0]).build();
        }

        private MethodSpec wrapMethod() {
            return MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.parameterizedBuilderType).addParameter((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("int newLimit = offset + FIELDS_OFFSET", new Object[0]).addStatement("checkLimit(newLimit, maxLimit)", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("fieldCount = 0", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec entryMethod() {
            ParameterizedTypeName parameterizedConsumerTypeKey = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{this.typeVarKB});
            ParameterizedTypeName parameterizedConsumerTypeValue = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{this.typeVarVB});
            return MethodSpec.methodBuilder((String)"entry").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.parameterizedBuilderType).addParameter((TypeName)parameterizedConsumerTypeKey, "key", new Modifier[0]).addParameter((TypeName)parameterizedConsumerTypeValue, "value", new Modifier[0]).addStatement("keyRW.wrap(buffer(), limit(), maxLimit())", new Object[0]).addStatement("key.accept(keyRW)", new Object[0]).addStatement("checkLimit(keyRW.limit(), maxLimit())", new Object[0]).addStatement("limit(keyRW.limit())", new Object[0]).addStatement("fieldCount++", new Object[0]).addStatement("valueRW.wrap(buffer(), limit(), maxLimit())", new Object[0]).addStatement("value.accept(valueRW)", new Object[0]).addStatement("checkLimit(valueRW.limit(), maxLimit())", new Object[0]).addStatement("limit(valueRW.limit())", new Object[0]).addStatement("fieldCount++", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec entriesMethod() {
            return MethodSpec.methodBuilder((String)"entries").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.parameterizedBuilderType).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "srcOffset", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).addParameter(Integer.TYPE, "fieldCount", new Modifier[0]).addStatement("buffer().putBytes(offset() + FIELDS_OFFSET, buffer, srcOffset, length)", new Object[0]).addStatement("int newLimit = offset() + FIELDS_OFFSET + length", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("this.fieldCount = fieldCount", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec buildMethod() {
            return MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.map8Type).addStatement("int length = limit() - offset() - FIELD_COUNT_OFFSET", new Object[0]).addStatement("assert length <= LENGTH_MAX_VALUE : \"Length is too large\"", new Object[0]).addStatement("assert fieldCount <= LENGTH_MAX_VALUE : \"Field count is too large\"", new Object[0]).addStatement("buffer().putByte(offset() + LENGTH_OFFSET, (byte) length)", new Object[0]).addStatement("buffer().putByte(offset() + FIELD_COUNT_OFFSET, (byte) fieldCount)", new Object[0]).addStatement("return super.build()", new Object[0]).build();
        }
    }
}

