/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.ast;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstEnumNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstListNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstMapNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstStructNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstTypedefNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstUnionNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstVariantNode;

public final class AstScopeNode
extends AstNode {
    private final int depth;
    private final String name;
    private final List<AstScopeNode> scopes;
    private final List<AstEnumNode> enums;
    private final List<AstStructNode> structs;
    private final List<AstUnionNode> unions;
    private final List<AstVariantNode> variants;
    private final List<AstListNode> lists;
    private final List<AstTypedefNode> typedefs;
    private final List<AstMapNode> maps;

    private AstScopeNode(int depth, String name, List<AstEnumNode> enums, List<AstStructNode> structs, List<AstUnionNode> unions, List<AstScopeNode> scopes, List<AstVariantNode> variants, List<AstListNode> lists, List<AstTypedefNode> typedefs, List<AstMapNode> maps) {
        this.depth = depth;
        this.name = Objects.requireNonNull(name);
        this.enums = Collections.unmodifiableList(enums);
        this.structs = Collections.unmodifiableList(structs);
        this.unions = Collections.unmodifiableList(unions);
        this.scopes = Collections.unmodifiableList(scopes);
        this.variants = Collections.unmodifiableList(variants);
        this.lists = Collections.unmodifiableList(lists);
        this.typedefs = typedefs;
        this.maps = maps;
    }

    @Override
    public <R> R accept(AstNode.Visitor<R> visitor) {
        return visitor.visitScope(this);
    }

    public int depth() {
        return this.depth;
    }

    public String name() {
        return this.name;
    }

    public List<AstEnumNode> enums() {
        return this.enums;
    }

    public List<AstStructNode> structs() {
        return this.structs;
    }

    public List<AstUnionNode> unions() {
        return this.unions;
    }

    public List<AstScopeNode> scopes() {
        return this.scopes;
    }

    public List<AstVariantNode> variants() {
        return this.variants;
    }

    public List<AstListNode> lists() {
        return this.lists;
    }

    public List<AstTypedefNode> typedefs() {
        return this.typedefs;
    }

    public List<AstMapNode> maps() {
        return this.maps;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() << 23 ^ this.scopes.hashCode() << 19 ^ this.enums.hashCode() << 17 ^ this.structs.hashCode() << 13 ^ this.unions.hashCode() << 11 ^ this.variants.hashCode() << 7 ^ this.lists.hashCode() << 5 ^ this.typedefs.hashCode() << 3 ^ this.maps.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AstScopeNode)) {
            return false;
        }
        AstScopeNode that = (AstScopeNode)o;
        return this.depth == that.depth && Objects.equals(this.name, that.name) && Objects.equals(this.enums, that.enums) && Objects.equals(this.structs, that.structs) && Objects.equals(this.unions, that.unions) && Objects.equals(this.scopes, that.scopes) && Objects.equals(this.variants, that.variants) && Objects.equals(this.lists, that.lists) && Objects.equals(this.typedefs, that.typedefs) && Objects.equals(this.maps, that.maps);
    }

    public static final class Builder
    extends AstNode.Builder<AstScopeNode> {
        private int depth;
        private String name;
        private List<AstScopeNode> scopes = new LinkedList<AstScopeNode>();
        private List<AstEnumNode> enums = new LinkedList<AstEnumNode>();
        private List<AstStructNode> structs = new LinkedList<AstStructNode>();
        private List<AstUnionNode> unions = new LinkedList<AstUnionNode>();
        private List<AstVariantNode> variants = new LinkedList<AstVariantNode>();
        private List<AstListNode> lists = new LinkedList<AstListNode>();
        private List<AstTypedefNode> typedefs = new LinkedList<AstTypedefNode>();
        private List<AstMapNode> maps = new LinkedList<AstMapNode>();

        public Builder depth(int depth) {
            this.depth = depth;
            return this;
        }

        public String name() {
            return this.name;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder enumeration(AstEnumNode enumeration) {
            this.enums.add(enumeration);
            return this;
        }

        public Builder struct(AstStructNode struct) {
            this.structs.add(struct);
            return this;
        }

        public Builder union(AstUnionNode union) {
            this.unions.add(union);
            return this;
        }

        public Builder scope(AstScopeNode scope) {
            this.scopes.add(scope);
            return this;
        }

        public Builder variant(AstVariantNode variant) {
            this.variants.add(variant);
            return this;
        }

        public Builder list(AstListNode list) {
            this.lists.add(list);
            return this;
        }

        public Builder typedef(AstTypedefNode typedef) {
            this.typedefs.add(typedef);
            return this;
        }

        public Builder map(AstMapNode map) {
            this.maps.add(map);
            return this;
        }

        @Override
        public AstScopeNode build() {
            return new AstScopeNode(this.depth, this.name, this.enums, this.structs, this.unions, this.scopes, this.variants, this.lists, this.typedefs, this.maps);
        }
    }
}

