/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.ast;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNamedNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstType;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstValueNode;

public final class AstEnumNode
extends AstNamedNode {
    private final List<AstValueNode> values;
    private final AstType valueType;

    @Override
    public <R> R accept(AstNode.Visitor<R> visitor) {
        return visitor.visitEnum(this);
    }

    public List<AstValueNode> values() {
        return this.values;
    }

    public AstType valueType() {
        return this.valueType;
    }

    @Override
    public AstNamedNode withName(String name) {
        return new AstEnumNode(name, this.values, this.valueType);
    }

    @Override
    public AstNamedNode.Kind getKind() {
        return AstNamedNode.Kind.ENUM;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.values, this.valueType);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AstEnumNode)) {
            return false;
        }
        AstEnumNode that = (AstEnumNode)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.values, that.values) && Objects.equals(this.valueType, that.valueType);
    }

    public String toString() {
        return String.format("ENUM [name=%s, values=%s, valueType=%s]", this.name, this.values, this.valueType);
    }

    private AstEnumNode(String name, List<AstValueNode> values, AstType valueType) {
        super(name);
        this.values = Collections.unmodifiableList(values);
        this.valueType = valueType;
    }

    public static final class Builder
    extends AstNamedNode.Builder<AstEnumNode> {
        private List<AstValueNode> values = new LinkedList<AstValueNode>();
        private AstType valueType;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder value(AstValueNode value) {
            this.values.add(value);
            return this;
        }

        public Builder valueType(AstType valueType) {
            this.valueType = valueType;
            return this;
        }

        public AstType valueType() {
            return this.valueType;
        }

        public int size() {
            return this.values.size();
        }

        @Override
        public AstEnumNode build() {
            return new AstEnumNode(this.name, this.values, this.valueType);
        }
    }
}

