/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.ast;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstByteOrder;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstListMemberNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNamedNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstType;

public final class AstListNode
extends AstNamedNode {
    private final List<AstListMemberNode> members;
    private final AstType templateType;
    private final AstType lengthType;
    private final AstType fieldCountType;
    private final Byte missingFieldByte;
    private final AstByteOrder byteOrder;

    public List<AstListMemberNode> members() {
        return this.members;
    }

    public AstType templateType() {
        return this.templateType;
    }

    public AstType lengthType() {
        return this.lengthType;
    }

    public AstType fieldCountType() {
        return this.fieldCountType;
    }

    public Byte missingFieldByte() {
        return this.missingFieldByte;
    }

    public AstByteOrder byteOrder() {
        return this.byteOrder;
    }

    @Override
    public AstNamedNode withName(String name) {
        return new AstListNode(name, this.members, this.templateType, this.lengthType, this.fieldCountType, this.missingFieldByte, this.byteOrder);
    }

    @Override
    public AstNamedNode.Kind getKind() {
        return AstNamedNode.Kind.LIST;
    }

    @Override
    public <R> R accept(AstNode.Visitor<R> visitor) {
        return visitor.visitList(this);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.members, this.templateType, this.lengthType, this.fieldCountType, this.byteOrder});
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AstListNode)) {
            return false;
        }
        AstListNode that = (AstListNode)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.members, that.members) && Objects.equals(this.templateType, that.templateType) && Objects.equals(this.lengthType, that.lengthType) && Objects.equals(this.fieldCountType, that.fieldCountType) && Objects.equals((Object)this.byteOrder, (Object)that.byteOrder);
    }

    private AstListNode(String name, List<AstListMemberNode> members, AstType templateType, AstType lengthType, AstType fieldCountType, Byte missingFieldByte, AstByteOrder byteOrder) {
        super(name);
        this.members = Collections.unmodifiableList(members);
        this.templateType = templateType;
        this.lengthType = lengthType;
        this.fieldCountType = fieldCountType;
        this.missingFieldByte = missingFieldByte;
        this.byteOrder = byteOrder;
    }

    public static final class Builder
    extends AstNamedNode.Builder<AstListNode> {
        private List<AstListMemberNode> members = new LinkedList<AstListMemberNode>();
        private AstType templateType;
        private AstType lengthType;
        private AstType fieldCountType;
        private Byte missingFieldByte;
        private AstByteOrder byteOrder = AstByteOrder.NATIVE;

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder member(AstListMemberNode member) {
            this.members.add(member);
            return this;
        }

        public Builder templateType(AstType templateType) {
            this.templateType = templateType;
            return this;
        }

        public Builder lengthType(AstType lengthType) {
            this.lengthType = lengthType;
            return this;
        }

        public Builder fieldCountType(AstType fieldCountType) {
            this.fieldCountType = fieldCountType;
            return this;
        }

        public Builder missingFieldByte(Byte missingFieldByte) {
            this.missingFieldByte = missingFieldByte;
            return this;
        }

        public Builder byteOrder(AstByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public AstListNode build() {
            return new AstListNode(this.name, this.members, this.templateType, this.lengthType, this.fieldCountType, this.missingFieldByte, this.byteOrder);
        }
    }
}

