/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.ast;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstByteOrder;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNamedNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstNode;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstType;
import org.reaktivity.nukleus.maven.plugin.internal.ast.AstVariantCaseNode;

public final class AstVariantNode
extends AstNamedNode {
    private final AstType ofType;
    private final AstType kindType;
    private final List<AstVariantCaseNode> cases;
    private final AstByteOrder byteOrder;

    @Override
    public <R> R accept(AstNode.Visitor<R> visitor) {
        return visitor.visitVariant(this);
    }

    @Override
    public AstNamedNode.Kind getKind() {
        return AstNamedNode.Kind.VARIANT;
    }

    public AstType of() {
        return this.ofType;
    }

    public AstType kindType() {
        return this.kindType;
    }

    public List<AstVariantCaseNode> cases() {
        return this.cases;
    }

    @Override
    public AstNamedNode withName(String name) {
        return new AstVariantNode(name, this.ofType, this.kindType, this.cases, this.byteOrder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.ofType, this.kindType, this.cases, this.byteOrder});
    }

    public AstByteOrder byteOrder() {
        return this.byteOrder;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AstVariantNode)) {
            return false;
        }
        AstVariantNode that = (AstVariantNode)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.cases, that.cases) && Objects.equals(this.ofType, that.ofType) && Objects.equals(this.kindType, that.kindType) && Objects.equals((Object)this.byteOrder, (Object)that.byteOrder);
    }

    private AstVariantNode(String name, AstType ofType, AstType kindType, List<AstVariantCaseNode> cases, AstByteOrder byteOrder) {
        super(name);
        this.ofType = ofType;
        this.kindType = kindType;
        this.cases = Collections.unmodifiableList(cases);
        this.byteOrder = byteOrder;
    }

    public static final class Builder
    extends AstNamedNode.Builder<AstVariantNode> {
        private AstType ofType;
        private List<AstVariantCaseNode> cases = new LinkedList<AstVariantCaseNode>();
        private AstType kindType;
        private AstByteOrder byteOrder = AstByteOrder.NATIVE;

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder of(AstType ofType) {
            this.ofType = ofType;
            return this;
        }

        public Builder kindType(AstType kindType) {
            this.kindType = kindType;
            return this;
        }

        public Builder byteOrder(AstByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public Builder caseN(AstVariantCaseNode caseN) {
            this.cases.add(caseN);
            return this;
        }

        public AstVariantNode build() {
            return new AstVariantNode(this.name, this.ofType, this.kindType, this.cases, this.byteOrder);
        }
    }
}

