/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.nio.charset.Charset;
import javax.lang.model.element.Modifier;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ClassSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeNames;

public final class StringFlyweightGenerator
extends ClassSpecGenerator {
    private final TypeSpec.Builder classBuilder;
    private final BuilderClassBuilder builderClassBuilder;

    public StringFlyweightGenerator(ClassName flyweightType) {
        super(flyweightType.peerClass("StringFW"));
        this.classBuilder = TypeSpec.classBuilder((ClassName)((ClassName)this.thisName)).superclass((TypeName)flyweightType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
        this.builderClassBuilder = new BuilderClassBuilder((ClassName)this.thisName, flyweightType.nestedClass("Builder"));
    }

    @Override
    public TypeSpec generate() {
        return this.classBuilder.addMethod(this.fieldSizeLengthMethod()).addMethod(this.asStringMethod()).addMethod(this.lengthMethod()).addType(this.builderClassBuilder.build()).build();
    }

    private MethodSpec fieldSizeLengthMethod() {
        return MethodSpec.methodBuilder((String)"fieldSizeLength").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(Integer.TYPE).build();
    }

    private MethodSpec asStringMethod() {
        return MethodSpec.methodBuilder((String)"asString").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(String.class).build();
    }

    private MethodSpec lengthMethod() {
        return MethodSpec.methodBuilder((String)"length").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(Integer.TYPE).build();
    }

    private static final class BuilderClassBuilder {
        private final TypeSpec.Builder classBuilder;
        private final ClassName classType;
        private final ClassName stringType;
        private final TypeVariableName parameterType;

        private BuilderClassBuilder(ClassName stringType, ClassName builderRawType) {
            this.parameterType = TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{stringType});
            ParameterizedTypeName builderType = ParameterizedTypeName.get((ClassName)builderRawType, (TypeName[])new TypeName[]{this.parameterType});
            this.stringType = stringType;
            this.classType = stringType.nestedClass("Builder");
            this.classBuilder = TypeSpec.classBuilder((String)this.classType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT, Modifier.STATIC}).superclass((TypeName)builderType).addTypeVariable(this.parameterType);
        }

        public TypeSpec build() {
            return this.classBuilder.addMethod(this.constructor()).addMethod(this.setMethod()).addMethod(this.setDirectBufferMethod()).addMethod(this.setStringMethod()).build();
        }

        private MethodSpec constructor() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.parameterType, "flyweight", new Modifier[0]).addStatement("super(flyweight)", new Object[0]).build();
        }

        private MethodSpec setMethod() {
            return MethodSpec.methodBuilder((String)"set").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)this.classType).addParameter((TypeName)this.stringType, "value", new Modifier[0]).build();
        }

        private MethodSpec setDirectBufferMethod() {
            return MethodSpec.methodBuilder((String)"set").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)this.classType).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "srcBuffer", new Modifier[0]).addParameter(Integer.TYPE, "srcOffset", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).build();
        }

        private MethodSpec setStringMethod() {
            return MethodSpec.methodBuilder((String)"set").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)this.classType).addParameter(String.class, "value", new Modifier[0]).addParameter(Charset.class, "charset", new Modifier[0]).build();
        }
    }
}

