/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.maven.plugin.internal.generate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.nio.ByteOrder;
import javax.lang.model.element.Modifier;
import org.reaktivity.nukleus.maven.plugin.internal.generate.ClassSpecGenerator;
import org.reaktivity.nukleus.maven.plugin.internal.generate.TypeNames;

public final class BoundedOctets16FlyweightGenerator
extends ClassSpecGenerator {
    private final TypeSpec.Builder classBuilder;
    private final ClassName visitorClass;
    private final BuilderClassBuilder builderClassBuilder;

    public BoundedOctets16FlyweightGenerator(ClassName flyweightType, ClassName boundedOctetsType) {
        super(flyweightType.peerClass("BoundedOctets16FW"));
        this.visitorClass = flyweightType.nestedClass("Visitor");
        this.classBuilder = TypeSpec.classBuilder((ClassName)((ClassName)this.thisName)).superclass((TypeName)boundedOctetsType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        this.builderClassBuilder = new BuilderClassBuilder((ClassName)this.thisName, boundedOctetsType);
    }

    @Override
    public TypeSpec generate() {
        return this.classBuilder.addField(this.lengthSizeConstant()).addField(this.lengthOffsetConstant()).addField(this.valueOffsetConstant()).addField(this.valueField()).addField(this.byteOrderField()).addMethod(this.constructor()).addMethod(this.constructorWithByteOrder()).addMethod(this.getMethod()).addMethod(this.valueMethod()).addMethod(this.lengthMethod()).addMethod(this.tryWrapMethod()).addMethod(this.wrapMethod()).addMethod(this.limitMethod()).addMethod(this.toStringMethod()).addType(this.builderClassBuilder.build()).build();
    }

    private FieldSpec lengthSizeConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"LENGTH_SIZE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.SIZE_OF_SHORT", new Object[]{TypeNames.BIT_UTIL_TYPE}).build();
    }

    private FieldSpec lengthOffsetConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"LENGTH_OFFSET", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("0", new Object[0]).build();
    }

    private FieldSpec valueOffsetConstant() {
        return FieldSpec.builder(Integer.TYPE, (String)"VALUE_OFFSET", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("LENGTH_OFFSET + LENGTH_SIZE", new Object[0]).build();
    }

    private FieldSpec valueField() {
        return FieldSpec.builder((TypeName)TypeNames.DIRECT_BUFFER_TYPE, (String)"valueRO", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T(0L, 0)", new Object[]{TypeNames.UNSAFE_BUFFER_TYPE}).build();
    }

    private FieldSpec byteOrderField() {
        return FieldSpec.builder(ByteOrder.class, (String)"byteOrder", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private MethodSpec constructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.byteOrder = $T.nativeOrder()", new Object[]{ByteOrder.class}).build();
    }

    private MethodSpec constructorWithByteOrder() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ByteOrder.class, "byteOrder", new Modifier[0]).addStatement("this.byteOrder = byteOrder", new Object[0]).build();
    }

    private MethodSpec getMethod() {
        TypeVariableName typeVarT = TypeVariableName.get((String)"T");
        return MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(typeVarT).returns((TypeName)typeVarT).addParameter((TypeName)ParameterizedTypeName.get((ClassName)this.visitorClass, (TypeName[])new TypeName[]{typeVarT}), "visitor", new Modifier[0]).addStatement("return visitor.visit(buffer(), offset() + VALUE_OFFSET, limit())", new Object[0]).build();
    }

    private MethodSpec valueMethod() {
        return MethodSpec.methodBuilder((String)"value").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeNames.DIRECT_BUFFER_TYPE).addStatement("return valueRO", new Object[0]).build();
    }

    private MethodSpec lengthMethod() {
        return MethodSpec.methodBuilder((String)"length").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return buffer().getShort(offset() + LENGTH_OFFSET, byteOrder) & 0xFFFF", new Object[0]).build();
    }

    private MethodSpec tryWrapMethod() {
        return MethodSpec.methodBuilder((String)"tryWrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName).beginControlFlow("if (super.tryWrap(buffer, offset, maxLimit) == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("valueRO.wrap(buffer, offset + VALUE_OFFSET, length())", new Object[0]).beginControlFlow("if (limit() > maxLimit)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("return this", new Object[0]).build();
    }

    private MethodSpec wrapMethod() {
        return MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).returns(this.thisName).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("valueRO.wrap(buffer, offset + VALUE_OFFSET, length())", new Object[0]).addStatement("checkLimit(limit(), maxLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec limitMethod() {
        return MethodSpec.methodBuilder((String)"limit").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return offset() + LENGTH_SIZE + length()", new Object[0]).build();
    }

    private MethodSpec toStringMethod() {
        return MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return String.format(\"boundedOctets16[%d]\", length())", new Object[0]).build();
    }

    private static final class BuilderClassBuilder {
        private final TypeSpec.Builder classBuilder;
        private final ClassName boundedOctets16BuilderType;
        private final ClassName boundedOctetsType;

        private BuilderClassBuilder(ClassName boundedOctets16Type, ClassName boundedOctetsType) {
            this.boundedOctets16BuilderType = boundedOctets16Type.nestedClass("Builder");
            this.boundedOctetsType = boundedOctetsType;
            ClassName boundedOctetsBuilderType = boundedOctetsType.nestedClass("Builder");
            this.classBuilder = TypeSpec.classBuilder((String)this.boundedOctets16BuilderType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)ParameterizedTypeName.get((ClassName)boundedOctetsBuilderType, (TypeName[])new TypeName[]{boundedOctets16Type}));
        }

        public TypeSpec build() {
            return this.classBuilder.addField(this.byteOrderField()).addMethod(this.constructor()).addMethod(this.constructorWithByteOrder()).addMethod(this.setWithFlyweight()).addMethod(this.setWithBuffer()).addMethod(this.setWithByteArray()).addMethod(this.wrapMethod()).build();
        }

        private FieldSpec byteOrderField() {
            return FieldSpec.builder(ByteOrder.class, (String)"byteOrder", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        }

        private MethodSpec constructor() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super(new BoundedOctets16FW())", new Object[0]).addStatement("this.byteOrder = $T.nativeOrder()", new Object[]{ByteOrder.class}).build();
        }

        private MethodSpec constructorWithByteOrder() {
            return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ByteOrder.class, "byteOrder", new Modifier[0]).addStatement("super(new BoundedOctets16FW(byteOrder))", new Object[0]).addStatement("this.byteOrder = byteOrder", new Object[0]).build();
        }

        private MethodSpec setWithFlyweight() {
            return MethodSpec.methodBuilder((String)"set").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.boundedOctets16BuilderType).addParameter((TypeName)this.boundedOctetsType, "value", new Modifier[0]).addStatement("int newLimit = offset() + LENGTH_SIZE + value.length()", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putShort(offset() + LENGTH_OFFSET, (short) (value.length() & 0xFFFF), byteOrder)", new Object[0]).addStatement("buffer().putBytes(offset() + VALUE_OFFSET, value.buffer(), value.offset() + VALUE_OFFSET, value.length())", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec setWithBuffer() {
            return MethodSpec.methodBuilder((String)"set").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.boundedOctets16BuilderType).addParameter((TypeName)TypeNames.DIRECT_BUFFER_TYPE, "value", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "length", new Modifier[0]).addStatement("int newLimit = offset() + LENGTH_SIZE + length", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putShort(offset() + LENGTH_OFFSET, (short) (length & 0xFFFF), byteOrder)", new Object[0]).addStatement("buffer().putBytes(offset() + VALUE_OFFSET, value, offset, length)", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec setWithByteArray() {
            return MethodSpec.methodBuilder((String)"set").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.boundedOctets16BuilderType).addParameter(byte[].class, "value", new Modifier[0]).addStatement("int newLimit = offset() + LENGTH_SIZE + value.length", new Object[0]).addStatement("checkLimit(newLimit, maxLimit())", new Object[0]).addStatement("buffer().putShort(offset() + LENGTH_OFFSET, (short) (value.length & 0xFFFF), byteOrder)", new Object[0]).addStatement("buffer().putBytes(offset() + VALUE_OFFSET, value)", new Object[0]).addStatement("limit(newLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
        }

        private MethodSpec wrapMethod() {
            return MethodSpec.methodBuilder((String)"wrap").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.boundedOctets16BuilderType).addParameter((TypeName)TypeNames.MUTABLE_DIRECT_BUFFER_TYPE, "buffer", new Modifier[0]).addParameter(Integer.TYPE, "offset", new Modifier[0]).addParameter(Integer.TYPE, "maxLimit", new Modifier[0]).addStatement("checkLimit(offset + LENGTH_SIZE, maxLimit)", new Object[0]).addStatement("super.wrap(buffer, offset, maxLimit)", new Object[0]).addStatement("return this", new Object[0]).build();
        }
    }
}

