/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.util;

import scala.Array$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

public final class SimpleRing<T> {
    private final int capacity;
    private final ClassTag<T> evidence$1;
    private int head;
    private int tail;
    private int nextIndex;
    private boolean full;
    private boolean empty;
    private final Object queue;

    public SimpleRing(int capacity, ClassTag<T> evidence$1) {
        this.capacity = capacity;
        this.evidence$1 = evidence$1;
        this.head = 0;
        this.tail = 0;
        this.nextIndex = 0;
        this.full = false;
        this.empty = true;
        this.queue = Array$.MODULE$.ofDim(capacity, evidence$1);
    }

    public int capacity() {
        return this.capacity;
    }

    private Object queue() {
        return this.queue;
    }

    public int enqueue(T elem) {
        ScalaRunTime$.MODULE$.array_update(this.queue(), this.tail, elem);
        if (!this.full) {
            ++this.nextIndex;
            this.full = this.nextIndex == this.capacity();
            this.empty = false;
        } else {
            this.head = (this.head + 1) % this.capacity();
        }
        this.tail = (this.head + this.nextIndex) % this.capacity();
        return this.nextIndex;
    }

    public Object toArray() {
        if (this.empty) {
            return Array$.MODULE$.empty(this.evidence$1);
        }
        int sz = this.nextIndex;
        Object readCopy = Array$.MODULE$.ofDim(sz, this.evidence$1);
        int h = this.head;
        if (sz < this.capacity()) {
            Array$.MODULE$.copy(this.queue(), h, readCopy, 0, sz);
        } else {
            int s1 = this.capacity() - h;
            Array$.MODULE$.copy(this.queue(), h, readCopy, 0, s1);
            Array$.MODULE$.copy(this.queue(), 0, readCopy, s1, h);
        }
        return readCopy;
    }

    public Option<T> dequeue() {
        if (this.empty) {
            return Option$.MODULE$.empty();
        }
        Object elem = ScalaRunTime$.MODULE$.array_apply(this.queue(), this.head);
        --this.nextIndex;
        this.head = (this.head + 1) % this.capacity();
        this.full = this.nextIndex == this.capacity();
        return Option$.MODULE$.apply(elem);
    }

    private Tuple4<Object, Object, Object, Object> internalState() {
        return Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.capacity()), (Object)BoxesRunTime.boxToInteger((int)this.head), (Object)BoxesRunTime.boxToInteger((int)this.tail), (Object)BoxesRunTime.boxToInteger((int)this.nextIndex));
    }

    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof SimpleRing) {
            Object object2;
            SimpleRing other = (SimpleRing)object;
            Tuple4<Object, Object, Object, Object> tuple4 = this.internalState();
            Tuple4<Object, Object, Object, Object> tuple42 = other.internalState();
            return !(tuple4 != null ? !tuple4.equals(tuple42) : tuple42 != null) && ArrayOps$.MODULE$.equals$extension(object2 = Predef$.MODULE$.genericArrayOps(this.queue()), other.queue());
        }
        return false;
    }

    public int hashCode() {
        int nh = MurmurHash3$.MODULE$.mix(-889275714, Statics.anyHash(this.internalState()));
        return MurmurHash3$.MODULE$.mixLast(nh, MurmurHash3$.MODULE$.arrayHash(this.queue()));
    }
}

