/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.core.netty;

import akka.actor.ActorRef;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import reactivemongo.api.MongoConnectionOptions;
import reactivemongo.api.MongoConnectionOptions$KeyStore$;
import reactivemongo.core.SSL;
import reactivemongo.core.actors.ChannelDisconnected;
import reactivemongo.core.actors.ChannelDisconnected$;
import reactivemongo.core.errors.GenericDriverException;
import reactivemongo.core.errors.GenericDriverException$;
import reactivemongo.core.netty.ChannelFactory$;
import reactivemongo.core.netty.ChannelFactory$TrustAny$;
import reactivemongo.core.netty.Pack;
import reactivemongo.core.netty.Pack$;
import reactivemongo.core.protocol.MongoHandler;
import reactivemongo.core.protocol.RequestEncoder;
import reactivemongo.core.protocol.ResponseDecoder;
import reactivemongo.core.protocol.ResponseFrameDecoder;
import reactivemongo.io.netty.channel.package;
import reactivemongo.util.LazyLogger;
import reactivemongo.util.LazyLogger$;
import reactivemongo.util.package$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.concurrent.Promise;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals$;
import scala.util.Failure$;
import scala.util.Random;
import scala.util.Success$;
import scala.util.Try;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ChannelFactory
extends ChannelInitializer<Channel> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ChannelFactory.class.getDeclaredField("0bitmap$1"));
    public long 0bitmap$1;
    private final String supervisor;
    private final String connection;
    private final MongoConnectionOptions options;
    private final Pack pack;
    private final EventLoopGroup parentGroup;
    private final LazyLogger.LazyLogger logger;
    private final Boolean tcpNoDelay;
    private final Boolean keepAlive;
    private final Integer timeoutMs;
    private ChannelFactory$TrustAny$ TrustAny$lzy1;

    public static AttributeKey<ActorRef> actorRefKey() {
        return ChannelFactory$.MODULE$.actorRefKey();
    }

    public static AttributeKey<String> hostKey() {
        return ChannelFactory$.MODULE$.hostKey();
    }

    public static AttributeKey<Object> maxIdleTimeKey() {
        return ChannelFactory$.MODULE$.maxIdleTimeKey();
    }

    public static AttributeKey<Object> portKey() {
        return ChannelFactory$.MODULE$.portKey();
    }

    public ChannelFactory(String supervisor, String connection, MongoConnectionOptions options) {
        this.supervisor = supervisor;
        this.connection = connection;
        this.options = options;
        this.pack = Pack$.MODULE$.apply();
        this.parentGroup = (EventLoopGroup)this.pack.eventLoopGroup().apply();
        this.logger = LazyLogger$.MODULE$.apply("reactivemongo.core.nodeset.ChannelFactory");
        this.tcpNoDelay = options.tcpNoDelay();
        this.keepAlive = options.keepAlive();
        this.timeoutMs = options.connectTimeoutMS();
    }

    public Try<Channel> create(String host, int port, int maxIdleTimeMS, ActorRef receiver) {
        if (this.parentGroup.isShuttingDown() || this.parentGroup.isShutdown() || this.parentGroup.isTerminated()) {
            String msg = new StringBuilder(50).append("Cannot create channel to '").append(host).append(":").append(port).append("' from inactive factory").toString();
            this.info((Function0<String>)((Function0 & Serializable)() -> ChannelFactory.create$$anonfun$1(msg)));
            return Failure$.MODULE$.apply((Throwable)new GenericDriverException(new StringBuilder(4).append(msg).append(" (").append(this.supervisor).append("/").append(this.connection).append(")").toString(), GenericDriverException$.MODULE$.$lessinit$greater$default$2()));
        }
        Bootstrap f = this.channelFactory();
        f.attr(ChannelFactory$.MODULE$.hostKey(), (Object)host);
        f.attr(ChannelFactory$.MODULE$.portKey(), (Object)BoxesRunTime.boxToInteger((int)port));
        f.attr(ChannelFactory$.MODULE$.actorRefKey(), (Object)receiver);
        f.attr(ChannelFactory$.MODULE$.maxIdleTimeKey(), (Object)BoxesRunTime.boxToInteger((int)maxIdleTimeMS));
        ChannelFuture resolution = f.connect(host, port).addListener((GenericFutureListener)new ChannelFutureListener(host, port, receiver, this){
            private final String host$1;
            private final int port$1;
            private final ActorRef receiver$1;
            private final /* synthetic */ ChannelFactory $outer;
            {
                this.host$1 = host$4;
                this.port$1 = port$4;
                this.receiver$1 = receiver$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void operationComplete(ChannelFuture op) {
                if (!op.isSuccess()) {
                    ChannelId chanId = op.channel().id();
                    this.$outer.reactivemongo$core$netty$ChannelFactory$$debug((Function0<String>)((Function0 & Serializable)() -> this.operationComplete$$anonfun$1(chanId)), op.cause());
                    ChannelDisconnected channelDisconnected = ChannelDisconnected$.MODULE$.apply(chanId);
                    this.receiver$1.$bang((Object)channelDisconnected, this.receiver$1.$bang$default$2((Object)channelDisconnected));
                    return;
                }
            }

            private final String operationComplete$$anonfun$1(ChannelId chanId$1) {
                return new StringBuilder(37).append("Connection to ").append(this.host$1).append(":").append(this.port$1).append(" refused for channel #").append(chanId$1).toString();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{operationComplete$$anonfun$1(io.netty.channel.ChannelId )}, serializedLambda);
            }
        });
        Channel channel = resolution.channel();
        this.debug((Function0<String>)((Function0 & Serializable)() -> ChannelFactory.create$$anonfun$2(host, port, channel)));
        return Success$.MODULE$.apply((Object)channel);
    }

    public String create$default$1() {
        return "localhost";
    }

    public int create$default$2() {
        return 27017;
    }

    public int create$default$3() {
        return this.options.maxIdleTimeMS();
    }

    public void initChannel(Channel channel) {
        String host = (String)channel.attr(ChannelFactory$.MODULE$.hostKey()).get();
        int port = BoxesRunTime.unboxToInt((Object)channel.attr(ChannelFactory$.MODULE$.portKey()).get());
        int maxIdleTimeMS = BoxesRunTime.unboxToInt((Object)channel.attr(ChannelFactory$.MODULE$.maxIdleTimeKey()).get());
        ActorRef receiver = (ActorRef)channel.attr(ChannelFactory$.MODULE$.actorRefKey()).get();
        this.initChannel(channel, host, port, maxIdleTimeMS, receiver);
    }

    public void initChannel(Channel channel, String host, int port, int maxIdleTimeMS, ActorRef receiver) {
        this.debug((Function0<String>)((Function0 & Serializable)() -> ChannelFactory.initChannel$$anonfun$1(channel, host, port, receiver)));
        ChannelPipeline pipeline = channel.pipeline();
        long idleTimeMS = maxIdleTimeMS;
        pipeline.addLast("idleState", (ChannelHandler)new IdleStateHandler(idleTimeMS, idleTimeMS, 0L, TimeUnit.MILLISECONDS));
        if (this.options.sslEnabled()) {
            SSLEngine sslEng = SSL.createEngine(this.sslContext(), host, port);
            SslHandler sslHandler = new SslHandler(sslEng, false);
            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
        }
        pipeline.addLast(new ChannelHandler[]{new ResponseFrameDecoder(), new ResponseDecoder(), new RequestEncoder(), new MongoHandler(this.supervisor, this.connection, receiver)});
        this.trace((Function0<String>)((Function0 & Serializable)this::initChannel$$anonfun$2));
    }

    private Option<MongoConnectionOptions.KeyStore> keyStore() {
        return this.options.keyStore().orElse(ChannelFactory::keyStore$$anonfun$1);
    }

    private SSLContext sslContext() {
        LazyRef lazyRef = new LazyRef();
        Option keyManagers = this.loadedStore$1(lazyRef).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                KeyStore ks = (KeyStore)tuple2._1();
                char[] password = (char[])tuple2._2();
                KeyManagerFactory res = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                res.init(ks, password);
                KeyManagerFactory kmf = res;
                return kmf.getKeyManagers();
            }
            throw new MatchError((Object)tuple2);
        });
        return this.sslCtx$1(keyManagers, lazyRef);
    }

    private Bootstrap channelFactory() {
        return (Bootstrap)new Bootstrap().group(this.parentGroup).channel(this.pack.channelClass()).option(package.ChannelOption$.MODULE$.TCP_NODELAY(), (Object)this.tcpNoDelay).option(package.ChannelOption$.MODULE$.SO_KEEPALIVE(), (Object)this.keepAlive).option(package.ChannelOption$.MODULE$.CONNECT_TIMEOUT_MILLIS(), (Object)this.timeoutMs).handler((ChannelHandler)this);
    }

    public void release(Promise<BoxedUnit> callback, FiniteDuration timeout) {
        if (this.parentGroup.iterator().hasNext()) {
            this.parentGroup.shutdownGracefully(0L, timeout.length(), timeout.unit()).addListener((GenericFutureListener)new GenericFutureListener<Future<Object>>(callback, this){
                private final Promise callback$2;
                {
                    this.callback$2 = callback$3;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                }

                public void operationComplete(Future f) {
                    ChannelFactory.reactivemongo$core$netty$ChannelFactory$$_$ok$1(this.callback$2);
                }
            });
            return;
        }
        ChannelFactory.reactivemongo$core$netty$ChannelFactory$$_$ok$1(callback);
    }

    private void debug(Function0<String> msg) {
        this.logger.debug((Function0<String>)((Function0 & Serializable)() -> this.debug$$anonfun$1(msg)));
    }

    public void reactivemongo$core$netty$ChannelFactory$$debug(Function0<String> msg, Throwable cause) {
        this.logger.debug((Function0<String>)((Function0 & Serializable)() -> this.debug$$anonfun$2(msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ChannelFactory.debug$$anonfun$3(cause)));
    }

    private void trace(Function0<String> msg) {
        this.logger.trace((Function0<String>)((Function0 & Serializable)() -> this.trace$$anonfun$1(msg)));
    }

    private void info(Function0<String> msg) {
        this.logger.info((Function0<String>)((Function0 & Serializable)() -> this.info$$anonfun$1(msg)));
    }

    private final ChannelFactory$TrustAny$ TrustAny() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    ChannelFactory$TrustAny$ channelFactory$TrustAny$;
                    this.TrustAny$lzy1 = channelFactory$TrustAny$ = new ChannelFactory$TrustAny$();
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return channelFactory$TrustAny$;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.TrustAny$lzy1;
    }

    private static final String create$$anonfun$1(String msg$1) {
        return msg$1;
    }

    private static final String create$$anonfun$2(String host$2, int port$2, Channel channel$1) {
        return new StringBuilder(42).append("Created new channel #").append(channel$1.id()).append(" to ").append(host$2).append(":").append(port$2).append(" (registered = ").append(channel$1.isRegistered()).append(")").toString();
    }

    private static final String initChannel$$anonfun$1(Channel channel$2, String host$3, int port$3, ActorRef receiver$2) {
        return new StringBuilder(29).append("Initializing channel ").append(channel$2.id()).append(" to ").append(host$3).append(":").append(port$3).append(" (").append(receiver$2).append(")").toString();
    }

    private static final String initChannel$$anonfun$2$$anonfun$1() {
        return "None";
    }

    private final String initChannel$$anonfun$2() {
        return new StringBuilder(126).append("Netty channel configuration:\n- connectTimeoutMS: ").append(this.options.connectTimeoutMS()).append("\n- maxIdleTimeMS: ").append(this.options.maxIdleTimeMS()).append("ms\n- tcpNoDelay: ").append(this.options.tcpNoDelay()).append("\n- keepAlive: ").append(this.options.keepAlive()).append("\n- sslEnabled: ").append(this.options.sslEnabled()).append("\n- keyStore: ").append(this.options.keyStore().fold(ChannelFactory::initChannel$$anonfun$2$$anonfun$1, (Function1 & Serializable)_$1 -> _$1.toString())).toString();
    }

    private static final String $anonfun$1() {
        return "JKS";
    }

    private static final Option keyStore$$anonfun$1() {
        return scala.sys.package$.MODULE$.props().get("javax.net.ssl.keyStore").map((Function1 & Serializable)path -> {
            URI uRI = new File((String)path).toURI();
            String string = (String)scala.sys.package$.MODULE$.props().getOrElse((Object)"javax.net.ssl.keyStoreType", ChannelFactory::$anonfun$1);
            Option option = scala.sys.package$.MODULE$.props().get("javax.net.ssl.keyStorePassword").map((Function1 & Serializable)_$2 -> _$2.toCharArray());
            return MongoConnectionOptions$KeyStore$.MODULE$.apply(uRI, (Option<char[]>)option, string, true);
        });
    }

    private static final char[] $anonfun$3() {
        return (char[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Character.TYPE));
    }

    private final Option loadedStore$lzyINIT1$1(LazyRef loadedStore$lzy1$1) {
        Option option;
        LazyRef lazyRef = loadedStore$lzy1$1;
        synchronized (lazyRef) {
            option = (Option)(loadedStore$lzy1$1.initialized() ? loadedStore$lzy1$1.value() : loadedStore$lzy1$1.initialize((Object)this.keyStore().map((Function1 & Serializable)settings -> {
                char[] password = (char[])settings.password().getOrElse(ChannelFactory::$anonfun$3);
                return (Tuple2)package$.MODULE$.withContent(settings.resource(), (Function1 & Serializable)storeIn -> {
                    KeyStore res = KeyStore.getInstance(settings.storeType());
                    res.load((InputStream)storeIn, password);
                    KeyStore keyStore = (KeyStore)Predef$.MODULE$.ArrowAssoc((Object)res);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)keyStore, (Object)password);
                });
            })));
        }
        return option;
    }

    private final Option loadedStore$1(LazyRef loadedStore$lzy1$2) {
        return (Option)(loadedStore$lzy1$2.initialized() ? loadedStore$lzy1$2.value() : this.loadedStore$lzyINIT1$1(loadedStore$lzy1$2));
    }

    private static final boolean trust$1$$anonfun$1() {
        return true;
    }

    private final boolean trust$1() {
        return BoxesRunTime.unboxToBoolean((Object)this.keyStore().fold(ChannelFactory::trust$1$$anonfun$1, (Function1 & Serializable)_$3 -> _$3.trust()));
    }

    private static final TrustManager[] $anonfun$5() {
        return null;
    }

    private final SSLContext sslCtx$1(Option keyManagers$1, LazyRef loadedStore$lzy1$3) {
        SSLContext res = SSLContext.getInstance("SSL");
        TrustManager[] tm = this.options.sslAllowsInvalidCert() ? new TrustManager[]{this.TrustAny()} : (!this.trust$1() ? (TrustManager[])null : (TrustManager[])this.loadedStore$1(loadedStore$lzy1$3).fold(ChannelFactory::$anonfun$5, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                KeyStore ks = (KeyStore)tuple2._1();
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(ks);
                return tmf.getTrustManagers();
            }
            throw new MatchError((Object)tuple2);
        }));
        Random rand = new Random(System.identityHashCode(tm));
        byte[] seed = new byte[128];
        rand.nextBytes(seed);
        res.init((KeyManager[])keyManagers$1.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), tm, new SecureRandom(seed));
        return res;
    }

    public static final void reactivemongo$core$netty$ChannelFactory$$_$ok$1(Promise callback$1) {
        callback$1.success((Object)BoxedUnit.UNIT);
    }

    private final String debug$$anonfun$1(Function0 msg$2) {
        return new StringBuilder(4).append("[").append(this.supervisor).append("/").append(this.connection).append("] ").append(msg$2.apply()).toString();
    }

    private final String debug$$anonfun$2(Function0 msg$3) {
        return new StringBuilder(4).append("[").append(this.supervisor).append("/").append(this.connection).append("] ").append(msg$3.apply()).toString();
    }

    private static final Throwable debug$$anonfun$3(Throwable cause$1) {
        return cause$1;
    }

    private final String trace$$anonfun$1(Function0 msg$4) {
        return new StringBuilder(4).append("[").append(this.supervisor).append("/").append(this.connection).append("] ").append(msg$4.apply()).toString();
    }

    private final String info$$anonfun$1(Function0 msg$5) {
        return new StringBuilder(4).append("[").append(this.supervisor).append("/").append(this.connection).append("] ").append(msg$5.apply()).toString();
    }
}

