/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api.gridfs;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.security.MessageDigest;
import java.util.Arrays;
import reactivemongo.api.Collation;
import reactivemongo.api.Collection;
import reactivemongo.api.CollectionStats;
import reactivemongo.api.Cursor;
import reactivemongo.api.Cursor$;
import reactivemongo.api.Cursor$Cont$;
import reactivemongo.api.Cursor$Fail$;
import reactivemongo.api.CursorProducer;
import reactivemongo.api.CursorProducer$;
import reactivemongo.api.DB;
import reactivemongo.api.FailingCursor$;
import reactivemongo.api.FailoverStrategy;
import reactivemongo.api.PackSupport;
import reactivemongo.api.ReadConcern;
import reactivemongo.api.ReadPreference;
import reactivemongo.api.SerializationPack;
import reactivemongo.api.Session;
import reactivemongo.api.WriteConcern;
import reactivemongo.api.collections.HintFactory;
import reactivemongo.api.collections.QueryBuilderFactory;
import reactivemongo.api.commands.CollStats;
import reactivemongo.api.commands.CollStats$;
import reactivemongo.api.commands.Command;
import reactivemongo.api.commands.Command$;
import reactivemongo.api.commands.CommandCodecs$;
import reactivemongo.api.commands.CommandCodecsWithPack;
import reactivemongo.api.commands.CommandException$Code$;
import reactivemongo.api.commands.CommandException$Message$;
import reactivemongo.api.commands.Create;
import reactivemongo.api.commands.Create$;
import reactivemongo.api.commands.CreateCollection$;
import reactivemongo.api.commands.DefaultWriteResult;
import reactivemongo.api.commands.DeleteCommand;
import reactivemongo.api.commands.InsertCommand;
import reactivemongo.api.commands.UpdateCommand;
import reactivemongo.api.commands.UpdateWriteResultFactory;
import reactivemongo.api.commands.UpsertedFactory;
import reactivemongo.api.commands.WriteResult;
import reactivemongo.api.gridfs.FileToSave;
import reactivemongo.api.gridfs.GridFS;
import reactivemongo.api.gridfs.GridFS$;
import reactivemongo.api.gridfs.GridFS$Chunk$3$;
import reactivemongo.api.gridfs.GridFS$FileReader$;
import reactivemongo.api.gridfs.GridFSCompat;
import reactivemongo.api.gridfs.ReadFile;
import reactivemongo.api.gridfs.package$;
import reactivemongo.api.indexes.Index$;
import reactivemongo.api.indexes.IndexType;
import reactivemongo.api.indexes.IndexType$Ascending$;
import reactivemongo.api.indexes.IndexesManager;
import reactivemongo.core.errors.GenericDriverException;
import reactivemongo.core.errors.GenericDriverException$;
import reactivemongo.core.protocol.MongoWireVersion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.control.NonFatal$;

public interface GridFS<P extends SerializationPack>
extends GridFSCompat,
PackSupport<P>,
InsertCommand<P>,
DeleteCommand<P>,
UpdateCommand<P>,
UpdateWriteResultFactory<P>,
UpsertedFactory<P>,
CommandCodecsWithPack<P>,
QueryBuilderFactory<P> {
    public static <P extends SerializationPack> GridFS<P> apply(P p, DB dB, String string) {
        return GridFS$.MODULE$.apply(p, dB, string);
    }

    public static void $init$(GridFS $this) {
    }

    public DB db();

    public String prefix();

    public static Option session$(GridFS $this) {
        return $this.session();
    }

    @Override
    default public Option<Session> session() {
        return this.db().session();
    }

    public static Collection reactivemongo$api$gridfs$GridFS$$fileColl$(GridFS $this) {
        return $this.reactivemongo$api$gridfs$GridFS$$fileColl();
    }

    default public Collection reactivemongo$api$gridfs$GridFS$$fileColl() {
        return new Collection(this){
            private final DB db;
            private final String name;
            private final FailoverStrategy failoverStrategy;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.db = $outer.db();
                this.name = new StringBuilder(6).append($outer.prefix()).append(".files").toString();
                this.failoverStrategy = this.db().failoverStrategy();
            }

            public DB db() {
                return this.db;
            }

            public String name() {
                return this.name;
            }

            public FailoverStrategy failoverStrategy() {
                return this.failoverStrategy;
            }
        };
    }

    public static Collection reactivemongo$api$gridfs$GridFS$$chunkColl$(GridFS $this) {
        return $this.reactivemongo$api$gridfs$GridFS$$chunkColl();
    }

    default public Collection reactivemongo$api$gridfs$GridFS$$chunkColl() {
        return new Collection(this){
            private final DB db;
            private final String name;
            private final FailoverStrategy failoverStrategy;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.db = $outer.db();
                this.name = new StringBuilder(7).append($outer.prefix()).append(".chunks").toString();
                this.failoverStrategy = this.db().failoverStrategy();
            }

            public DB db() {
                return this.db;
            }

            public String name() {
                return this.name;
            }

            public FailoverStrategy failoverStrategy() {
                return this.failoverStrategy;
            }
        };
    }

    public static QueryBuilderFactory.QueryBuilder reactivemongo$api$gridfs$GridFS$$fileQueryBuilder$(GridFS $this) {
        return $this.reactivemongo$api$gridfs$GridFS$$fileQueryBuilder();
    }

    default public QueryBuilderFactory.QueryBuilder reactivemongo$api$gridfs$GridFS$$fileQueryBuilder() {
        Collection collection = this.reactivemongo$api$gridfs$GridFS$$fileColl();
        FailoverStrategy failoverStrategy = this.db().failoverStrategy();
        ReadConcern readConcern = this.db().connection().options().readConcern();
        ReadPreference readPreference = this.db().defaultReadPreference();
        int n = this.QueryBuilder().$lessinit$greater$default$3();
        int n2 = this.QueryBuilder().$lessinit$greater$default$4();
        int n3 = this.QueryBuilder().$lessinit$greater$default$5();
        Option<Object> option = this.QueryBuilder().$lessinit$greater$default$8();
        Option<Object> option2 = this.QueryBuilder().$lessinit$greater$default$9();
        Option<Object> option3 = this.QueryBuilder().$lessinit$greater$default$10();
        Option<Object> option4 = this.QueryBuilder().$lessinit$greater$default$11();
        Option<Object> option5 = this.QueryBuilder().$lessinit$greater$default$12();
        Option<HintFactory.Hint> option6 = this.QueryBuilder().$lessinit$greater$default$13();
        boolean bl = this.QueryBuilder().$lessinit$greater$default$14();
        boolean bl2 = this.QueryBuilder().$lessinit$greater$default$15();
        Option<String> option7 = this.QueryBuilder().$lessinit$greater$default$16();
        Option<Object> option8 = this.QueryBuilder().$lessinit$greater$default$17();
        Option<Object> option9 = this.QueryBuilder().$lessinit$greater$default$18();
        boolean bl3 = this.QueryBuilder().$lessinit$greater$default$19();
        Option<Object> option10 = this.QueryBuilder().$lessinit$greater$default$20();
        boolean bl4 = this.QueryBuilder().$lessinit$greater$default$21();
        boolean bl5 = this.QueryBuilder().$lessinit$greater$default$22();
        Option<Collation> option11 = this.QueryBuilder().$lessinit$greater$default$23();
        return new QueryBuilderFactory.QueryBuilder(this, collection, failoverStrategy, n, n2, n3, readConcern, readPreference, option, option2, option3, option4, option5, option6, bl, bl2, option7, option8, option9, bl3, option10, bl4, bl5, option11);
    }

    public static QueryBuilderFactory.QueryBuilder reactivemongo$api$gridfs$GridFS$$chunkQueryBuilder$(GridFS $this) {
        return $this.reactivemongo$api$gridfs$GridFS$$chunkQueryBuilder();
    }

    default public QueryBuilderFactory.QueryBuilder reactivemongo$api$gridfs$GridFS$$chunkQueryBuilder() {
        Collection collection = this.reactivemongo$api$gridfs$GridFS$$chunkColl();
        FailoverStrategy failoverStrategy = this.db().failoverStrategy();
        ReadConcern readConcern = this.db().connection().options().readConcern();
        ReadPreference readPreference = this.db().defaultReadPreference();
        int n = this.QueryBuilder().$lessinit$greater$default$3();
        int n2 = this.QueryBuilder().$lessinit$greater$default$4();
        int n3 = this.QueryBuilder().$lessinit$greater$default$5();
        Option<Object> option = this.QueryBuilder().$lessinit$greater$default$8();
        Option<Object> option2 = this.QueryBuilder().$lessinit$greater$default$9();
        Option<Object> option3 = this.QueryBuilder().$lessinit$greater$default$10();
        Option<Object> option4 = this.QueryBuilder().$lessinit$greater$default$11();
        Option<Object> option5 = this.QueryBuilder().$lessinit$greater$default$12();
        Option<HintFactory.Hint> option6 = this.QueryBuilder().$lessinit$greater$default$13();
        boolean bl = this.QueryBuilder().$lessinit$greater$default$14();
        boolean bl2 = this.QueryBuilder().$lessinit$greater$default$15();
        Option<String> option7 = this.QueryBuilder().$lessinit$greater$default$16();
        Option<Object> option8 = this.QueryBuilder().$lessinit$greater$default$17();
        Option<Object> option9 = this.QueryBuilder().$lessinit$greater$default$18();
        boolean bl3 = this.QueryBuilder().$lessinit$greater$default$19();
        Option<Object> option10 = this.QueryBuilder().$lessinit$greater$default$20();
        boolean bl4 = this.QueryBuilder().$lessinit$greater$default$21();
        boolean bl5 = this.QueryBuilder().$lessinit$greater$default$22();
        Option<Collation> option11 = this.QueryBuilder().$lessinit$greater$default$23();
        return new QueryBuilderFactory.QueryBuilder(this, collection, failoverStrategy, n, n2, n3, readConcern, readPreference, option, option2, option3, option4, option5, option6, bl, bl2, option7, option8, option9, bl3, option10, bl4, bl5, option11);
    }

    public static Command.CommandWithPackRunner reactivemongo$api$gridfs$GridFS$$runner$(GridFS $this) {
        return $this.reactivemongo$api$gridfs$GridFS$$runner();
    }

    default public Command.CommandWithPackRunner<P> reactivemongo$api$gridfs$GridFS$$runner() {
        return Command$.MODULE$.run(this.pack(), this.db().failoverStrategy());
    }

    public static SerializationPack.Builder reactivemongo$api$gridfs$GridFS$$builder$(GridFS $this) {
        return $this.reactivemongo$api$gridfs$GridFS$$builder();
    }

    default public SerializationPack.Builder<P> reactivemongo$api$gridfs$GridFS$$builder() {
        return this.pack().newBuilder();
    }

    public static SerializationPack.Decoder reactivemongo$api$gridfs$GridFS$$decoder$(GridFS $this) {
        return $this.reactivemongo$api$gridfs$GridFS$$decoder();
    }

    default public SerializationPack.Decoder<P> reactivemongo$api$gridfs$GridFS$$decoder() {
        return this.pack().newDecoder();
    }

    public static GridFS$FileReader$ FileReader$(GridFS $this) {
        return $this.FileReader();
    }

    default public GridFS$FileReader$ FileReader() {
        return new GridFS$FileReader$(this);
    }

    public static Cursor find$(GridFS $this, Object selector, Object w, FileReader r, CursorProducer cp) {
        return $this.find(selector, w, r, cp);
    }

    default public <S, Id> Cursor find(S selector, Object w, FileReader<Id> r, CursorProducer<ReadFile<Id, Object>> cp) {
        Cursor cursor;
        try {
            Object q = this.pack().serialize(selector, w);
            QueryBuilderFactory.QueryBuilder query = this.reactivemongo$api$gridfs$GridFS$$fileQueryBuilder().filter(q);
            cursor = query.cursor(this.defaultReadPreference(), r.reader(), cp);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable cause = throwable3 = (Throwable)option.get();
                cursor = FailingCursor$.MODULE$.apply(this.db().connection(), cause, cp);
            }
            throw throwable;
        }
        return cursor;
    }

    public static Cursor find$(GridFS $this, Object selector, CursorProducer cp) {
        return $this.find(selector, cp);
    }

    default public Cursor find(Object selector, CursorProducer<ReadFile<Object, Object>> cp) {
        return this.find(selector, this.w$1(), this.r$1(), cp);
    }

    public static Cursor chunks$(GridFS $this, ReadFile file, ReadPreference readPreference, CursorProducer cp) {
        return $this.chunks(file, readPreference, cp);
    }

    default public Cursor chunks(ReadFile<Object, Object> file, ReadPreference readPreference, CursorProducer<byte[]> cp) {
        Object selectorOpts = this.chunkSelector(file);
        Object sortOpts = this.reactivemongo$api$gridfs$GridFS$$builder().document((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.reactivemongo$api$gridfs$GridFS$$builder().elementProducer("n", this.reactivemongo$api$gridfs$GridFS$$builder().int(1))})));
        QueryBuilderFactory.QueryBuilder query = this.reactivemongo$api$gridfs$GridFS$$chunkQueryBuilder().filter(selectorOpts).sort(sortOpts);
        return query.cursor(readPreference, this.reader$1(), cp);
    }

    public static ReadPreference chunks$default$2$(GridFS $this) {
        return $this.chunks$default$2();
    }

    default public ReadPreference chunks$default$2() {
        return this.defaultReadPreference();
    }

    public static Future readToOutputStream$(GridFS $this, ReadFile file, OutputStream out, ReadPreference readPreference, ExecutionContext ec) {
        return $this.readToOutputStream(file, out, readPreference, ec);
    }

    default public <Id> Future<BoxedUnit> readToOutputStream(ReadFile<Id, Object> file, OutputStream out, ReadPreference readPreference, ExecutionContext ec) {
        Object selectorOpts = this.chunkSelector(file);
        Object sortOpts = this.reactivemongo$api$gridfs$GridFS$$builder().document((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.reactivemongo$api$gridfs$GridFS$$builder().elementProducer("n", this.reactivemongo$api$gridfs$GridFS$$builder().int(1))})));
        QueryBuilderFactory.QueryBuilder query = this.reactivemongo$api$gridfs$GridFS$$chunkQueryBuilder().filter(selectorOpts).sort(sortOpts);
        Cursor cursor = query.cursor(readPreference, this.r$2(), CursorProducer$.MODULE$.defaultCursorProducer());
        return cursor.foldWhile((Function0 & Serializable)() -> {
            GridFS.readToOutputStream$$anonfun$1();
            return BoxedUnit.UNIT;
        }, cursor.foldWhile$default$2(), (Function2 & Serializable)(_$2, doc) -> this.pushChunk$1(out, doc), Cursor$.MODULE$.FailOnError(Cursor$.MODULE$.FailOnError$default$1()), ec);
    }

    public static ReadPreference readToOutputStream$default$3$(GridFS $this) {
        return $this.readToOutputStream$default$3();
    }

    default public <Id> ReadPreference readToOutputStream$default$3() {
        return this.defaultReadPreference();
    }

    public static Future writeFromInputStream$(GridFS $this, FileToSave file, InputStream input, int chunkSize, ExecutionContext ec) {
        return $this.writeFromInputStream(file, input, chunkSize, ec);
    }

    default public <Id> Future<ReadFile<Id, Object>> writeFromInputStream(FileToSave<Id, Object> file, InputStream input, int chunkSize, ExecutionContext ec) {
        LazyRef lazyRef = new LazyRef();
        LazyRef lazyRef2 = new LazyRef();
        byte[] buffer = new byte[chunkSize];
        public class Reactivemongo_api_gridfs_GridFS$Chunk$1
        implements Product,
        Serializable {
            private final FileToSave file$1;
            private final int chunkSize$1;
            private final ExecutionContext ec$2;
            private final LazyRef Chunk$lzy1$1;
            private final byte[] previous;
            private final int n;
            private final MessageDigest md;
            private final int length;
            private final /* synthetic */ GridFS $outer;

            public Reactivemongo_api_gridfs_GridFS$Chunk$1(FileToSave file$8, int chunkSize$7, ExecutionContext ec$14, LazyRef Chunk$lzy1$4, GridFS $outer, byte[] previous, int n, MessageDigest md, int length) {
                this.file$1 = file$8;
                this.chunkSize$1 = chunkSize$7;
                this.ec$2 = ec$14;
                this.Chunk$lzy1$1 = Chunk$lzy1$4;
                this.previous = previous;
                this.n = n;
                this.md = md;
                this.length = length;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.previous()));
                n = Statics.mix((int)n, (int)this.n());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.md()));
                n = Statics.mix((int)n, (int)this.length());
                return Statics.finalizeHash((int)n, (int)4);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Reactivemongo_api_gridfs_GridFS$Chunk$1)) return false;
                Reactivemongo_api_gridfs_GridFS$Chunk$1 var3_3 = (Reactivemongo_api_gridfs_GridFS$Chunk$1)object;
                if (this.n() != var3_3.n()) return false;
                if (this.length() != var3_3.length()) return false;
                if (this.previous() != var3_3.previous()) return false;
                MessageDigest messageDigest = this.md();
                MessageDigest messageDigest2 = var3_3.md();
                if (messageDigest == null) {
                    if (messageDigest2 != null) {
                        return false;
                    }
                } else if (!messageDigest.equals(messageDigest2)) return false;
                if (!var3_3.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Reactivemongo_api_gridfs_GridFS$Chunk$1;
            }

            public int productArity() {
                return 4;
            }

            public String productPrefix() {
                return "Chunk";
            }

            public Object productElement(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return this._1();
                    }
                    case 1: {
                        return BoxesRunTime.boxToInteger((int)this._2());
                    }
                    case 2: {
                        return this._3();
                    }
                    case 3: {
                        return BoxesRunTime.boxToInteger((int)this._4());
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return "previous";
                    }
                    case 1: {
                        return "n";
                    }
                    case 2: {
                        return "md";
                    }
                    case 3: {
                        return "length";
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public byte[] previous() {
                return this.previous;
            }

            public int n() {
                return this.n;
            }

            public MessageDigest md() {
                return this.md;
            }

            public int length() {
                return this.length;
            }

            public Future feed(byte[] chunk) {
                byte[] wholeChunk = (byte[])this.$outer.concat(this.previous(), chunk, ClassTag$.MODULE$.apply(Byte.TYPE));
                int normalizedChunkNumber = wholeChunk.length / this.chunkSize$1;
                package$.MODULE$.logger().debug((Function0<String>)((Function0 & Serializable)() -> GridFS.reactivemongo$api$gridfs$GridFS$Chunk$1$$_$feed$$anonfun$1(wholeChunk, normalizedChunkNumber)));
                IndexedSeq zipped = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), normalizedChunkNumber).map((Function1 & Serializable)i -> this.$anonfun$1(wholeChunk, BoxesRunTime.unboxToInt((Object)i)));
                byte[] left = Arrays.copyOfRange(wholeChunk, normalizedChunkNumber * this.chunkSize$1, wholeChunk.length);
                return Future$.MODULE$.traverse((IterableOnce)zipped, (Function1 & Serializable)ci -> this.writeChunk(this.n() + BoxesRunTime.unboxToInt((Object)ci._2()), (byte[])ci._1()), BuildFrom$.MODULE$.buildFromIterableOps(), this.ec$2).map((Function1 & Serializable)_$4 -> {
                    package$.MODULE$.logger().debug((Function0<String>)((Function0 & Serializable)GridFS::reactivemongo$api$gridfs$GridFS$Chunk$1$$_$feed$$anonfun$3$$anonfun$1));
                    Object object = Predef$.MODULE$.byteArrayOps(left);
                    return this.$outer.reactivemongo$api$gridfs$GridFS$$_$Chunk$2(this.file$1, this.chunkSize$1, this.ec$2, this.Chunk$lzy1$1).apply(ArrayOps$.MODULE$.isEmpty$extension(object) ? (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Byte.TYPE)) : left, this.n() + normalizedChunkNumber, GridFS.reactivemongo$api$gridfs$GridFS$$_$digestUpdate$1(this.md(), chunk), this.length() + chunk.length);
                }, this.ec$2);
            }

            public Future finish() {
                return GridFS.reactivemongo$api$gridfs$GridFS$$_$digestFinalize$1(this.ec$2, this.md()).map(GridFS::reactivemongo$api$gridfs$GridFS$Chunk$1$$_$finish$$anonfun$1, this.ec$2).flatMap((Function1 & Serializable)md5Hex -> this.$outer.finalizeFile(this.file$1, this.previous(), this.n(), this.chunkSize$1, this.length(), (Option<String>)md5Hex, this.ec$2), this.ec$2);
            }

            public Future writeChunk(int cn, byte[] bytes) {
                return this.$outer.writeChunk(this.file$1.id(), cn, bytes, this.ec$2);
            }

            public Reactivemongo_api_gridfs_GridFS$Chunk$1 copy(byte[] previous, int n, MessageDigest md, int length) {
                return new Reactivemongo_api_gridfs_GridFS$Chunk$1(this.file$1, this.chunkSize$1, this.ec$2, this.Chunk$lzy1$1, this.$outer, previous, n, md, length);
            }

            public byte[] copy$default$1() {
                return this.previous();
            }

            public int copy$default$2() {
                return this.n();
            }

            public MessageDigest copy$default$3() {
                return this.md();
            }

            public int copy$default$4() {
                return this.length();
            }

            public byte[] _1() {
                return this.previous();
            }

            public int _2() {
                return this.n();
            }

            public MessageDigest _3() {
                return this.md();
            }

            public int _4() {
                return this.length();
            }

            public final /* synthetic */ GridFS reactivemongo$api$gridfs$GridFS$_$Chunk$$$outer() {
                return this.$outer;
            }

            private final /* synthetic */ Tuple2 $anonfun$1(byte[] wholeChunk$2, int i) {
                byte[] byArray = (byte[])Predef$.MODULE$.ArrowAssoc((Object)Arrays.copyOfRange(wholeChunk$2, i * this.chunkSize$1, (i + 1) * this.chunkSize$1));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)byArray, (Object)BoxesRunTime.boxToInteger((int)i));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{reactivemongo$api$gridfs$GridFS$Chunk$1$$_$feed$$anonfun$1(byte[] int ), $anonfun$adapted$1(byte[] java.lang.Object ), feed$$anonfun$2(scala.Tuple2 ), feed$$anonfun$3(byte[] int byte[] scala.collection.immutable.IndexedSeq ), reactivemongo$api$gridfs$GridFS$Chunk$1$$_$finish$$anonfun$1(scala.Some ), finish$$anonfun$2(scala.Option ), reactivemongo$api$gridfs$GridFS$Chunk$1$$_$feed$$anonfun$3$$anonfun$1()}, serializedLambda);
            }
        }
        return GridFS.go$1(input, ec, buffer, this.reactivemongo$api$gridfs$GridFS$$_$Chunk$2(file, chunkSize, ec, lazyRef2).apply((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Byte.TYPE)), 0, GridFS.digestInit$1(lazyRef), 0)).flatMap((Function1 & Serializable)_$6 -> _$6.finish(), ec);
    }

    public static int writeFromInputStream$default$3$(GridFS $this) {
        return $this.writeFromInputStream$default$3();
    }

    default public int writeFromInputStream$default$3() {
        return 262144;
    }

    public static MongoWireVersion maxWireVersion$(GridFS $this) {
        return $this.maxWireVersion();
    }

    @Override
    default public MongoWireVersion maxWireVersion() {
        return this.db().connectionState().metadata().maxWireVersion();
    }

    public static Future update$(GridFS $this, Object id, Object metadata, ExecutionContext ec) {
        return $this.update(id, metadata, ec);
    }

    default public <Id> Future<WriteResult> update(Id id, Object metadata, ExecutionContext ec) {
        UpdateCommand.Update updateFileCmd = new UpdateCommand.Update(this, new UpdateCommand.UpdateElement((UpdateCommand)this, this.reactivemongo$api$gridfs$GridFS$$builder().document((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.reactivemongo$api$gridfs$GridFS$$builder().elementProducer("_id", id)}))), (Either<Object, Seq<Object>>)scala.package$.MODULE$.Left().apply(metadata), false, false, (Option<Collation>)None$.MODULE$, (Seq<Object>)((Seq)scala.package$.MODULE$.Seq().empty())), (Seq<UpdateCommand.UpdateElement>)((Seq)scala.package$.MODULE$.Seq().empty()), false, this.defaultWriteConcern(), false);
        return this.reactivemongo$api$gridfs$GridFS$$runner().apply(this.reactivemongo$api$gridfs$GridFS$$fileColl(), updateFileCmd, this.defaultReadPreference(), this.updateWriter(), this.updateReader(), ec);
    }

    public static Future remove$(GridFS $this, Object id, ExecutionContext ec) {
        return $this.remove(id, ec);
    }

    default public <Id> Future<WriteResult> remove(Id id, ExecutionContext ec) {
        DeleteCommand.Delete deleteChunkCmd = new DeleteCommand.Delete(this, (Seq<DeleteCommand.DeleteElement>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DeleteCommand.DeleteElement[]{new DeleteCommand.DeleteElement(this, this.reactivemongo$api$gridfs$GridFS$$builder().document((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.reactivemongo$api$gridfs$GridFS$$builder().elementProducer("files_id", id)}))), 0, (Option<Collation>)None$.MODULE$)}))), false, this.defaultWriteConcern());
        DeleteCommand.Delete deleteFileCmd = new DeleteCommand.Delete(this, (Seq<DeleteCommand.DeleteElement>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DeleteCommand.DeleteElement[]{new DeleteCommand.DeleteElement(this, this.reactivemongo$api$gridfs$GridFS$$builder().document((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.reactivemongo$api$gridfs$GridFS$$builder().elementProducer("_id", id)}))), 1, (Option<Collation>)None$.MODULE$)}))), false, this.defaultWriteConcern());
        return this.reactivemongo$api$gridfs$GridFS$$runner().apply(this.reactivemongo$api$gridfs$GridFS$$chunkColl(), deleteChunkCmd, this.defaultReadPreference(), this.deleteWriter(), this.resultReader(), ec).flatMap((Function1 & Serializable)x$1 -> {
            DefaultWriteResult defaultWriteResult = x$1;
            return this.reactivemongo$api$gridfs$GridFS$$runner().apply(this.reactivemongo$api$gridfs$GridFS$$fileColl(), deleteFileCmd, this.defaultReadPreference(), this.deleteWriter(), this.resultReader(), ec).map((Function1 & Serializable)r -> r, ec);
        }, ec);
    }

    public static Future ensureIndex$(GridFS $this, ExecutionContext ec) {
        return $this.ensureIndex(ec);
    }

    default public Future<Object> ensureIndex(ExecutionContext ec) {
        IndexesManager indexMngr = this.db().indexesManager((SerializationPack)this.pack(), ec);
        return this.create(this.reactivemongo$api$gridfs$GridFS$$chunkColl(), ec).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"files_id");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)IndexType$Ascending$.MODULE$);
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"n");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)IndexType$Ascending$.MODULE$);
            return indexMngr.onCollection(this.reactivemongo$api$gridfs$GridFS$$chunkColl().name()).ensure(Index$.MODULE$.apply(this.pack(), (Seq<Tuple2<String, IndexType>>)((Seq)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), (Option<String>)None$.MODULE$, true, false, false, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Collation>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, this.reactivemongo$api$gridfs$GridFS$$builder().document((Seq)scala.package$.MODULE$.Seq().empty()))).flatMap((Function1 & Serializable)c -> this.ensureIndex$$anonfun$1$$anonfun$1(ec, indexMngr, BoxesRunTime.unboxToBoolean((Object)c)), ec);
        }, ec);
    }

    public static Future exists$(GridFS $this, ExecutionContext ec) {
        return $this.exists(ec);
    }

    default public Future<Object> exists(ExecutionContext ec) {
        return this.stats(this.reactivemongo$api$gridfs$GridFS$$chunkColl(), ec).filter((Function1 & Serializable)c -> c.size() > 0.0 || c.nindexes() > 0, ec).flatMap((Function1 & Serializable)x$12 -> {
            CollectionStats collectionStats = x$12;
            return this.stats(this.reactivemongo$api$gridfs$GridFS$$fileColl(), ec).filter((Function1 & Serializable)f -> f.size() > 0.0 || f.nindexes() > 0, ec).map((Function1 & Serializable)x$1 -> {
                CollectionStats collectionStats = x$1;
                return true;
            }, ec);
        }, ec).recover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return BoxesRunTime.boxToBoolean((boolean)false);
            }
        }, ec);
    }

    public static FileToSave fileToSave$(GridFS $this, Option filename, Option contentType, Option uploadDate, Object metadata) {
        return $this.fileToSave((Option<String>)filename, (Option<String>)contentType, (Option<Object>)uploadDate, metadata);
    }

    default public FileToSave<Object, Object> fileToSave(Option<String> filename, Option<String> contentType, Option<Object> uploadDate, Object metadata) {
        Object object = this.reactivemongo$api$gridfs$GridFS$$builder().generateObjectId();
        return new FileToSave<Object, Object>(object, filename, contentType, uploadDate, metadata);
    }

    public static Option fileToSave$default$1$(GridFS $this) {
        return $this.fileToSave$default$1();
    }

    default public Option<String> fileToSave$default$1() {
        return None$.MODULE$;
    }

    public static Option fileToSave$default$2$(GridFS $this) {
        return $this.fileToSave$default$2();
    }

    default public Option<String> fileToSave$default$2() {
        return None$.MODULE$;
    }

    public static Option fileToSave$default$3$(GridFS $this) {
        return $this.fileToSave$default$3();
    }

    default public Option<Object> fileToSave$default$3() {
        return None$.MODULE$;
    }

    public static Object fileToSave$default$4$(GridFS $this) {
        return $this.fileToSave$default$4();
    }

    default public Object fileToSave$default$4() {
        return this.reactivemongo$api$gridfs$GridFS$$builder().document((Seq)scala.package$.MODULE$.Seq().empty());
    }

    public static FileToSave fileToSave$(GridFS $this, Option filename, Option contentType, Option uploadDate, Object metadata, Object id) {
        return $this.fileToSave((Option<String>)filename, (Option<String>)contentType, (Option<Object>)uploadDate, metadata, id);
    }

    default public <Id> FileToSave<Id, Object> fileToSave(Option<String> filename, Option<String> contentType, Option<Object> uploadDate, Object metadata, Id id) {
        return new FileToSave<Id, Object>(id, filename, contentType, uploadDate, metadata);
    }

    public static Future writeChunk$(GridFS $this, Object id, int n, byte[] bytes, ExecutionContext ec) {
        return $this.writeChunk(id, n, bytes, ec);
    }

    default public Future<WriteResult> writeChunk(Object id, int n, byte[] bytes, ExecutionContext ec) {
        package$.MODULE$.logger().debug((Function0<String>)((Function0 & Serializable)() -> GridFS.writeChunk$$anonfun$1(id, n)));
        Object chunkDoc = this.reactivemongo$api$gridfs$GridFS$$builder().document((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.reactivemongo$api$gridfs$GridFS$$builder().elementProducer("files_id", id), this.reactivemongo$api$gridfs$GridFS$$builder().elementProducer("n", this.reactivemongo$api$gridfs$GridFS$$builder().int(n)), this.reactivemongo$api$gridfs$GridFS$$builder().elementProducer("data", this.reactivemongo$api$gridfs$GridFS$$builder().binary(bytes))})));
        InsertCommand.Insert insertChunkCmd = new InsertCommand.Insert(this, chunkDoc, (Seq<Object>)((Seq)scala.package$.MODULE$.Seq().empty()), false, this.defaultWriteConcern(), false);
        return this.reactivemongo$api$gridfs$GridFS$$runner().apply(this.reactivemongo$api$gridfs$GridFS$$chunkColl(), insertChunkCmd, this.defaultReadPreference(), this.insertWriter(), this.resultReader(), ec);
    }

    public static Future finalizeFile$(GridFS $this, FileToSave file, byte[] previous, int n, int chunkSize, long length, Option md5Hex, ExecutionContext ec) {
        return $this.finalizeFile(file, previous, n, chunkSize, length, (Option<String>)md5Hex, ec);
    }

    default public <Id> Future<ReadFile<Id, Object>> finalizeFile(FileToSave<Id, Object> file, byte[] previous, int n, int chunkSize, long length, Option<String> md5Hex, ExecutionContext ec) {
        package$.MODULE$.logger().debug((Function0<String>)((Function0 & Serializable)() -> GridFS.finalizeFile$$anonfun$1(file, n)));
        long uploadDate = BoxesRunTime.unboxToLong((Object)file.uploadDate().getOrElse(GridFS::$anonfun$2));
        Builder fileProps = scala.package$.MODULE$.Seq().newBuilder();
        fileProps.$plus$plus$eq((IterableOnce)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.reactivemongo$api$gridfs$GridFS$$builder().elementProducer("_id", file.id()), this.reactivemongo$api$gridfs$GridFS$$builder().elementProducer("chunkSize", this.reactivemongo$api$gridfs$GridFS$$builder().int(chunkSize)), this.reactivemongo$api$gridfs$GridFS$$builder().elementProducer("length", this.reactivemongo$api$gridfs$GridFS$$builder().long(length)), this.reactivemongo$api$gridfs$GridFS$$builder().elementProducer("uploadDate", this.reactivemongo$api$gridfs$GridFS$$builder().dateTime(uploadDate)), this.reactivemongo$api$gridfs$GridFS$$builder().elementProducer("metadata", file.metadata())})));
        file.filename().foreach((Function1 & Serializable)fn -> (Builder)fileProps.$plus$eq(this.reactivemongo$api$gridfs$GridFS$$builder().elementProducer("filename", this.reactivemongo$api$gridfs$GridFS$$builder().string(fn))));
        file.contentType().foreach((Function1 & Serializable)ct -> (Builder)fileProps.$plus$eq(this.reactivemongo$api$gridfs$GridFS$$builder().elementProducer("contentType", this.reactivemongo$api$gridfs$GridFS$$builder().string(ct))));
        md5Hex.foreach((Function1 & Serializable)hex -> (Builder)fileProps.$plus$eq(this.reactivemongo$api$gridfs$GridFS$$builder().elementProducer("md5", this.reactivemongo$api$gridfs$GridFS$$builder().string(hex))));
        return this.writeChunk(file.id(), n, previous, ec).flatMap((Function1 & Serializable)_$7 -> {
            Object fileDoc = this.reactivemongo$api$gridfs$GridFS$$builder().document((Seq)fileProps.result());
            InsertCommand.Insert insertFileCmd = new InsertCommand.Insert(this, fileDoc, (Seq<Object>)((Seq)scala.package$.MODULE$.Seq().empty()), false, this.defaultWriteConcern(), false);
            return this.run$1(file, chunkSize, length, md5Hex, ec, insertFileCmd);
        }, ec);
    }

    private <Id> Object chunkSelector(ReadFile<Id, Object> file) {
        return this.reactivemongo$api$gridfs$GridFS$$builder().document((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.reactivemongo$api$gridfs$GridFS$$builder().elementProducer("files_id", file.id()), this.reactivemongo$api$gridfs$GridFS$$builder().elementProducer("n", this.reactivemongo$api$gridfs$GridFS$$builder().document((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.reactivemongo$api$gridfs$GridFS$$builder().elementProducer(StringOps$.MODULE$.format$extension("$gte", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), this.reactivemongo$api$gridfs$GridFS$$builder().int(0)), this.reactivemongo$api$gridfs$GridFS$$builder().elementProducer(StringOps$.MODULE$.format$extension("$lte", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), this.reactivemongo$api$gridfs$GridFS$$builder().long(file.length() / (long)file.chunkSize() + (long)(file.length() % (long)file.chunkSize() > 0L ? 1 : 0)))}))))})));
    }

    public static Object reactivemongo$api$gridfs$GridFS$$chunkReader$(GridFS $this) {
        return $this.reactivemongo$api$gridfs$GridFS$$chunkReader();
    }

    default public Object reactivemongo$api$gridfs$GridFS$$chunkReader() {
        SerializationPack.Decoder dec = this.pack().newDecoder();
        return this.pack().readerOpt((Function1 & Serializable)doc -> dec.binary(doc, "data"));
    }

    public static ReadPreference defaultReadPreference$(GridFS $this) {
        return $this.defaultReadPreference();
    }

    default public ReadPreference defaultReadPreference() {
        return this.db().defaultReadPreference();
    }

    private WriteConcern defaultWriteConcern() {
        return this.db().connection().options().writeConcern();
    }

    public static Create reactivemongo$api$gridfs$GridFS$$createCollCmd$(GridFS $this) {
        return $this.reactivemongo$api$gridfs$GridFS$$createCollCmd();
    }

    default public Create reactivemongo$api$gridfs$GridFS$$createCollCmd() {
        return Create$.MODULE$.apply(Create$.MODULE$.$lessinit$greater$default$1(), Create$.MODULE$.$lessinit$greater$default$2());
    }

    public static Object reactivemongo$api$gridfs$GridFS$$unitReader$(GridFS $this) {
        return $this.reactivemongo$api$gridfs$GridFS$$unitReader();
    }

    default public Object reactivemongo$api$gridfs$GridFS$$unitReader() {
        return CommandCodecs$.MODULE$.unitReader(this.pack());
    }

    public static Object reactivemongo$api$gridfs$GridFS$$createWriter$(GridFS $this) {
        return $this.reactivemongo$api$gridfs$GridFS$$createWriter();
    }

    default public Object reactivemongo$api$gridfs$GridFS$$createWriter() {
        return CreateCollection$.MODULE$.writer(this.pack());
    }

    private Future<BoxedUnit> create(Collection coll, ExecutionContext ec) {
        return this.reactivemongo$api$gridfs$GridFS$$runner().apply(coll, this.reactivemongo$api$gridfs$GridFS$$createCollCmd(), this.defaultReadPreference(), this.reactivemongo$api$gridfs$GridFS$$createWriter(), this.reactivemongo$api$gridfs$GridFS$$unitReader(), ec).recover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable != null) {
                    String string;
                    int n;
                    Option<Object> option = CommandException$Code$.MODULE$.unapply(throwable);
                    if (!option.isEmpty() && 48 == (n = BoxesRunTime.unboxToInt((Object)option.get()))) {
                        return true;
                    }
                    Option<String> option2 = CommandException$Message$.MODULE$.unapply(throwable);
                    if (!option2.isEmpty() && "collection already exists".equals(string = (String)option2.get())) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable != null) {
                    String string;
                    int n;
                    Option<Object> option = CommandException$Code$.MODULE$.unapply(throwable);
                    if (!option.isEmpty() && 48 == (n = BoxesRunTime.unboxToInt((Object)option.get()))) {
                        return BoxedUnit.UNIT;
                    }
                    Option<String> option2 = CommandException$Message$.MODULE$.unapply(throwable);
                    if (!option2.isEmpty() && "collection already exists".equals(string = (String)option2.get())) {
                        return BoxedUnit.UNIT;
                    }
                }
                return function1.apply((Object)x);
            }
        }, ec);
    }

    public static CollStats reactivemongo$api$gridfs$GridFS$$collStatsCmd$(GridFS $this) {
        return $this.reactivemongo$api$gridfs$GridFS$$collStatsCmd();
    }

    default public CollStats reactivemongo$api$gridfs$GridFS$$collStatsCmd() {
        return new CollStats(CollStats$.MODULE$.$lessinit$greater$default$1());
    }

    public static Object reactivemongo$api$gridfs$GridFS$$collStatsWriter$(GridFS $this) {
        return $this.reactivemongo$api$gridfs$GridFS$$collStatsWriter();
    }

    default public Object reactivemongo$api$gridfs$GridFS$$collStatsWriter() {
        return CollStats$.MODULE$.writer(this.pack());
    }

    public static Object reactivemongo$api$gridfs$GridFS$$collStatsReader$(GridFS $this) {
        return $this.reactivemongo$api$gridfs$GridFS$$collStatsReader();
    }

    default public Object reactivemongo$api$gridfs$GridFS$$collStatsReader() {
        return CollStats$.MODULE$.reader(this.pack());
    }

    private Future<CollectionStats> stats(Collection coll, ExecutionContext ec) {
        return this.reactivemongo$api$gridfs$GridFS$$runner().apply(coll, this.reactivemongo$api$gridfs$GridFS$$collStatsCmd(), this.defaultReadPreference(), this.reactivemongo$api$gridfs$GridFS$$collStatsWriter(), this.reactivemongo$api$gridfs$GridFS$$collStatsReader(), ec);
    }

    public static String toString$(GridFS $this) {
        return $this.toString();
    }

    default public String toString() {
        return new StringBuilder(34).append("GridFS(db = ").append(this.db().name()).append(", files = ").append(this.reactivemongo$api$gridfs$GridFS$$fileColl().name()).append(", chunks = ").append(this.reactivemongo$api$gridfs$GridFS$$chunkColl().name()).append(")").toString();
    }

    private Object w$1() {
        return this.pack().IdentityWriter();
    }

    private FileReader r$1() {
        return this.FileReader().default(this.pack().IsValue());
    }

    private Object reader$1() {
        return this.reactivemongo$api$gridfs$GridFS$$chunkReader();
    }

    private Object r$2() {
        return this.pack().IdentityReader();
    }

    private static String pushChunk$1$$anonfun$1(String errmsg$1) {
        return errmsg$1;
    }

    private Cursor.State pushChunk$1(OutputStream out$1, Object doc) {
        Option option = this.reactivemongo$api$gridfs$GridFS$$decoder().binary(doc, "data");
        if (option instanceof Some) {
            byte[] array = (byte[])((Some)option).value();
            out$1.write(array);
            return Cursor$Cont$.MODULE$.apply(BoxedUnit.UNIT);
        }
        String errmsg = new StringBuilder(54).append("not a chunk! failed assertion: data field is missing: ").append(this.pack().pretty(doc)).toString();
        package$.MODULE$.logger().error((Function0<String>)((Function0 & Serializable)() -> GridFS.pushChunk$1$$anonfun$1(errmsg)));
        return Cursor$Fail$.MODULE$.apply((Throwable)new GenericDriverException(errmsg, GenericDriverException$.MODULE$.$lessinit$greater$default$2()));
    }

    private static void readToOutputStream$$anonfun$1() {
    }

    private static MessageDigest digestInit$lzyINIT1$1(LazyRef digestInit$lzy1$1) {
        MessageDigest messageDigest;
        LazyRef lazyRef = digestInit$lzy1$1;
        synchronized (lazyRef) {
            messageDigest = (MessageDigest)(digestInit$lzy1$1.initialized() ? digestInit$lzy1$1.value() : digestInit$lzy1$1.initialize((Object)MessageDigest.getInstance("MD5")));
        }
        return messageDigest;
    }

    private static MessageDigest digestInit$1(LazyRef digestInit$lzy1$2) {
        return (MessageDigest)(digestInit$lzy1$2.initialized() ? digestInit$lzy1$2.value() : GridFS.digestInit$lzyINIT1$1(digestInit$lzy1$2));
    }

    public static MessageDigest reactivemongo$api$gridfs$GridFS$$_$digestUpdate$1(MessageDigest md, byte[] chunk) {
        md.update(chunk);
        return md;
    }

    private static byte[] digestFinalize$1$$anonfun$1(MessageDigest md$1) {
        return md$1.digest();
    }

    public static Future reactivemongo$api$gridfs$GridFS$$_$digestFinalize$1(ExecutionContext ec$1, MessageDigest md) {
        return Future$.MODULE$.apply(() -> GridFS.digestFinalize$1$$anonfun$1(md), ec$1).map((Function1 & Serializable)_$3 -> Some$.MODULE$.apply(_$3), ec$1);
    }

    public static String reactivemongo$api$gridfs$GridFS$Chunk$1$$_$feed$$anonfun$1(byte[] wholeChunk$1, int normalizedChunkNumber$1) {
        return new StringBuilder(23).append("wholeChunk size is ").append(wholeChunk$1.length).append(" => ").append(normalizedChunkNumber$1).toString();
    }

    public static String reactivemongo$api$gridfs$GridFS$Chunk$1$$_$feed$$anonfun$3$$anonfun$1() {
        return "all futures for the last given chunk are redeemed.";
    }

    public static /* synthetic */ Option reactivemongo$api$gridfs$GridFS$Chunk$1$$_$finish$$anonfun$1(Some _$5) {
        return _$5.map((Function1 & Serializable)bytes -> reactivemongo.util.package$.MODULE$.hex2Str((byte[])bytes));
    }

    private GridFS$Chunk$3$ Chunk$lzyINIT1$1(FileToSave file$2, int chunkSize$2, ExecutionContext ec$3, LazyRef Chunk$lzy1$2) {
        GridFS$Chunk$3$ gridFS$Chunk$3$;
        LazyRef lazyRef = Chunk$lzy1$2;
        synchronized (lazyRef) {
            gridFS$Chunk$3$ = (GridFS$Chunk$3$)(Chunk$lzy1$2.initialized() ? Chunk$lzy1$2.value() : Chunk$lzy1$2.initialize((Object)new GridFS$Chunk$3$(file$2, chunkSize$2, ec$3, Chunk$lzy1$2, this)));
        }
        return gridFS$Chunk$3$;
    }

    public static GridFS$Chunk$3$ reactivemongo$api$gridfs$GridFS$$_$Chunk$2$(GridFS $this, FileToSave file$3, int chunkSize$3, ExecutionContext ec$4, LazyRef Chunk$lzy1$3) {
        return $this.reactivemongo$api$gridfs$GridFS$$_$Chunk$2(file$3, chunkSize$3, ec$4, Chunk$lzy1$3);
    }

    default public GridFS$Chunk$3$ reactivemongo$api$gridfs$GridFS$$_$Chunk$2(FileToSave file$3, int chunkSize$3, ExecutionContext ec$4, LazyRef Chunk$lzy1$3) {
        return (GridFS$Chunk$3$)(Chunk$lzy1$3.initialized() ? Chunk$lzy1$3.value() : this.Chunk$lzyINIT1$1(file$3, chunkSize$3, ec$4, Chunk$lzy1$3));
    }

    private static int go$1$$anonfun$1(InputStream input$2, byte[] buffer$2) {
        return input$2.read(buffer$2);
    }

    private static String go$1$$anonfun$2$$anonfun$1(Chunk.1 previous$2) {
        return new StringBuilder(32).append("Processing new chunk from n=").append(previous$2.n()).append("...\n").toString();
    }

    private static /* synthetic */ Future go$1$$anonfun$2(InputStream input$3, ExecutionContext ec$6, byte[] buffer$3, Chunk.1 previous$1, int x$1) {
        int n = x$1;
        int n2 = n;
        if (n2 > 0) {
            package$.MODULE$.logger().debug((Function0<String>)((Function0 & Serializable)() -> GridFS.go$1$$anonfun$2$$anonfun$1(previous$1)));
            Object object = Predef$.MODULE$.byteArrayOps(buffer$3);
            return previous$1.feed((byte[])ArrayOps$.MODULE$.take$extension(object, n2)).flatMap((Function1 & Serializable)previous -> GridFS.go$1(input$3, ec$6, buffer$3, previous), ec$6);
        }
        return Future$.MODULE$.successful((Object)previous$1);
    }

    private static Future go$1(InputStream input$1, ExecutionContext ec$5, byte[] buffer$1, Chunk.1 previous) {
        return Future$.MODULE$.apply(() -> GridFS.go$1$$anonfun$1(input$1, buffer$1), ec$5).flatMap((Function1 & Serializable)x$1 -> {
            return GridFS.go$1$$anonfun$2(input$1, ec$5, buffer$1, previous, BoxesRunTime.unboxToInt((Object)x$1));
        }, ec$5);
    }

    private static /* synthetic */ boolean ensureIndex$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(boolean c$2, boolean f) {
        return c$2 && f;
    }

    private /* synthetic */ Future ensureIndex$$anonfun$1$$anonfun$1(ExecutionContext ec$9, IndexesManager indexMngr$2, boolean c) {
        return this.create(this.reactivemongo$api$gridfs$GridFS$$fileColl(), ec$9).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"filename");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)IndexType$Ascending$.MODULE$);
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"uploadDate");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)IndexType$Ascending$.MODULE$);
            return indexMngr$2.onCollection(this.reactivemongo$api$gridfs$GridFS$$fileColl().name()).ensure(Index$.MODULE$.apply(this.pack(), (Seq<Tuple2<String, IndexType>>)((Seq)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), (Option<String>)None$.MODULE$, false, false, false, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Collation>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, this.reactivemongo$api$gridfs$GridFS$$builder().document((Seq)scala.package$.MODULE$.Seq().empty()))).map((Function1 & Serializable)f -> GridFS.ensureIndex$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(c, BoxesRunTime.unboxToBoolean((Object)f)), ec$9);
        }, ec$9);
    }

    private static String writeChunk$$anonfun$1(Object id$2, int n$1) {
        return new StringBuilder(23).append("Writing chunk #").append(n$1).append(" @ file ").append(id$2).toString();
    }

    private static String finalizeFile$$anonfun$1(FileToSave file$4, int n$2) {
        return new StringBuilder(28).append("Writing last chunk #").append(n$2).append(" @ file ").append(file$4.id()).toString();
    }

    private static long $anonfun$2() {
        return System.nanoTime() / 1000000L;
    }

    private Future run$1(FileToSave file$6, int chunkSize$5, long length$2, Option md5Hex$2, ExecutionContext ec$13, InsertCommand.Insert insertFileCmd$1) {
        return this.reactivemongo$api$gridfs$GridFS$$runner().apply(this.reactivemongo$api$gridfs$GridFS$$fileColl(), insertFileCmd$1, this.defaultReadPreference(), this.insertWriter(), this.resultReader(), ec$13).map((Function1 & Serializable)_$8 -> new ReadFile(file$6.id(), file$6.filename(), file$6.uploadDate(), file$6.contentType(), length$2, chunkSize$5, (Option<String>)md5Hex$2, file$6.metadata()), ec$13);
    }

    public interface FileReader<Id> {
        public static void $init$(FileReader $this) {
        }

        public ReadFile<Id, Object> read(Object var1);

        public static Object reader$(FileReader $this) {
            return $this.reader();
        }

        default public Object reader() {
            return this.reactivemongo$api$gridfs$GridFS$FileReader$$$outer().pack().reader((Function1 & Serializable)_$1 -> this.read(_$1));
        }

        public /* synthetic */ GridFS reactivemongo$api$gridfs$GridFS$FileReader$$$outer();
    }
}

