/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api.commands;

import java.io.Serializable;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.codec.binary.Base64;
import reactivemongo.api.AuthenticationMode;
import reactivemongo.api.ScramAuthentication;
import reactivemongo.api.SerializationPack;
import reactivemongo.api.commands.Command;
import reactivemongo.api.commands.CommandKind$;
import reactivemongo.api.commands.CommandWithResult;
import reactivemongo.api.commands.ScramNegociation;
import reactivemongo.api.commands.ScramNegociation$;
import reactivemongo.api.commands.ScramStartNegociation$;
import reactivemongo.api.commands.SuccessfulAuthentication;
import reactivemongo.core.errors.CommandException;
import reactivemongo.core.errors.CommandException$;
import reactivemongo.util.package$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.control.NonFatal$;

public interface ScramStartNegociation<M extends AuthenticationMode & ScramAuthentication>
extends Command,
CommandWithResult<Either<SuccessfulAuthentication, byte[]>> {
    public static int ordinal(ScramStartNegociation<?> scramStartNegociation) {
        return ScramStartNegociation$.MODULE$.ordinal(scramStartNegociation);
    }

    public static <P extends SerializationPack, M extends AuthenticationMode & ScramAuthentication> Object reader(P p, M m) {
        return ScramStartNegociation$.MODULE$.reader(p, m);
    }

    public static <P extends SerializationPack, M extends AuthenticationMode & ScramAuthentication> Object writer(P p) {
        return ScramStartNegociation$.MODULE$.writer(p);
    }

    public static void $init$(ScramStartNegociation $this) {
        $this.reactivemongo$api$commands$ScramStartNegociation$_setter_$commandKind_$eq(CommandKind$.MODULE$.SaslContinue());
    }

    @Override
    public String commandKind();

    public void reactivemongo$api$commands$ScramStartNegociation$_setter_$commandKind_$eq(String var1);

    public M mechanism();

    public String user();

    public String password();

    public int conversationId();

    public byte[] payload();

    public String randomPrefix();

    public String startMessage();

    public byte[] digest(byte[] var1);

    public byte[] hmac(byte[] var1, byte[] var2);

    public SecretKeyFactory keyFactory();

    public Either<CommandException, String> credential();

    public int storedKeySize();

    public static Either data$(ScramStartNegociation $this) {
        return $this.data();
    }

    default public Either<CommandException, ScramNegociation> data() {
        String challenge = new String(this.payload(), "UTF-8");
        Map<String, String> response = ScramNegociation$.MODULE$.parsePayload(challenge);
        return response.get((Object)"r").filter((Function1 & Serializable)_$2 -> _$2.startsWith(this.randomPrefix())).toRight(this::data$$anonfun$2).right().flatMap((Function1 & Serializable)rand -> response.get((Object)"s").flatMap((Function1 & Serializable)s -> {
            Some some;
            try {
                some = Some$.MODULE$.apply((Object)Base64.decodeBase64((String)s));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3 = (Throwable)option.get();
                    some = None$.MODULE$;
                }
                throw throwable;
            }
            return some;
        }).toRight(this::data$$anonfun$3$$anonfun$2).right().flatMap((Function1 & Serializable)salt -> response.get((Object)"i").flatMap((Function1 & Serializable)i -> {
            Some some;
            try {
                some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(i))));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3 = (Throwable)option.get();
                    some = None$.MODULE$;
                }
                throw throwable;
            }
            return some;
        }).toRight(this::data$$anonfun$3$$anonfun$3$$anonfun$2).right().flatMap((Function1 & Serializable)iter -> this.data$$anonfun$3$$anonfun$3$$anonfun$3(challenge, (String)rand, (byte[])salt, BoxesRunTime.unboxToInt((Object)iter)))));
    }

    public static Either serverSignature$(ScramStartNegociation $this) {
        return $this.serverSignature();
    }

    default public Either<CommandException, byte[]> serverSignature() {
        return this.data().right().map((Function1 & Serializable)_$3 -> _$3.serverSignature());
    }

    private CommandException data$$anonfun$2() {
        return CommandException$.MODULE$.apply(new StringBuilder(22).append("invalid ").append(this.mechanism()).append(" random prefix").toString(), CommandException$.MODULE$.apply$default$2(), CommandException$.MODULE$.apply$default$3());
    }

    private CommandException data$$anonfun$3$$anonfun$2() {
        return CommandException$.MODULE$.apply(new StringBuilder(22).append("invalid ").append(this.mechanism()).append(" password salt").toString(), CommandException$.MODULE$.apply$default$2(), CommandException$.MODULE$.apply$default$3());
    }

    private CommandException data$$anonfun$3$$anonfun$3$$anonfun$2() {
        return CommandException$.MODULE$.apply(new StringBuilder(24).append("invalid ").append(this.mechanism()).append(" iteration count").toString(), CommandException$.MODULE$.apply$default$2(), CommandException$.MODULE$.apply$default$3());
    }

    private static /* synthetic */ byte $anonfun$1(byte a, byte b) {
        return (byte)(a ^ b);
    }

    private Either.RightProjection liftedTree1$1(String challenge$5, String rand$4, byte[] salt$3, int iter$2, String hashCredential$1) {
        Either.RightProjection rightProjection;
        try {
            String nonce = new StringBuilder(9).append("c=biws,r=").append(rand$4).toString();
            String digest = hashCredential$1;
            PBEKeySpec spec = new PBEKeySpec(digest.toCharArray(), salt$3, iter$2, this.storedKeySize());
            byte[] saltedPassword = this.keyFactory().generateSecret(spec).getEncoded();
            byte[] authMsg = new StringBuilder(2).append(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(this.startMessage()), 3)).append(",").append(challenge$5).append(",").append(nonce).toString().getBytes("UTF-8");
            byte[] clientKey = this.hmac(saltedPassword, ScramNegociation$.MODULE$.ClientKeySeed());
            byte[] clientSig = this.hmac(this.digest(clientKey), authMsg);
            byte[] clientProof = (byte[])((IterableOnceOps)package$.MODULE$.lazyZip((Iterable)Predef$.MODULE$.wrapByteArray(clientKey), (Iterable)Predef$.MODULE$.wrapByteArray(clientSig)).map((Function2 & Serializable)(a, b) -> ScramStartNegociation.$anonfun$1(BoxesRunTime.unboxToByte((Object)a), BoxesRunTime.unboxToByte((Object)b)), BuildFrom$.MODULE$.buildFromIterableOps())).toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
            String message = new StringBuilder(3).append(nonce).append(",p=").append(Base64.encodeBase64String((byte[])clientProof)).toString();
            byte[] serverKey = this.hmac(saltedPassword, ScramNegociation$.MODULE$.ServerKeySeed());
            rightProjection = scala.package$.MODULE$.Right().apply((Object)ScramNegociation$.MODULE$.apply(this.hmac(serverKey, authMsg), this.conversationId(), message)).right();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable err = throwable3 = (Throwable)option.get();
                rightProjection = scala.package$.MODULE$.Left().apply((Object)CommandException$.MODULE$.apply(new StringBuilder(21).append("fails to negociate ").append(this.mechanism()).append(": ").append(err.getMessage()).toString(), CommandException$.MODULE$.apply$default$2(), CommandException$.MODULE$.apply$default$3())).right();
            }
            throw throwable;
        }
        return rightProjection;
    }

    private /* synthetic */ Either data$$anonfun$3$$anonfun$3$$anonfun$3(String challenge$3, String rand$2, byte[] salt$1, int iter) {
        return this.credential().right().flatMap((Function1 & Serializable)hashCredential -> this.liftedTree1$1(challenge$3, rand$2, salt$1, iter, (String)hashCredential).map((Function1 & Serializable)nego -> nego));
    }
}

