/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.xbill.DNS.Record;
import reactivemongo.actors.actor.package$;
import reactivemongo.api.ConnectionState;
import reactivemongo.api.ConnectionState$;
import reactivemongo.api.DB;
import reactivemongo.api.FailoverStrategy;
import reactivemongo.api.MongoConnection$;
import reactivemongo.api.MongoConnection$IsAvailable$;
import reactivemongo.api.MongoConnection$IsPrimaryAvailable$;
import reactivemongo.api.MongoConnection$IsUnavailable$;
import reactivemongo.api.MongoConnection$ParseState$;
import reactivemongo.api.MongoConnection$URIBuilder$;
import reactivemongo.api.MongoConnectionOptions;
import reactivemongo.api.MongoConnectionOptions$;
import reactivemongo.api.ReadPreference;
import reactivemongo.api.Session;
import reactivemongo.api.commands.SuccessfulAuthentication;
import reactivemongo.core.actors.AuthRequest;
import reactivemongo.core.actors.AuthRequest$;
import reactivemongo.core.actors.Close;
import reactivemongo.core.actors.Close$;
import reactivemongo.core.actors.Closed$;
import reactivemongo.core.actors.Exceptions;
import reactivemongo.core.actors.Exceptions$InternalState$;
import reactivemongo.core.actors.ExpectingResponse;
import reactivemongo.core.actors.PickNode;
import reactivemongo.core.actors.PickNode$;
import reactivemongo.core.actors.PrimaryAvailable;
import reactivemongo.core.actors.PrimaryUnavailable$;
import reactivemongo.core.actors.RegisterMonitor$;
import reactivemongo.core.actors.SetAvailable;
import reactivemongo.core.actors.SetUnavailable$;
import reactivemongo.core.nodeset.Authenticate$;
import reactivemongo.core.protocol.ProtocolMetadata;
import reactivemongo.core.protocol.Response;
import reactivemongo.util.LazyLogger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.control.NoStackTrace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class MongoConnection {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MongoConnection.class.getDeclaredField("0bitmap$1"));
    public long 0bitmap$1;
    private final String supervisor;
    private final String name;
    private final ActorSystem actorSystem;
    private final ActorRef mongosystem;
    private final MongoConnectionOptions options;
    private Function0 history;
    private volatile boolean killed;
    public final MongoConnection$IsAvailable$ IsAvailable$lzy1;
    public final MongoConnection$IsPrimaryAvailable$ IsPrimaryAvailable$lzy1;
    public final MongoConnection$IsUnavailable$ IsUnavailable$lzy1;
    private boolean monitorInited;
    public ActorRef monitor$lzy1;
    private volatile Option _metadata;
    public final String reactivemongo$api$MongoConnection$$lnm;

    public static String DefaultHost() {
        return MongoConnection$.MODULE$.DefaultHost();
    }

    public static int DefaultPort() {
        return MongoConnection$.MODULE$.DefaultPort();
    }

    public static Future<URI<Option<String>>> fromString(String string, ExecutionContext executionContext) {
        return MongoConnection$.MODULE$.fromString(string, executionContext);
    }

    public static Future<URI<String>> fromStringWithDB(String string, ExecutionContext executionContext) {
        return MongoConnection$.MODULE$.fromStringWithDB(string, executionContext);
    }

    public static LazyLogger.LazyLogger logger() {
        return MongoConnection$.MODULE$.logger();
    }

    public static <T> Future<URI<T>> parse(String string, Function1<ExecutionContext, Function1<String, Future<Record[]>>> function1, Function1<String, Future<ListSet<String>>> function12, ExecutionContext executionContext, URIBuilder<T> uRIBuilder) {
        return MongoConnection$.MODULE$.parse(string, function1, function12, executionContext, uRIBuilder);
    }

    public MongoConnection(String supervisor, String name, ActorSystem actorSystem, ActorRef mongosystem, MongoConnectionOptions options) {
        this.supervisor = supervisor;
        this.name = name;
        this.actorSystem = actorSystem;
        this.mongosystem = mongosystem;
        this.options = options;
        this.IsAvailable$lzy1 = new MongoConnection$IsAvailable$(this);
        this.IsPrimaryAvailable$lzy1 = new MongoConnection$IsPrimaryAvailable$(this);
        this.IsUnavailable$lzy1 = new MongoConnection$IsUnavailable$(this);
        this.history = (Function0 & Serializable)() -> Exceptions$InternalState$.MODULE$.empty();
        this.killed = false;
        this.monitorInited = false;
        this._metadata = Option$.MODULE$.empty();
        this.reactivemongo$api$MongoConnection$$lnm = new StringBuilder(1).append(supervisor).append("/").append(name).toString();
    }

    public String supervisor() {
        return this.supervisor;
    }

    public String name() {
        return this.name;
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public ActorRef mongosystem() {
        return this.mongosystem;
    }

    public MongoConnectionOptions options() {
        return this.options;
    }

    public Future<DB> database(String name, FailoverStrategy failoverStrategy, ExecutionContext ec) {
        return this.waitIsAvailable(failoverStrategy, this.stackTrace(), ec).map((Function1 & Serializable)state -> new DB(name, this, (ConnectionState)state, failoverStrategy, (Option<Session>)None$.MODULE$), ec);
    }

    public FailoverStrategy database$default$2() {
        return this.options().failoverStrategy();
    }

    public Future<SuccessfulAuthentication> authenticate(String db, String user, String password, FailoverStrategy failoverStrategy, ExecutionContext ec) {
        return this.waitIsAvailable(failoverStrategy, this.stackTrace(), ec).flatMap((Function1 & Serializable)_$1 -> {
            AuthRequest req = new AuthRequest(Authenticate$.MODULE$.apply(db, user, (Option<String>)Option$.MODULE$.apply((Object)password)), AuthRequest$.MODULE$.$lessinit$greater$default$2());
            this.mongosystem().$bang((Object)req, this.mongosystem().$bang$default$2((Object)req));
            return req.future();
        }, ec);
    }

    public FailoverStrategy authenticate$default$4() {
        return this.options().failoverStrategy();
    }

    public Future<?> close(FiniteDuration timeout) {
        if (!this.monitorInited) {
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }
        return this.whenActive(() -> this.close$$anonfun$1(timeout));
    }

    public boolean active() {
        return !this.killed();
    }

    public String toString() {
        return new StringBuilder(20).append("MongoConnection { ").append(MongoConnectionOptions$.MODULE$.toStrings(this.options()).mkString(", ")).append(" }").toString();
    }

    public Function0<Exceptions.InternalState> history() {
        return this.history;
    }

    public void history_$eq(Function0<Exceptions.InternalState> x$1) {
        this.history = x$1;
    }

    public boolean killed() {
        return this.killed;
    }

    public void killed_$eq(boolean x$1) {
        this.killed = x$1;
    }

    private StackTraceElement[] stackTrace() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.drop$extension(object, 2));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.take$extension(object2, 2));
        return (StackTraceElement[])ArrayOps$.MODULE$.reverse$extension(object3);
    }

    public Future<ConnectionState> waitIsAvailable(FailoverStrategy failoverStrategy, StackTraceElement[] contextSTE, ExecutionContext ec) {
        this.reactivemongo$api$MongoConnection$$debug((Function0<String>)((Function0 & Serializable)MongoConnection::waitIsAvailable$$anonfun$1));
        double timeoutFactor = 1.25;
        FiniteDuration timeout = (FiniteDuration)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), failoverStrategy.retries()).foldLeft((Object)failoverStrategy.initialDelay(), (Function2 & Serializable)(d, i) -> ((FiniteDuration)d).$plus(failoverStrategy.initialDelay().$times((long)(timeoutFactor * failoverStrategy.delayFactor().apply$mcDI$sp(BoxesRunTime.unboxToInt((Object)i))))));
        return this.probe(timeout).recoverWith((PartialFunction)new Serializable(contextSTE){
            private final StackTraceElement[] contextSTE$1;
            {
                this.contextSTE$1 = contextSTE$2;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable error = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable error = throwable;
                    Object object = Predef$.MODULE$.refArrayOps((Object[])error.getStackTrace());
                    error.setStackTrace((StackTraceElement[])ArrayOps$.MODULE$.$plus$plus$colon$extension(object, (Object)this.contextSTE$1, ClassTag$.MODULE$.apply(StackTraceElement.class)));
                    return Future$.MODULE$.failed(error);
                }
                return function1.apply((Object)x);
            }
        }, ec);
    }

    private <T> Future<T> whenActive(Function0<Future<T>> f) {
        if (this.killed()) {
            this.reactivemongo$api$MongoConnection$$debug((Function0<String>)((Function0 & Serializable)MongoConnection::whenActive$$anonfun$1));
            return Future$.MODULE$.failed((Throwable)new Exceptions.ClosedException(this.supervisor(), this.name(), (Throwable)this.history().apply()));
        }
        return (Future)f.apply();
    }

    public Future<Response> sendExpectingResponse(ExpectingResponse expectingResponse) {
        return this.whenActive(() -> this.sendExpectingResponse$$anonfun$1(expectingResponse));
    }

    public Future<String> pickNode(ReadPreference readPreference) {
        return this.whenActive(() -> this.pickNode$$anonfun$1(readPreference));
    }

    public final MongoConnection$IsAvailable$ reactivemongo$api$MongoConnection$$IsAvailable() {
        return this.IsAvailable$lzy1;
    }

    public final MongoConnection$IsPrimaryAvailable$ reactivemongo$api$MongoConnection$$IsPrimaryAvailable() {
        return this.IsPrimaryAvailable$lzy1;
    }

    public final MongoConnection$IsUnavailable$ IsUnavailable() {
        return this.IsUnavailable$lzy1;
    }

    public Future<ConnectionState> probe(FiniteDuration timeout) {
        return this.whenActive(() -> this.probe$$anonfun$1(timeout));
    }

    public ActorRef monitor() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    ActorRef actorRef;
                    ActorRef ref = this.actorSystem().actorOf(package$.MODULE$.Props().apply(this::$anonfun$2, ClassTag$.MODULE$.apply(MonitorActor.class)), new StringBuilder(8).append("Monitor-").append(this.name()).toString());
                    this.monitorInited = true;
                    this.monitor$lzy1 = actorRef = ref;
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return actorRef;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.monitor$lzy1;
    }

    public Option<ProtocolMetadata> _metadata() {
        return this._metadata;
    }

    public void _metadata_$eq(Option<ProtocolMetadata> x$1) {
        this._metadata = x$1;
    }

    public void reactivemongo$api$MongoConnection$$debug(Function0<String> msg) {
        MongoConnection$.MODULE$.logger().debug((Function0<String>)((Function0 & Serializable)() -> this.debug$$anonfun$1(msg)));
    }

    private void warn(Function0<String> msg) {
        MongoConnection$.MODULE$.logger().warn((Function0<String>)((Function0 & Serializable)() -> this.warn$$anonfun$1(msg)));
    }

    public void reactivemongo$api$MongoConnection$$warn(Function0<String> msg, Exception cause) {
        MongoConnection$.MODULE$.logger().warn((Function0<String>)((Function0 & Serializable)() -> this.warn$$anonfun$2(msg)), (Function0<Throwable>)((Function0 & Serializable)() -> MongoConnection.warn$$anonfun$3(cause)));
    }

    private final Future close$$anonfun$1(FiniteDuration timeout$1) {
        return reactivemongo.actors.pattern.ask.package$.MODULE$.ask(this.monitor(), (Object)Close$.MODULE$.apply("MongoConnection.askClose", timeout$1), reactivemongo.actors.util.package$.MODULE$.Timeout().apply(timeout$1));
    }

    private static final String waitIsAvailable$$anonfun$1() {
        return "Waiting is available...";
    }

    private static final String whenActive$$anonfun$1() {
        return "Cannot send request when the connection is not active";
    }

    private final Future sendExpectingResponse$$anonfun$1(ExpectingResponse expectingResponse$1) {
        this.mongosystem().$bang((Object)expectingResponse$1, this.mongosystem().$bang$default$2((Object)expectingResponse$1));
        return expectingResponse$1.future();
    }

    private final Future pickNode$$anonfun$1(ReadPreference readPreference$30) {
        PickNode req = PickNode$.MODULE$.apply(readPreference$30);
        this.mongosystem().$bang((Object)req, this.mongosystem().$bang$default$2((Object)req));
        return req.future();
    }

    public final Future reactivemongo$api$MongoConnection$$_$unavailResult$1() {
        return Future$.MODULE$.failed((Throwable)(this.options().readPreference().slaveOk() ? new Exceptions.NodeSetNotReachableException(this.supervisor(), this.name(), (Throwable)this.history().apply()) : new Exceptions.PrimaryUnavailableException(this.supervisor(), this.name(), (Throwable)this.history().apply())));
    }

    private static final String probe$$anonfun$1$$anonfun$1$$anonfun$1(FiniteDuration timeout$4, Object check$3) {
        return new StringBuilder(53).append("Timeout after ").append(timeout$4).append(" while probing the connection monitor: ").append(check$3).toString();
    }

    private final Future probe$$anonfun$1$$anonfun$1(FiniteDuration timeout$3, Promise p$1, Object check$2) {
        if (p$1.future().isCompleted()) {
            return p$1.future();
        }
        this.warn((Function0<String>)((Function0 & Serializable)() -> MongoConnection.probe$$anonfun$1$$anonfun$1$$anonfun$1(timeout$3, check$2)));
        return this.reactivemongo$api$MongoConnection$$_$unavailResult$1();
    }

    private final Future probe$$anonfun$1(FiniteDuration timeout$2) {
        Promise p = Promise$.MODULE$.apply();
        Product check = this.options().readPreference().slaveOk() ? this.reactivemongo$api$MongoConnection$$IsAvailable().apply((Promise<ConnectionState>)p) : this.reactivemongo$api$MongoConnection$$IsPrimaryAvailable().apply((Promise<ConnectionState>)p);
        this.monitor().$bang((Object)check, this.monitor().$bang$default$2((Object)check));
        return Future$.MODULE$.firstCompletedOf((IterableOnce)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Future[]{p.future().recoverWith((PartialFunction)new Serializable(check, this){
            private final Object check$1;
            private final /* synthetic */ MongoConnection $outer;
            {
                this.check$1 = check$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof Exception) {
                    Exception cause = (Exception)throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof Exception) {
                    Exception cause = (Exception)throwable;
                    this.$outer.reactivemongo$api$MongoConnection$$warn((Function0<String>)((Function0 & Serializable)this::applyOrElse$$anonfun$1), cause);
                    return this.$outer.reactivemongo$api$MongoConnection$$_$unavailResult$1();
                }
                return function1.apply((Object)x);
            }

            private final String applyOrElse$$anonfun$1() {
                return new StringBuilder(39).append("Fails to probe the connection monitor: ").append(this.check$1).toString();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1()}, serializedLambda);
            }
        }, (ExecutionContext)this.actorSystem().dispatcher()), reactivemongo.actors.pattern.ask.package$.MODULE$.after(timeout$2, this.actorSystem().scheduler(), () -> this.probe$$anonfun$1$$anonfun$1(timeout$2, p, check), (ExecutionContext)this.actorSystem().dispatcher())})), (ExecutionContext)this.actorSystem().dispatcher());
    }

    private final MonitorActor $anonfun$2() {
        return new MonitorActor();
    }

    public static final String reactivemongo$api$MongoConnection$$anon$3$$_$applyOrElse$$anonfun$2(PrimaryAvailable available$1) {
        return new StringBuilder(24).append("A primary is available: ").append(available$1.metadata()).toString();
    }

    public static final String reactivemongo$api$MongoConnection$$anon$3$$_$applyOrElse$$anonfun$3() {
        return "There is no primary available";
    }

    public static final String reactivemongo$api$MongoConnection$$anon$3$$_$applyOrElse$$anonfun$4(SetAvailable available$2) {
        return new StringBuilder(21).append("A node is available: ").append(available$2.metadata()).toString();
    }

    public static final String reactivemongo$api$MongoConnection$$anon$3$$_$applyOrElse$$anonfun$5() {
        return "No node seems to be available";
    }

    public static final String reactivemongo$api$MongoConnection$$anon$3$$_$applyOrElse$$anonfun$6(String src$1) {
        return new StringBuilder(36).append("Monitor received Close request from ").append(src$1).toString();
    }

    public static final String reactivemongo$api$MongoConnection$$anon$3$$_$applyOrElse$$anonfun$7() {
        return "Monitor is now closed";
    }

    public static final /* synthetic */ boolean reactivemongo$api$MongoConnection$$anon$3$$_$applyOrElse$$anonfun$8(ActorRef _$2) {
        return true;
    }

    public static final String reactivemongo$api$MongoConnection$MonitorActor$$_$postStop$$anonfun$1() {
        return "Monitor is stopped";
    }

    private final String debug$$anonfun$1(Function0 msg$1) {
        return new StringBuilder(3).append("[").append(this.reactivemongo$api$MongoConnection$$lnm).append("] ").append(msg$1.apply()).toString();
    }

    private final String warn$$anonfun$1(Function0 msg$2) {
        return new StringBuilder(3).append("[").append(this.reactivemongo$api$MongoConnection$$lnm).append("] ").append(msg$2.apply()).toString();
    }

    private final String warn$$anonfun$2(Function0 msg$3) {
        return new StringBuilder(3).append("[").append(this.reactivemongo$api$MongoConnection$$lnm).append("] ").append(msg$3.apply()).toString();
    }

    private static final Throwable warn$$anonfun$3(Exception cause$1) {
        return cause$1;
    }

    public class IsAvailable
    implements Product,
    Serializable {
        private final Promise result;
        private final String toString;
        private final /* synthetic */ MongoConnection $outer;

        public IsAvailable(MongoConnection $outer, Promise<ConnectionState> result) {
            this.result = result;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.toString = new StringBuilder(13).append("IsAvailable#").append(System.identityHashCode(this)).append("?").toString();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof IsAvailable)) return false;
            if (((IsAvailable)object).reactivemongo$api$MongoConnection$IsAvailable$$$outer() != this.$outer) return false;
            IsAvailable isAvailable = (IsAvailable)object;
            Promise<ConnectionState> promise = this.result();
            Promise<ConnectionState> promise2 = isAvailable.result();
            if (promise == null) {
                if (promise2 != null) {
                    return false;
                }
            } else if (!promise.equals(promise2)) return false;
            if (!isAvailable.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof IsAvailable;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "IsAvailable";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "result";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Promise<ConnectionState> result() {
            return this.result;
        }

        public String toString() {
            return this.toString;
        }

        public IsAvailable copy(Promise<ConnectionState> result) {
            return new IsAvailable(this.$outer, result);
        }

        public Promise<ConnectionState> copy$default$1() {
            return this.result();
        }

        public Promise<ConnectionState> _1() {
            return this.result();
        }

        public final /* synthetic */ MongoConnection reactivemongo$api$MongoConnection$IsAvailable$$$outer() {
            return this.$outer;
        }
    }

    public class IsPrimaryAvailable
    implements Product,
    Serializable {
        private final Promise result;
        private final String toString;
        private final /* synthetic */ MongoConnection $outer;

        public IsPrimaryAvailable(MongoConnection $outer, Promise<ConnectionState> result) {
            this.result = result;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.toString = new StringBuilder(20).append("IsPrimaryAvailable#").append(System.identityHashCode(this)).append("?").toString();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof IsPrimaryAvailable)) return false;
            if (((IsPrimaryAvailable)object).reactivemongo$api$MongoConnection$IsPrimaryAvailable$$$outer() != this.$outer) return false;
            IsPrimaryAvailable isPrimaryAvailable = (IsPrimaryAvailable)object;
            Promise<ConnectionState> promise = this.result();
            Promise<ConnectionState> promise2 = isPrimaryAvailable.result();
            if (promise == null) {
                if (promise2 != null) {
                    return false;
                }
            } else if (!promise.equals(promise2)) return false;
            if (!isPrimaryAvailable.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof IsPrimaryAvailable;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "IsPrimaryAvailable";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "result";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Promise<ConnectionState> result() {
            return this.result;
        }

        public String toString() {
            return this.toString;
        }

        public IsPrimaryAvailable copy(Promise<ConnectionState> result) {
            return new IsPrimaryAvailable(this.$outer, result);
        }

        public Promise<ConnectionState> copy$default$1() {
            return this.result();
        }

        public Promise<ConnectionState> _1() {
            return this.result();
        }

        public final /* synthetic */ MongoConnection reactivemongo$api$MongoConnection$IsPrimaryAvailable$$$outer() {
            return this.$outer;
        }
    }

    public class IsUnavailable
    implements Product,
    Serializable {
        private final Promise result;
        private final /* synthetic */ MongoConnection $outer;

        public IsUnavailable(MongoConnection $outer, Promise<BoxedUnit> result) {
            this.result = result;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof IsUnavailable)) return false;
            if (((IsUnavailable)object).reactivemongo$api$MongoConnection$IsUnavailable$$$outer() != this.$outer) return false;
            IsUnavailable isUnavailable = (IsUnavailable)object;
            Promise<BoxedUnit> promise = this.result();
            Promise<BoxedUnit> promise2 = isUnavailable.result();
            if (promise == null) {
                if (promise2 != null) {
                    return false;
                }
            } else if (!promise.equals(promise2)) return false;
            if (!isUnavailable.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof IsUnavailable;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "IsUnavailable";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "result";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Promise<BoxedUnit> result() {
            return this.result;
        }

        public IsUnavailable copy(Promise<BoxedUnit> result) {
            return new IsUnavailable(this.$outer, result);
        }

        public Promise<BoxedUnit> copy$default$1() {
            return this.result();
        }

        public Promise<BoxedUnit> _1() {
            return this.result();
        }

        public final /* synthetic */ MongoConnection reactivemongo$api$MongoConnection$IsUnavailable$$$outer() {
            return this.$outer;
        }
    }

    public class MonitorActor
    implements Actor {
        private ActorContext context;
        private ActorRef self;
        public Promise<ConnectionState> reactivemongo$api$MongoConnection$MonitorActor$$setAvailable;
        public Promise<ConnectionState> reactivemongo$api$MongoConnection$MonitorActor$$primaryAvailable;
        public final Queue<ActorRef> reactivemongo$api$MongoConnection$MonitorActor$$waitingForClose;
        public Promise<BoxedUnit> reactivemongo$api$MongoConnection$MonitorActor$$setUnavailable;
        private final PartialFunction receive;

        public MonitorActor() {
            if (MongoConnection.this == null) {
                throw new NullPointerException();
            }
            Actor.$init$((Actor)this);
            MongoConnection.this.mongosystem().$bang((Object)RegisterMonitor$.MODULE$, this.self());
            this.reactivemongo$api$MongoConnection$MonitorActor$$setAvailable = Promise$.MODULE$.apply();
            this.reactivemongo$api$MongoConnection$MonitorActor$$primaryAvailable = Promise$.MODULE$.apply();
            this.reactivemongo$api$MongoConnection$MonitorActor$$waitingForClose = (Queue)Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ActorRef[0]));
            this.reactivemongo$api$MongoConnection$MonitorActor$$setUnavailable = Promise$.MODULE$.apply();
            this.receive = new Serializable(this){
                private final /* synthetic */ MonitorActor $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Object x) {
                    Close close;
                    Option<String> option;
                    Object object = x;
                    if (object instanceof PrimaryAvailable) {
                        PrimaryAvailable available = (PrimaryAvailable)object;
                        return true;
                    }
                    if (PrimaryUnavailable$.MODULE$.equals(object)) {
                        return true;
                    }
                    if (object instanceof SetAvailable) {
                        SetAvailable available = (SetAvailable)object;
                        return true;
                    }
                    if (SetUnavailable$.MODULE$.equals(object)) {
                        return true;
                    }
                    if (object instanceof IsAvailable && ((IsAvailable)object).reactivemongo$api$MongoConnection$IsAvailable$$$outer() == this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer()) {
                        Promise<ConnectionState> promise;
                        IsAvailable isAvailable = this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer().reactivemongo$api$MongoConnection$$IsAvailable().unapply((IsAvailable)object);
                        Promise<ConnectionState> result = promise = isAvailable._1();
                        return true;
                    }
                    if (object instanceof IsPrimaryAvailable && ((IsPrimaryAvailable)object).reactivemongo$api$MongoConnection$IsPrimaryAvailable$$$outer() == this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer()) {
                        Promise<ConnectionState> promise;
                        IsPrimaryAvailable isPrimaryAvailable = this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer().reactivemongo$api$MongoConnection$$IsPrimaryAvailable().unapply((IsPrimaryAvailable)object);
                        Promise<ConnectionState> result = promise = isPrimaryAvailable._1();
                        return true;
                    }
                    if (object instanceof IsUnavailable && ((IsUnavailable)object).reactivemongo$api$MongoConnection$IsUnavailable$$$outer() == this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer()) {
                        Promise<BoxedUnit> promise;
                        IsUnavailable isUnavailable = this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer().IsUnavailable().unapply((IsUnavailable)object);
                        Promise<BoxedUnit> result = promise = isUnavailable._1();
                        return true;
                    }
                    if (object instanceof Close && !(option = Close$.MODULE$.unapply(close = (Close)object)).isEmpty()) {
                        String string;
                        String src = string = (String)option.get();
                        Close close2 = close;
                        return true;
                    }
                    return Closed$.MODULE$.equals(object);
                }

                public final Object applyOrElse(Object x, Function1 function1) {
                    Close close;
                    Option<String> option;
                    Object object = x;
                    if (object instanceof PrimaryAvailable) {
                        PrimaryAvailable available = (PrimaryAvailable)object;
                        this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer().reactivemongo$api$MongoConnection$$debug((Function0<String>)((Function0 & Serializable)() -> MongoConnection.reactivemongo$api$MongoConnection$$anon$3$$_$applyOrElse$$anonfun$2(available)));
                        this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer()._metadata_$eq((Option<ProtocolMetadata>)Some$.MODULE$.apply((Object)available.metadata()));
                        ConnectionState state = ConnectionState$.MODULE$.apply(available.metadata(), available.setName(), available.isMongos());
                        if (!this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$primaryAvailable.trySuccess((Object)state)) {
                            this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$primaryAvailable = Promise$.MODULE$.successful((Object)state);
                            return BoxedUnit.UNIT;
                        }
                        return BoxedUnit.UNIT;
                    }
                    if (PrimaryUnavailable$.MODULE$.equals(object)) {
                        this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer().reactivemongo$api$MongoConnection$$debug((Function0<String>)((Function0 & Serializable)MongoConnection::reactivemongo$api$MongoConnection$$anon$3$$_$applyOrElse$$anonfun$3));
                        if (!this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$setUnavailable.trySuccess((Object)BoxedUnit.UNIT)) {
                            this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$setUnavailable = Promise$.MODULE$.successful((Object)BoxedUnit.UNIT);
                        }
                        if (this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$primaryAvailable.isCompleted()) {
                            this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$primaryAvailable = Promise$.MODULE$.apply();
                            return BoxedUnit.UNIT;
                        }
                        return BoxedUnit.UNIT;
                    }
                    if (object instanceof SetAvailable) {
                        SetAvailable available = (SetAvailable)object;
                        this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer().reactivemongo$api$MongoConnection$$debug((Function0<String>)((Function0 & Serializable)() -> MongoConnection.reactivemongo$api$MongoConnection$$anon$3$$_$applyOrElse$$anonfun$4(available)));
                        this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer()._metadata_$eq((Option<ProtocolMetadata>)Some$.MODULE$.apply((Object)available.metadata()));
                        ConnectionState state = ConnectionState$.MODULE$.apply(available.metadata(), available.setName(), available.isMongos());
                        if (!this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$setAvailable.trySuccess((Object)state)) {
                            this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$setAvailable = Promise$.MODULE$.successful((Object)state);
                        }
                        if (this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$setUnavailable.isCompleted()) {
                            this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$setUnavailable = Promise$.MODULE$.apply();
                            return BoxedUnit.UNIT;
                        }
                        return BoxedUnit.UNIT;
                    }
                    if (SetUnavailable$.MODULE$.equals(object)) {
                        this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer().reactivemongo$api$MongoConnection$$debug((Function0<String>)((Function0 & Serializable)MongoConnection::reactivemongo$api$MongoConnection$$anon$3$$_$applyOrElse$$anonfun$5));
                        if (this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$setAvailable.isCompleted()) {
                            this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$setAvailable = Promise$.MODULE$.apply();
                            return BoxedUnit.UNIT;
                        }
                        return BoxedUnit.UNIT;
                    }
                    if (object instanceof IsAvailable && ((IsAvailable)object).reactivemongo$api$MongoConnection$IsAvailable$$$outer() == this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer()) {
                        Promise<ConnectionState> promise;
                        IsAvailable isAvailable = this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer().reactivemongo$api$MongoConnection$$IsAvailable().unapply((IsAvailable)object);
                        Promise<ConnectionState> result = promise = isAvailable._1();
                        result.completeWith(this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$setAvailable.future());
                        return BoxedUnit.UNIT;
                    }
                    if (object instanceof IsPrimaryAvailable && ((IsPrimaryAvailable)object).reactivemongo$api$MongoConnection$IsPrimaryAvailable$$$outer() == this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer()) {
                        Promise<ConnectionState> promise;
                        IsPrimaryAvailable isPrimaryAvailable = this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer().reactivemongo$api$MongoConnection$$IsPrimaryAvailable().unapply((IsPrimaryAvailable)object);
                        Promise<ConnectionState> result = promise = isPrimaryAvailable._1();
                        result.completeWith(this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$primaryAvailable.future());
                        return BoxedUnit.UNIT;
                    }
                    if (object instanceof IsUnavailable && ((IsUnavailable)object).reactivemongo$api$MongoConnection$IsUnavailable$$$outer() == this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer()) {
                        Promise<BoxedUnit> promise;
                        IsUnavailable isUnavailable = this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer().IsUnavailable().unapply((IsUnavailable)object);
                        Promise<BoxedUnit> result = promise = isUnavailable._1();
                        result.completeWith(this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$setUnavailable.future());
                        return BoxedUnit.UNIT;
                    }
                    if (object instanceof Close && !(option = Close$.MODULE$.unapply(close = (Close)object)).isEmpty()) {
                        String string;
                        String src = string = (String)option.get();
                        Close close2 = close;
                        this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer().reactivemongo$api$MongoConnection$$debug((Function0<String>)((Function0 & Serializable)() -> MongoConnection.reactivemongo$api$MongoConnection$$anon$3$$_$applyOrElse$$anonfun$6(src)));
                        this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer().killed_$eq(true);
                        this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$primaryAvailable = Promise$.MODULE$.failed((Throwable)new Exception(new StringBuilder(24).append("[").append(this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer().reactivemongo$api$MongoConnection$$lnm).append("] Closing connection...").toString()));
                        this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$setAvailable = Promise$.MODULE$.failed((Throwable)new Exception(new StringBuilder(24).append("[").append(this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer().reactivemongo$api$MongoConnection$$lnm).append("] Closing connection...").toString()));
                        this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer().mongosystem().$bang((Object)Close$.MODULE$.apply("MonitorActor#Close", close2.timeout()), this.$outer.self());
                        this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$waitingForClose.$plus$eq((Object)this.$outer.sender());
                        return BoxedUnit.UNIT;
                    }
                    if (Closed$.MODULE$.equals(object)) {
                        this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$$outer().reactivemongo$api$MongoConnection$$debug((Function0<String>)((Function0 & Serializable)MongoConnection::reactivemongo$api$MongoConnection$$anon$3$$_$applyOrElse$$anonfun$7));
                        this.$outer.reactivemongo$api$MongoConnection$MonitorActor$$waitingForClose.dequeueAll(MongoConnection::reactivemongo$api$MongoConnection$$anon$3$$_$applyOrElse$$anonfun$8).foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.$bang((Object)Closed$.MODULE$, this.$outer.self()));
                        this.$outer.context().stop(this.$outer.self());
                        return BoxedUnit.UNIT;
                    }
                    return function1.apply(x);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{reactivemongo$api$MongoConnection$$anon$3$$_$applyOrElse$$anonfun$2(reactivemongo.core.actors.PrimaryAvailable ), reactivemongo$api$MongoConnection$$anon$3$$_$applyOrElse$$anonfun$3(), reactivemongo$api$MongoConnection$$anon$3$$_$applyOrElse$$anonfun$4(reactivemongo.core.actors.SetAvailable ), reactivemongo$api$MongoConnection$$anon$3$$_$applyOrElse$$anonfun$5(), reactivemongo$api$MongoConnection$$anon$3$$_$applyOrElse$$anonfun$6(java.lang.String ), reactivemongo$api$MongoConnection$$anon$3$$_$applyOrElse$$anonfun$7(), reactivemongo$api$MongoConnection$$anon$3$$_$applyOrElse$$anonfun$8(akka.actor.ActorRef ), applyOrElse$$anonfun$9(akka.actor.ActorRef )}, serializedLambda);
                }
            };
            Statics.releaseFence();
        }

        public ActorContext context() {
            return this.context;
        }

        public final ActorRef self() {
            return this.self;
        }

        public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
            this.context = x$0;
        }

        public void akka$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
            this.self = x$0;
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return this.receive;
        }

        public void postStop() {
            MongoConnection.this.reactivemongo$api$MongoConnection$$debug((Function0<String>)((Function0 & Serializable)MongoConnection::reactivemongo$api$MongoConnection$MonitorActor$$_$postStop$$anonfun$1));
        }

        public final /* synthetic */ MongoConnection reactivemongo$api$MongoConnection$MonitorActor$$$outer() {
            return MongoConnection.this;
        }
    }

    public static class ParseState
    implements Product,
    Serializable {
        private final MongoConnectionOptions options;
        private final Map rejected;

        public static ParseState apply(MongoConnectionOptions mongoConnectionOptions, Map<String, String> map) {
            return MongoConnection$ParseState$.MODULE$.apply(mongoConnectionOptions, map);
        }

        public static ParseState fromProduct(Product product) {
            return MongoConnection$ParseState$.MODULE$.fromProduct(product);
        }

        public static ParseState unapply(ParseState parseState) {
            return MongoConnection$ParseState$.MODULE$.unapply(parseState);
        }

        public static Map<String, String> $lessinit$greater$default$2() {
            return MongoConnection$ParseState$.MODULE$.$lessinit$greater$default$2();
        }

        public ParseState(MongoConnectionOptions options, Map<String, String> rejected) {
            this.options = options;
            this.rejected = rejected;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ParseState)) return false;
            ParseState parseState = (ParseState)object;
            MongoConnectionOptions mongoConnectionOptions = this.options();
            MongoConnectionOptions mongoConnectionOptions2 = parseState.options();
            if (mongoConnectionOptions == null) {
                if (mongoConnectionOptions2 != null) {
                    return false;
                }
            } else if (!((Object)mongoConnectionOptions).equals(mongoConnectionOptions2)) return false;
            Map<String, String> map = this.rejected();
            Map<String, String> map2 = parseState.rejected();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!parseState.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ParseState;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ParseState";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "options";
            }
            if (1 == n2) {
                return "rejected";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public MongoConnectionOptions options() {
            return this.options;
        }

        public Map<String, String> rejected() {
            return this.rejected;
        }

        public ParseState updateOption(Function1<MongoConnectionOptions, MongoConnectionOptions> f) {
            return this.copy((MongoConnectionOptions)f.apply((Object)this.options()), this.copy$default$2());
        }

        public ParseState reject(Tuple2<String, String> setting) {
            Map map = (Map)this.rejected().$plus(setting);
            MongoConnectionOptions mongoConnectionOptions = this.copy$default$1();
            return this.copy(mongoConnectionOptions, (Map<String, String>)map);
        }

        public ParseState copy(MongoConnectionOptions options, Map<String, String> rejected) {
            return new ParseState(options, rejected);
        }

        public MongoConnectionOptions copy$default$1() {
            return this.options();
        }

        public Map<String, String> copy$default$2() {
            return this.rejected();
        }

        public MongoConnectionOptions _1() {
            return this.options();
        }

        public Map<String, String> _2() {
            return this.rejected();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class URI<T> {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(URI.class.getDeclaredField("0bitmap$2"));
        public long 0bitmap$2;
        private final ListSet hosts;
        private final MongoConnectionOptions options;
        private final List ignoredOptions;
        private final Object db;
        public Tuple4 tupled$lzy1;

        public URI(ListSet<Tuple2<String, Object>> hosts, MongoConnectionOptions options, List<String> ignoredOptions, T db) {
            this.hosts = hosts;
            this.options = options;
            this.ignoredOptions = ignoredOptions;
            this.db = db;
        }

        public ListSet<Tuple2<String, Object>> hosts() {
            return this.hosts;
        }

        public MongoConnectionOptions options() {
            return this.options;
        }

        public List<String> ignoredOptions() {
            return this.ignoredOptions;
        }

        public T db() {
            return (T)this.db;
        }

        public boolean equals(Object that) {
            Object object = that;
            if (object instanceof URI) {
                URI other = (URI)object;
                Tuple4<List<Tuple2<String, Object>>, MongoConnectionOptions, List<String>, T> tuple4 = other.tupled();
                Tuple4<List<Tuple2<String, Object>>, MongoConnectionOptions, List<String>, T> tuple42 = this.tupled();
                return !(tuple4 != null ? !tuple4.equals(tuple42) : tuple42 != null);
            }
            return false;
        }

        public int hashCode() {
            return this.tupled().hashCode();
        }

        public String toString() {
            return new StringBuilder(3).append("URI").append(this.tupled().toString()).toString();
        }

        public Tuple4<List<Tuple2<String, Object>>, MongoConnectionOptions, List<String>, T> tupled() {
            long l;
            long l2;
            while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
                if (l2 == 0L) {
                    if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                    try {
                        Tuple4 tuple4;
                        this.tupled$lzy1 = tuple4 = Tuple4$.MODULE$.apply((Object)this.hosts().toList(), (Object)this.options(), this.ignoredOptions(), this.db());
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                        return tuple4;
                    }
                    catch (Throwable throwable) {
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                        throw throwable;
                    }
                }
                LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
            }
            return this.tupled$lzy1;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static interface URIBuilder<T> {
        public static URIBuilder<Option<String>> default() {
            return MongoConnection$URIBuilder$.MODULE$.default();
        }

        public static URIBuilder<String> requiredDB() {
            return MongoConnection$URIBuilder$.MODULE$.requiredDB();
        }

        public Future<URI<T>> apply(ListSet<Tuple2<String, Object>> var1, MongoConnectionOptions var2, List<String> var3, Option<String> var4);
    }

    public static final class URIParsingException
    extends Exception
    implements NoStackTrace {
        public URIParsingException(String message, Throwable cause) {
            super(message, cause);
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public URIParsingException(String message) {
            this(message, null);
        }
    }
}

