/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import reactivemongo.actors.pattern.package$;
import reactivemongo.api.Failover$;
import reactivemongo.api.FailoverStrategy;
import reactivemongo.api.MongoConnection;
import reactivemongo.api.RetryableFailure$;
import reactivemongo.util.LazyLogger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class Failover<A> {
    private final Function0<Future<A>> producer;
    private final MongoConnection connection;
    private final FailoverStrategy failoverStrategy;
    private final ExecutionContext ec;
    private final String lnm;
    private final Future future;

    public static <A> Failover<A> apply(MongoConnection mongoConnection, FailoverStrategy failoverStrategy, Function0<Future<A>> function0, ExecutionContext executionContext) {
        return Failover$.MODULE$.apply(mongoConnection, failoverStrategy, function0, executionContext);
    }

    public static LazyLogger.LazyLogger logger() {
        return Failover$.MODULE$.logger();
    }

    public Failover(Function0<Future<A>> producer, MongoConnection connection, FailoverStrategy failoverStrategy, ExecutionContext ec) {
        this.producer = producer;
        this.connection = connection;
        this.failoverStrategy = failoverStrategy;
        this.ec = ec;
        this.lnm = new StringBuilder(1).append(connection.supervisor()).append("/").append(connection.name()).toString();
        this.future = this.send(0);
    }

    public Future<A> future() {
        return this.future;
    }

    private Future<A> next() {
        Future future;
        try {
            future = (Future)this.producer.apply();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable producerErr = throwable3 = (Throwable)option.get();
                future = Future$.MODULE$.failed(producerErr);
            }
            throw throwable;
        }
        return future;
    }

    private Future<A> send(int n) {
        return this.next().map((Function1 & Serializable)_$1 -> Success$.MODULE$.apply(_$1), this.ec).recover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable err = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable err = throwable = x;
                return Failure$.MODULE$.apply(err);
            }
        }, this.ec).flatMap((Function1 & Serializable)x$1 -> {
            Option<Throwable> option;
            Try try_ = x$1;
            if (try_ != null && !(option = RetryableFailure$.MODULE$.unapply(try_)).isEmpty()) {
                Throwable throwable;
                Throwable e = throwable = (Throwable)option.get();
                if (n < this.failoverStrategy.retries()) {
                    int n = n + 1;
                    double delayFactor = this.failoverStrategy.delayFactor().apply$mcDI$sp(n);
                    FiniteDuration delay = (FiniteDuration)Duration$.MODULE$.unapply(this.failoverStrategy.initialDelay().$times(delayFactor)).fold(this::$anonfun$1, (Function1 & Serializable)t -> FiniteDuration$.MODULE$.apply(BoxesRunTime.unboxToLong((Object)t._1()), (TimeUnit)((Object)((Object)((Object)t._2())))));
                    Failover$.MODULE$.logger().trace((Function0<String>)((Function0 & Serializable)() -> this.send$$anonfun$2$$anonfun$1(n, delay)), (Function0<Throwable>)((Function0 & Serializable)() -> Failover.send$$anonfun$2$$anonfun$2(e)));
                    return package$.MODULE$.after(delay, this.connection.actorSystem().scheduler(), () -> this.send$$anonfun$2$$anonfun$3(n), this.ec);
                }
                Failover$.MODULE$.logger().error((Function0<String>)((Function0 & Serializable)this::send$$anonfun$2$$anonfun$4), (Function0<Throwable>)((Function0 & Serializable)() -> Failover.send$$anonfun$2$$anonfun$5(e)));
                return Future$.MODULE$.failed(e);
            }
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                Failover$.MODULE$.logger().trace((Function0<String>)((Function0 & Serializable)this::send$$anonfun$2$$anonfun$6), (Function0<Throwable>)((Function0 & Serializable)() -> Failover.send$$anonfun$2$$anonfun$7(e)));
                return Future$.MODULE$.failed(e);
            }
            if (try_ instanceof Success) {
                Object response = ((Success)try_).value();
                Failover$.MODULE$.logger().trace((Function0<String>)((Function0 & Serializable)this::send$$anonfun$2$$anonfun$8));
                return Future$.MODULE$.successful(response);
            }
            throw new MatchError((Object)try_);
        }, this.ec);
    }

    private final FiniteDuration $anonfun$1() {
        return this.failoverStrategy.initialDelay();
    }

    private final String send$$anonfun$2$$anonfun$1(int try$1, FiniteDuration delay$1) {
        return new StringBuilder(56).append("[").append(this.lnm).append("] Got an error, retrying... (try #").append(try$1).append(" is scheduled in ").append(delay$1.toMillis()).append(" ms)").toString();
    }

    private static final Throwable send$$anonfun$2$$anonfun$2(Throwable e$1) {
        return e$1;
    }

    private final Future send$$anonfun$2$$anonfun$3(int try$2) {
        return this.send(try$2);
    }

    private final String send$$anonfun$2$$anonfun$4() {
        return new StringBuilder(70).append("[").append(this.lnm).append("] Got an error, no more attempts to do. Completing with a failure... ").toString();
    }

    private static final Throwable send$$anonfun$2$$anonfun$5(Throwable e$2) {
        return e$2;
    }

    private final String send$$anonfun$2$$anonfun$6() {
        return new StringBuilder(60).append("[").append(this.lnm).append("] Got an non retryable error, completing with a failure... ").toString();
    }

    private static final Throwable send$$anonfun$2$$anonfun$7(Throwable e$3) {
        return e$3;
    }

    private final String send$$anonfun$2$$anonfun$8() {
        return new StringBuilder(41).append("[").append(this.lnm).append("] Got a successful result, completing...").toString();
    }
}

