/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.rabbit.converters.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.reactivecommons.async.commons.communications.Message;
import org.reactivecommons.async.commons.converters.json.JacksonMessageConverter;
import org.reactivecommons.async.commons.exceptions.MessageConversionException;
import org.reactivecommons.async.rabbit.RabbitMessage;

public class RabbitJacksonMessageConverter
extends JacksonMessageConverter {
    public RabbitJacksonMessageConverter(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    public Message toMessage(Object object) {
        byte[] bytes;
        if (object instanceof RabbitMessage) {
            return (RabbitMessage)object;
        }
        try {
            String jsonString = this.objectMapper.writeValueAsString(object);
            bytes = jsonString.getBytes(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new MessageConversionException("Failed to convert Message content", (Throwable)e);
        }
        RabbitMessage.RabbitMessageProperties props = new RabbitMessage.RabbitMessageProperties();
        if (object instanceof CloudEvent) {
            props.setContentType("application/cloudevents+json");
        } else {
            props.setContentType("application/json");
        }
        props.setContentEncoding(StandardCharsets.UTF_8.name());
        props.setContentLength(bytes.length);
        return new RabbitMessage(bytes, props, null);
    }
}

