/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.rabbit;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.reactivecommons.async.api.DynamicRegistry;
import org.reactivecommons.async.api.handlers.DomainEventHandler;
import org.reactivecommons.async.api.handlers.QueryHandler;
import org.reactivecommons.async.api.handlers.QueryHandlerDelegate;
import org.reactivecommons.async.api.handlers.registered.RegisteredEventListener;
import org.reactivecommons.async.api.handlers.registered.RegisteredQueryHandler;
import org.reactivecommons.async.commons.HandlerResolver;
import org.reactivecommons.async.commons.config.IBrokerConfigProps;
import org.reactivecommons.async.rabbit.communications.TopologyCreator;
import reactor.core.publisher.Mono;
import reactor.rabbitmq.BindingSpecification;

public class DynamicRegistryImp
implements DynamicRegistry {
    private final HandlerResolver resolver;
    private final TopologyCreator topologyCreator;
    private final IBrokerConfigProps props;

    public <T> Mono<Void> listenEvent(String eventName, DomainEventHandler<T> fn, Class<T> eventClass) {
        this.resolver.addEventListener(new RegisteredEventListener(eventName, fn, eventClass));
        return this.topologyCreator.bind(this.buildBindingSpecification(eventName)).then();
    }

    public <T, R> void serveQuery(String resource, QueryHandler<T, R> handler, Class<R> queryClass) {
        this.resolver.addQueryHandler(new RegisteredQueryHandler(resource, (ignored, message) -> handler.handle(message), queryClass));
    }

    public <R> void serveQuery(String resource, QueryHandlerDelegate<Void, R> handler, Class<R> queryClass) {
        this.resolver.addQueryHandler(new RegisteredQueryHandler(resource, handler, queryClass));
    }

    public Mono<Void> startListeningEvent(String eventName) {
        return this.topologyCreator.bind(this.buildBindingSpecification(eventName)).then();
    }

    public Mono<Void> stopListeningEvent(String eventName) {
        return this.topologyCreator.unbind(this.buildBindingSpecification(eventName)).then();
    }

    private BindingSpecification buildBindingSpecification(String eventName) {
        return BindingSpecification.binding((String)this.props.getDomainEventsExchangeName(), (String)eventName, (String)this.props.getEventsQueue());
    }

    @ConstructorProperties(value={"resolver", "topologyCreator", "props"})
    @Generated
    public DynamicRegistryImp(HandlerResolver resolver, TopologyCreator topologyCreator, IBrokerConfigProps props) {
        this.resolver = resolver;
        this.topologyCreator = topologyCreator;
        this.props = props;
    }
}

