/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.commons.utils.resolver;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import java.util.stream.Stream;
import lombok.Generated;
import org.reactivecommons.async.api.DefaultCommandHandler;
import org.reactivecommons.async.api.HandlerRegistry;
import org.reactivecommons.async.api.handlers.CommandHandler;
import org.reactivecommons.async.api.handlers.registered.RegisteredCommandHandler;
import org.reactivecommons.async.api.handlers.registered.RegisteredEventListener;
import org.reactivecommons.async.commons.HandlerResolver;

public final class HandlerResolverBuilder {
    @Generated
    private static final Logger log = Logger.getLogger(HandlerResolverBuilder.class.getName());

    public static HandlerResolver buildResolver(String domain, Map<String, HandlerRegistry> registries, final DefaultCommandHandler defaultCommandHandler) {
        ConcurrentMap queryHandlers = registries.values().stream().flatMap(r -> ((List)r.getHandlers().getOrDefault((Object)domain, List.of())).stream()).collect(ConcurrentHashMap::new, (map, handler) -> map.put(handler.getPath(), handler), ConcurrentHashMap::putAll);
        ConcurrentMap commandHandlers = registries.values().stream().flatMap(r -> ((List)r.getCommandHandlers().getOrDefault((Object)domain, List.of())).stream()).collect(ConcurrentHashMap::new, (map, handler) -> map.put(handler.getPath(), handler), ConcurrentHashMap::putAll);
        ConcurrentMap eventNotificationListener = registries.values().stream().flatMap(r -> ((List)r.getEventNotificationListener().getOrDefault((Object)domain, List.of())).stream()).collect(ConcurrentHashMap::new, (map, handler) -> map.put(handler.getPath(), handler), ConcurrentHashMap::putAll);
        ConcurrentMap<String, RegisteredEventListener<?, ?>> eventsToBind = HandlerResolverBuilder.getEventsToBind(domain, registries);
        ConcurrentMap<String, RegisteredEventListener<?, ?>> eventHandlers = HandlerResolverBuilder.getEventHandlersWithDynamics(domain, registries);
        return new HandlerResolver(queryHandlers, eventHandlers, eventsToBind, eventNotificationListener, commandHandlers){

            @Override
            public <T, D> RegisteredCommandHandler<T, D> getCommandHandler(String path) {
                RegisteredCommandHandler handler = super.getCommandHandler(path);
                return handler != null ? handler : new RegisteredCommandHandler("", (CommandHandler)defaultCommandHandler, Object.class);
            }
        };
    }

    private static ConcurrentMap<String, RegisteredEventListener<?, ?>> getEventHandlersWithDynamics(String domain, Map<String, HandlerRegistry> registries) {
        return registries.values().stream().flatMap(r -> Stream.concat(((List)r.getDomainEventListeners().getOrDefault((Object)domain, List.of())).stream(), HandlerResolverBuilder.getDynamics(domain, r))).collect(ConcurrentHashMap::new, (map, handler) -> map.put(handler.getPath(), handler), ConcurrentHashMap::putAll);
    }

    private static Stream<RegisteredEventListener<?, ?>> getDynamics(String domain, HandlerRegistry r) {
        return ((List)r.getDynamicEventHandlers().getOrDefault((Object)domain, List.of())).stream();
    }

    private static ConcurrentMap<String, RegisteredEventListener<?, ?>> getEventsToBind(String domain, Map<String, HandlerRegistry> registries) {
        return registries.values().stream().flatMap(r -> {
            if (r.getDomainEventListeners().containsKey((Object)domain)) {
                return ((List)r.getDomainEventListeners().get((Object)domain)).stream();
            }
            return Stream.empty();
        }).collect(ConcurrentHashMap::new, (map, handler) -> map.put(handler.getPath(), handler), ConcurrentHashMap::putAll);
    }

    @Generated
    private HandlerResolverBuilder() {
    }
}

