/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.commons.utils;

import java.beans.ConstructorProperties;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import org.reactivecommons.async.commons.utils.ArrayUtils;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.SignalType;

public class LoggerSubscriber<T>
extends BaseSubscriber<T> {
    @Generated
    private static final Logger log = Logger.getLogger(LoggerSubscriber.class.getName());
    private final String flowName;
    private static final String ON_COMPLETE_MSG = "%s: ##On Complete Hook!!";
    private static final String ON_ERROR_MSG = "%s: ##On Error Hook!! %s";
    private static final String ON_CANCEL_MSG = "%s: ##On Cancel Hook!!";
    private static final String ON_FINALLY_MSG = "%s: ##On Finally Hook! Signal type: %s";

    protected void hookOnComplete() {
        log.warning(this.format(ON_COMPLETE_MSG, new String[0]));
    }

    protected void hookOnError(Throwable throwable) {
        log.log(Level.SEVERE, this.format(ON_ERROR_MSG, throwable.getMessage()), throwable);
    }

    protected void hookOnCancel() {
        log.warning(this.format(ON_CANCEL_MSG, new String[0]));
    }

    protected void hookFinally(SignalType type) {
        log.warning(this.format(ON_FINALLY_MSG, type.name()));
    }

    private String format(String msg, String ... args) {
        return String.format(msg, ArrayUtils.prefixArray(this.flowName, args));
    }

    @ConstructorProperties(value={"flowName"})
    @Generated
    public LoggerSubscriber(String flowName) {
        this.flowName = flowName;
    }
}

