/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.commons.ext;

import org.reactivecommons.api.domain.Command;
import org.reactivecommons.api.domain.DomainEvent;
import org.reactivecommons.async.api.AsyncQuery;
import org.reactivecommons.async.commons.communications.Message;
import reactor.core.publisher.Mono;

public interface CustomReporter {
    public static final String COMMAND_CLASS = "org.reactivecommons.api.domain.Command";
    public static final String EVENT_CLASS = "org.reactivecommons.api.domain.DomainEvent";
    public static final String QUERY_CLASS = "org.reactivecommons.async.api.AsyncQuery";

    default public Mono<Void> reportError(Throwable ex, Message rawMessage, Object message, boolean redelivered) {
        String name = message.getClass().getName();
        return Mono.just((Object)name).filter(COMMAND_CLASS::equals).flatMap(n -> this.reportError(ex, rawMessage, (Command)message, redelivered)).switchIfEmpty(Mono.just((Object)name).filter(EVENT_CLASS::equals).flatMap(n -> this.reportError(ex, rawMessage, (DomainEvent)message, redelivered)).switchIfEmpty(Mono.just((Object)name).filter(QUERY_CLASS::equals).flatMap(n -> this.reportError(ex, rawMessage, (AsyncQuery)message, redelivered))));
    }

    default public void reportMetric(String type, String handlerPath, Long duration, boolean success) {
    }

    public Mono<Void> reportError(Throwable var1, Message var2, Command<?> var3, boolean var4);

    public Mono<Void> reportError(Throwable var1, Message var2, DomainEvent<?> var3, boolean var4);

    public Mono<Void> reportError(Throwable var1, Message var2, AsyncQuery<?> var3, boolean var4);
}

