/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.commons;

import java.util.function.Function;
import org.reactivecommons.async.api.From;
import org.reactivecommons.async.api.handlers.QueryHandlerDelegate;
import org.reactivecommons.async.commons.communications.Message;
import reactor.core.publisher.Mono;

public class QueryExecutor<T, M> {
    private final QueryHandlerDelegate<T, M> queryHandler;
    private final Function<Message, M> converter;

    public QueryExecutor(QueryHandlerDelegate<T, M> queryHandler, Function<Message, M> converter) {
        this.queryHandler = queryHandler;
        this.converter = converter;
    }

    public Mono<T> execute(Message rawMessage) {
        From from = new From();
        from.setCorrelationID(rawMessage.getProperties().getHeaders().getOrDefault("x-correlation-id", "").toString());
        from.setReplyID(rawMessage.getProperties().getHeaders().getOrDefault("x-reply_id", "").toString());
        return this.queryHandler.handle(from, this.converter.apply(rawMessage));
    }
}

