/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.mmtf.dataholders;

import java.io.Serializable;

public enum DsspType implements Serializable
{
    PI_HELIX("pi Helix", 0),
    BEND("Bend", 1),
    ALPHA_HELIX("alpha Helix", 2),
    EXTENDED("Extended", 3),
    HELIX_3_10("3-10 Helix", 4),
    BRIDGE("Bridge", 5),
    TURN("Turn", 6),
    COIL("Coil", 7),
    NULL_ENTRY("NA", -1);

    private String dsspType;
    private int dsspIndex;

    private DsspType(String inputDsspType, int inputDsspIndex) {
        this.setDsspType(inputDsspType);
        this.setDsspIndex(inputDsspIndex);
    }

    private void setDsspIndex(int inputDsspIndex) {
        this.dsspIndex = inputDsspIndex;
    }

    public String getDsspType() {
        return this.dsspType;
    }

    public int getDsspIndex() {
        return this.dsspIndex;
    }

    private void setDsspType(String inputDsspType) {
        this.dsspType = inputDsspType;
    }

    public static DsspType dsspTypeFromString(String dsspType) {
        if (dsspType == null) {
            return NULL_ENTRY;
        }
        for (DsspType et : DsspType.values()) {
            if (!dsspType.equals(et.dsspType)) continue;
            return et;
        }
        return NULL_ENTRY;
    }

    public static DsspType dsspTypeFromInt(int dsspType) {
        for (DsspType et : DsspType.values()) {
            if (dsspType != et.dsspIndex) continue;
            return et;
        }
        return NULL_ENTRY;
    }
}

